// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivAccessibility @DivModelInternalApi constructor (
    @JvmField final val description: Expression<String>? = null,
    @JvmField final val hint: Expression<String>? = null,
    @JvmField final val mode: Expression<Mode> = MODE_DEFAULT_VALUE, // default value: default
    @JvmField final val muteAfterAction: Expression<Boolean> = MUTE_AFTER_ACTION_DEFAULT_VALUE, // default value: false
    @JvmField final val stateDescription: Expression<String>? = null,
    @JvmField final val type: Type? = null,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "description", value = description)
        json.writeExpression(key = "hint", value = hint)
        json.writeExpression(key = "mode", value = mode, converter = { v: Mode -> Mode.toString(v) })
        json.writeExpression(key = "mute_after_action", value = muteAfterAction)
        json.writeExpression(key = "state_description", value = stateDescription)
        json.write(key = "type", value = type, converter = { v: Type -> Type.toString(v) })
        return json
    }

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(Mode.DEFAULT)
        private val MUTE_AFTER_ACTION_DEFAULT_VALUE = Expression.constant(false)

        private val TYPE_HELPER_MODE = TypeHelper.from(default = DivAccessibility.Mode.values().first()) { it is DivAccessibility.Mode }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivAccessibility {
            val logger = env.logger
            return DivAccessibility(
                description = JsonParser.readOptionalExpression(json, "description", logger, env, TYPE_HELPER_STRING),
                hint = JsonParser.readOptionalExpression(json, "hint", logger, env, TYPE_HELPER_STRING),
                mode = JsonParser.readOptionalExpression(json, "mode", Mode.Converter.FROM_STRING, logger, env, MODE_DEFAULT_VALUE, TYPE_HELPER_MODE) ?: MODE_DEFAULT_VALUE,
                muteAfterAction = JsonParser.readOptionalExpression(json, "mute_after_action", ANY_TO_BOOLEAN, logger, env, MUTE_AFTER_ACTION_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: MUTE_AFTER_ACTION_DEFAULT_VALUE,
                stateDescription = JsonParser.readOptionalExpression(json, "state_description", logger, env, TYPE_HELPER_STRING),
                type = JsonParser.readOptional(json, "type", Type.Converter.FROM_STRING, logger, env)
            )
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAccessibility(env, json = it) }
    }


    enum class Type(private val value: String) {
        NONE("none"),
        BUTTON("button"),
        IMAGE("image"),
        TEXT("text"),
        EDIT_TEXT("edit_text"),
        HEADER("header"),
        TAB_BAR("tab_bar"),
        LIST("list"),
        SELECT("select");

        companion object Converter {
            fun toString(obj: Type): String {
                return obj.value
            }

            fun fromString(string: String): Type? {
                return when (string) {
                    NONE.value -> NONE
                    BUTTON.value -> BUTTON
                    IMAGE.value -> IMAGE
                    TEXT.value -> TEXT
                    EDIT_TEXT.value -> EDIT_TEXT
                    HEADER.value -> HEADER
                    TAB_BAR.value -> TAB_BAR
                    LIST.value -> LIST
                    SELECT.value -> SELECT
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    NONE.value -> NONE
                    BUTTON.value -> BUTTON
                    IMAGE.value -> IMAGE
                    TEXT.value -> TEXT
                    EDIT_TEXT.value -> EDIT_TEXT
                    HEADER.value -> HEADER
                    TAB_BAR.value -> TAB_BAR
                    LIST.value -> LIST
                    SELECT.value -> SELECT
                    else -> null
                }
            }
        }
    }

    enum class Mode(private val value: String) {
        DEFAULT("default"),
        MERGE("merge"),
        EXCLUDE("exclude");

        companion object Converter {
            fun toString(obj: Mode): String {
                return obj.value
            }

            fun fromString(string: String): Mode? {
                return when (string) {
                    DEFAULT.value -> DEFAULT
                    MERGE.value -> MERGE
                    EXCLUDE.value -> EXCLUDE
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    DEFAULT.value -> DEFAULT
                    MERGE.value -> MERGE
                    EXCLUDE.value -> EXCLUDE
                    else -> null
                }
            }
        }
    }
}
