// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivAction @DivModelInternalApi constructor (
    @JvmField final val downloadCallbacks: DivDownloadCallbacks? = null,
    @JvmField final val isEnabled: Expression<Boolean> = IS_ENABLED_DEFAULT_VALUE, // default value: true
    @JvmField final val logId: String,
    @JvmField final val logUrl: Expression<Uri>? = null,
    @JvmField final val menuItems: List<MenuItem>? = null,
    @JvmField final val payload: JSONObject? = null,
    @JvmField final val referer: Expression<Uri>? = null,
    @JvmField final val target: Expression<Target>? = null,
    @JvmField final val typed: DivActionTyped? = null,
    @JvmField final val url: Expression<Uri>? = null,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "download_callbacks", value = downloadCallbacks)
        json.writeExpression(key = "is_enabled", value = isEnabled)
        json.write(key = "log_id", value = logId)
        json.writeExpression(key = "log_url", value = logUrl, converter = URI_TO_STRING)
        json.write(key = "menu_items", value = menuItems)
        json.write(key = "payload", value = payload)
        json.writeExpression(key = "referer", value = referer, converter = URI_TO_STRING)
        json.writeExpression(key = "target", value = target, converter = { v: Target -> Target.toString(v) })
        json.write(key = "typed", value = typed)
        json.writeExpression(key = "url", value = url, converter = URI_TO_STRING)
        return json
    }

    companion object {
        private val IS_ENABLED_DEFAULT_VALUE = Expression.constant(true)

        private val TYPE_HELPER_TARGET = TypeHelper.from(default = DivAction.Target.values().first()) { it is DivAction.Target }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivAction {
            val logger = env.logger
            return DivAction(
                downloadCallbacks = JsonParser.readOptional(json, "download_callbacks", DivDownloadCallbacks.CREATOR, logger, env),
                isEnabled = JsonParser.readOptionalExpression(json, "is_enabled", ANY_TO_BOOLEAN, logger, env, IS_ENABLED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: IS_ENABLED_DEFAULT_VALUE,
                logId = JsonParser.read(json, "log_id", logger, env),
                logUrl = JsonParser.readOptionalExpression(json, "log_url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                menuItems = JsonParser.readOptionalList(json, "menu_items", MenuItem.CREATOR, logger, env),
                payload = JsonParser.readOptional(json, "payload", logger, env),
                referer = JsonParser.readOptionalExpression(json, "referer", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                target = JsonParser.readOptionalExpression(json, "target", Target.Converter.FROM_STRING, logger, env, TYPE_HELPER_TARGET),
                typed = JsonParser.readOptional(json, "typed", DivActionTyped.CREATOR, logger, env),
                url = JsonParser.readOptionalExpression(json, "url", STRING_TO_URI, logger, env, TYPE_HELPER_URI)
            )
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAction(env, json = it) }
    }


    @Mockable
    class MenuItem @DivModelInternalApi constructor (
        @JvmField final val action: DivAction? = null,
        @JvmField final val actions: List<DivAction>? = null,
        @JvmField final val text: Expression<String>,
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "action", value = action)
            json.write(key = "actions", value = actions)
            json.writeExpression(key = "text", value = text)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): MenuItem {
                val logger = env.logger
                return MenuItem(
                    action = JsonParser.readOptional(json, "action", DivAction.CREATOR, logger, env),
                    actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, logger, env),
                    text = JsonParser.readExpression(json, "text", logger, env, TYPE_HELPER_STRING)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> MenuItem(env, json = it) }
        }

    }

    enum class Target(private val value: String) {
        SELF("_self"),
        BLANK("_blank");

        companion object Converter {
            fun toString(obj: Target): String {
                return obj.value
            }

            fun fromString(string: String): Target? {
                return when (string) {
                    SELF.value -> SELF
                    BLANK.value -> BLANK
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    SELF.value -> SELF
                    BLANK.value -> BLANK
                    else -> null
                }
            }
        }
    }
}
