// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivCircleShapeTemplate : JSONSerializable, JsonTemplate<DivCircleShape> {
    @JvmField final val backgroundColor: Field<Expression<Int>>
    @JvmField final val radius: Field<DivFixedSizeTemplate> // default value: DivFixedSize(value = Expression.constant(10L))
    @JvmField final val stroke: Field<DivStrokeTemplate>

    constructor (
        env: ParsingEnvironment,
        parent: DivCircleShapeTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        backgroundColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "background_color", topLevel, parent?.backgroundColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        radius = JsonTemplateParser.readOptionalField(json, "radius", topLevel, parent?.radius, DivFixedSizeTemplate.CREATOR, logger, env)
        stroke = JsonTemplateParser.readOptionalField(json, "stroke", topLevel, parent?.stroke, DivStrokeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivCircleShape {
        return DivCircleShape(
            backgroundColor = backgroundColor.resolveOptional(env = env, key = "background_color", data = rawData, reader = BACKGROUND_COLOR_READER),
            radius = radius.resolveOptionalTemplate(env = env, key = "radius", data = rawData, reader = RADIUS_READER) ?: RADIUS_DEFAULT_VALUE,
            stroke = stroke.resolveOptionalTemplate(env = env, key = "stroke", data = rawData, reader = STROKE_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "background_color", field = backgroundColor, converter = COLOR_INT_TO_STRING)
        json.writeField(key = "radius", field = radius)
        json.writeField(key = "stroke", field = stroke)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "circle"

        private val RADIUS_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(10L))

        val BACKGROUND_COLOR_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
        val RADIUS_READER: Reader<DivFixedSize> = { key, json, env -> JsonParser.readOptional(json, key, DivFixedSize.CREATOR, env.logger, env) ?: RADIUS_DEFAULT_VALUE }
        val STROKE_READER: Reader<DivStroke?> = { key, json, env -> JsonParser.readOptional(json, key, DivStroke.CREATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivCircleShapeTemplate(env, json = it) }
    }

}
