// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivCollectionItemBuilder @DivModelInternalApi constructor (
    @JvmField final val data: Expression<JSONArray>,
    @JvmField final val dataElementPrefix: String = DATA_ELEMENT_PREFIX_DEFAULT_VALUE, // default value: it.
    @JvmField final val prototypes: List<Prototype>, // at least 1 elements
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "data", value = data)
        json.write(key = "data_element_prefix", value = dataElementPrefix)
        json.write(key = "prototypes", value = prototypes)
        return json
    }

    companion object {
        private val DATA_ELEMENT_PREFIX_DEFAULT_VALUE = "it."

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivCollectionItemBuilder {
            val logger = env.logger
            return DivCollectionItemBuilder(
                data = JsonParser.readExpression(json, "data", logger, env, TYPE_HELPER_JSON_ARRAY),
                dataElementPrefix = JsonParser.readOptional(json, "data_element_prefix", logger, env) ?: DATA_ELEMENT_PREFIX_DEFAULT_VALUE,
                prototypes = JsonParser.readList(json, "prototypes", Prototype.CREATOR, PROTOTYPES_VALIDATOR, logger, env)
            )
        }

        private val PROTOTYPES_VALIDATOR = ListValidator<DivCollectionItemBuilder.Prototype> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivCollectionItemBuilder(env, json = it) }
    }


    @Mockable
    class Prototype @DivModelInternalApi constructor (
        @JvmField final val div: Div,
        @JvmField final val selector: Expression<Boolean> = SELECTOR_DEFAULT_VALUE, // default value: true
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "div", value = div)
            json.writeExpression(key = "selector", value = selector)
            return json
        }

        companion object {
            private val SELECTOR_DEFAULT_VALUE = Expression.constant(true)

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Prototype {
                val logger = env.logger
                return Prototype(
                    div = JsonParser.read(json, "div", Div.CREATOR, logger, env),
                    selector = JsonParser.readOptionalExpression(json, "selector", ANY_TO_BOOLEAN, logger, env, SELECTOR_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SELECTOR_DEFAULT_VALUE
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Prototype(env, json = it) }
        }

    }
}
