// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivDisappearActionTemplate : JSONSerializable, JsonTemplate<DivDisappearAction> {
    @JvmField final val disappearDuration: Field<Expression<Long>> // constraint: number >= 0; default value: 800
    @JvmField final val downloadCallbacks: Field<DivDownloadCallbacksTemplate>
    @JvmField final val isEnabled: Field<Expression<Boolean>> // default value: true
    @JvmField final val logId: Field<String>
    @JvmField final val logLimit: Field<Expression<Long>> // constraint: number >= 0; default value: 1
    @JvmField final val payload: Field<JSONObject>
    @JvmField final val referer: Field<Expression<Uri>>
    @JvmField final val typed: Field<DivActionTypedTemplate>
    @JvmField final val url: Field<Expression<Uri>>
    @JvmField final val visibilityPercentage: Field<Expression<Long>> // constraint: number >= 0 && number < 100; default value: 0

    constructor (
        env: ParsingEnvironment,
        parent: DivDisappearActionTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        disappearDuration = JsonTemplateParser.readOptionalFieldWithExpression(json, "disappear_duration", topLevel, parent?.disappearDuration, NUMBER_TO_INT, DISAPPEAR_DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        downloadCallbacks = JsonTemplateParser.readOptionalField(json, "download_callbacks", topLevel, parent?.downloadCallbacks, DivDownloadCallbacksTemplate.CREATOR, logger, env)
        isEnabled = JsonTemplateParser.readOptionalFieldWithExpression(json, "is_enabled", topLevel, parent?.isEnabled, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        logId = JsonTemplateParser.readField(json, "log_id", topLevel, parent?.logId, logger, env)
        logLimit = JsonTemplateParser.readOptionalFieldWithExpression(json, "log_limit", topLevel, parent?.logLimit, NUMBER_TO_INT, LOG_LIMIT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        payload = JsonTemplateParser.readOptionalField(json, "payload", topLevel, parent?.payload, logger, env)
        referer = JsonTemplateParser.readOptionalFieldWithExpression(json, "referer", topLevel, parent?.referer, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        typed = JsonTemplateParser.readOptionalField(json, "typed", topLevel, parent?.typed, DivActionTypedTemplate.CREATOR, logger, env)
        url = JsonTemplateParser.readOptionalFieldWithExpression(json, "url", topLevel, parent?.url, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        visibilityPercentage = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility_percentage", topLevel, parent?.visibilityPercentage, NUMBER_TO_INT, VISIBILITY_PERCENTAGE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivDisappearAction {
        return DivDisappearAction(
            disappearDuration = disappearDuration.resolveOptional(env = env, key = "disappear_duration", data = rawData, reader = DISAPPEAR_DURATION_READER) ?: DISAPPEAR_DURATION_DEFAULT_VALUE,
            downloadCallbacks = downloadCallbacks.resolveOptionalTemplate(env = env, key = "download_callbacks", data = rawData, reader = DOWNLOAD_CALLBACKS_READER),
            isEnabled = isEnabled.resolveOptional(env = env, key = "is_enabled", data = rawData, reader = IS_ENABLED_READER) ?: IS_ENABLED_DEFAULT_VALUE,
            logId = logId.resolve(env = env, key = "log_id", data = rawData, reader = LOG_ID_READER),
            logLimit = logLimit.resolveOptional(env = env, key = "log_limit", data = rawData, reader = LOG_LIMIT_READER) ?: LOG_LIMIT_DEFAULT_VALUE,
            payload = payload.resolveOptional(env = env, key = "payload", data = rawData, reader = PAYLOAD_READER),
            referer = referer.resolveOptional(env = env, key = "referer", data = rawData, reader = REFERER_READER),
            typed = typed.resolveOptionalTemplate(env = env, key = "typed", data = rawData, reader = TYPED_READER),
            url = url.resolveOptional(env = env, key = "url", data = rawData, reader = URL_READER),
            visibilityPercentage = visibilityPercentage.resolveOptional(env = env, key = "visibility_percentage", data = rawData, reader = VISIBILITY_PERCENTAGE_READER) ?: VISIBILITY_PERCENTAGE_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "disappear_duration", field = disappearDuration)
        json.writeField(key = "download_callbacks", field = downloadCallbacks)
        json.writeFieldWithExpression(key = "is_enabled", field = isEnabled)
        json.writeField(key = "log_id", field = logId)
        json.writeFieldWithExpression(key = "log_limit", field = logLimit)
        json.writeField(key = "payload", field = payload)
        json.writeFieldWithExpression(key = "referer", field = referer, converter = URI_TO_STRING)
        json.writeField(key = "typed", field = typed)
        json.writeFieldWithExpression(key = "url", field = url, converter = URI_TO_STRING)
        json.writeFieldWithExpression(key = "visibility_percentage", field = visibilityPercentage)
        return json
    }

    companion object {
        private val DISAPPEAR_DURATION_DEFAULT_VALUE = Expression.constant(800L)
        private val IS_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        private val LOG_LIMIT_DEFAULT_VALUE = Expression.constant(1L)
        private val VISIBILITY_PERCENTAGE_DEFAULT_VALUE = Expression.constant(0L)

        private val DISAPPEAR_DURATION_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val DISAPPEAR_DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LOG_LIMIT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LOG_LIMIT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val VISIBILITY_PERCENTAGE_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 && it < 100 }
        private val VISIBILITY_PERCENTAGE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 && it < 100 }

        val DISAPPEAR_DURATION_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, DISAPPEAR_DURATION_VALIDATOR, env.logger, env, DISAPPEAR_DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DISAPPEAR_DURATION_DEFAULT_VALUE }
        val DOWNLOAD_CALLBACKS_READER: Reader<DivDownloadCallbacks?> = { key, json, env -> JsonParser.readOptional(json, key, DivDownloadCallbacks.CREATOR, env.logger, env) }
        val IS_ENABLED_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, IS_ENABLED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: IS_ENABLED_DEFAULT_VALUE }
        val LOG_ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val LOG_LIMIT_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, LOG_LIMIT_VALIDATOR, env.logger, env, LOG_LIMIT_DEFAULT_VALUE, TYPE_HELPER_INT) ?: LOG_LIMIT_DEFAULT_VALUE }
        val PAYLOAD_READER: Reader<JSONObject?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val REFERER_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val TYPED_READER: Reader<DivActionTyped?> = { key, json, env -> JsonParser.readOptional(json, key, DivActionTyped.CREATOR, env.logger, env) }
        val URL_READER: Reader<Expression<Uri>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val VISIBILITY_PERCENTAGE_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, VISIBILITY_PERCENTAGE_VALIDATOR, env.logger, env, VISIBILITY_PERCENTAGE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: VISIBILITY_PERCENTAGE_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivDisappearActionTemplate(env, json = it) }
    }

}
