// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivFilter : JSONSerializable {
    class Blur(val value: DivBlur) : DivFilter()
    class RtlMirror(val value: DivFilterRtlMirror) : DivFilter()

    fun value(): Any {
        return when (this) {
            is Blur -> value
            is RtlMirror -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Blur -> value.writeToJSON()
            is RtlMirror -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivFilter {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivBlur.TYPE -> return Blur(DivBlur(env, json))
                DivFilterRtlMirror.TYPE -> return RtlMirror(DivFilterRtlMirror(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivFilterTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivFilter(env, json = it) }
    }
}
