// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivImageBackground @DivModelInternalApi constructor (
    @JvmField final val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val contentAlignmentHorizontal: Expression<DivAlignmentHorizontal> = CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: center
    @JvmField final val contentAlignmentVertical: Expression<DivAlignmentVertical> = CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: center
    @JvmField final val filters: List<DivFilter>? = null,
    @JvmField final val imageUrl: Expression<Uri>,
    @JvmField final val preloadRequired: Expression<Boolean> = PRELOAD_REQUIRED_DEFAULT_VALUE, // default value: false
    @JvmField final val scale: Expression<DivImageScale> = SCALE_DEFAULT_VALUE, // default value: fill
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "alpha", value = alpha)
        json.writeExpression(key = "content_alignment_horizontal", value = contentAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "content_alignment_vertical", value = contentAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.write(key = "filters", value = filters)
        json.writeExpression(key = "image_url", value = imageUrl, converter = URI_TO_STRING)
        json.writeExpression(key = "preload_required", value = preloadRequired)
        json.writeExpression(key = "scale", value = scale, converter = { v: DivImageScale -> DivImageScale.toString(v) })
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "image"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.CENTER)
        private val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        private val SCALE_DEFAULT_VALUE = Expression.constant(DivImageScale.FILL)

        private val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_SCALE = TypeHelper.from(default = DivImageScale.values().first()) { it is DivImageScale }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivImageBackground {
            val logger = env.logger
            return DivImageBackground(
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                contentAlignmentHorizontal = JsonParser.readOptionalExpression(json, "content_alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonParser.readOptionalExpression(json, "content_alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                filters = JsonParser.readOptionalList(json, "filters", DivFilter.CREATOR, logger, env),
                imageUrl = JsonParser.readExpression(json, "image_url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                preloadRequired = JsonParser.readOptionalExpression(json, "preload_required", ANY_TO_BOOLEAN, logger, env, PRELOAD_REQUIRED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                scale = JsonParser.readOptionalExpression(json, "scale", DivImageScale.Converter.FROM_STRING, logger, env, SCALE_DEFAULT_VALUE, TYPE_HELPER_SCALE) ?: SCALE_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivImageBackground(env, json = it) }
    }

}
