// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivIndicator @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility = ACCESSIBILITY_DEFAULT_VALUE,
    @JvmField final val activeItemColor: Expression<Int> = ACTIVE_ITEM_COLOR_DEFAULT_VALUE, // default value: #ffdc60
    @JvmField final val activeItemSize: Expression<Double> = ACTIVE_ITEM_SIZE_DEFAULT_VALUE, // constraint: number > 0; default value: 1.3
    @JvmField final val activeShape: DivRoundedRectangleShape? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val animation: Expression<Animation> = ANIMATION_DEFAULT_VALUE, // default value: scale
    override val background: List<DivBackground>? = null,
    override val border: DivBorder = BORDER_DEFAULT_VALUE,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null,
    @JvmField final val inactiveItemColor: Expression<Int> = INACTIVE_ITEM_COLOR_DEFAULT_VALUE, // default value: #33919cb5
    @JvmField final val inactiveMinimumShape: DivRoundedRectangleShape? = null,
    @JvmField final val inactiveShape: DivRoundedRectangleShape? = null,
    @JvmField final val itemsPlacement: DivIndicatorItemPlacement? = null,
    override val margins: DivEdgeInsets = MARGINS_DEFAULT_VALUE,
    @JvmField final val minimumItemSize: Expression<Double> = MINIMUM_ITEM_SIZE_DEFAULT_VALUE, // constraint: number > 0; default value: 0.5
    override val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE,
    @JvmField final val pagerId: String? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    override val selectedActions: List<DivAction>? = null,
    @JvmField final val shape: DivShape = SHAPE_DEFAULT_VALUE, // default value: DivShape.RoundedRectangle(DivRoundedRectangleShape())
    @JvmField final val spaceBetweenCenters: DivFixedSize = SPACE_BETWEEN_CENTERS_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(15L))
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform = TRANSFORM_DEFAULT_VALUE,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, DivBase {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "active_item_color", value = activeItemColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "active_item_size", value = activeItemSize)
        json.write(key = "active_shape", value = activeShape)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.writeExpression(key = "animation", value = animation, converter = { v: Animation -> Animation.toString(v) })
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.writeExpression(key = "inactive_item_color", value = inactiveItemColor, converter = COLOR_INT_TO_STRING)
        json.write(key = "inactive_minimum_shape", value = inactiveMinimumShape)
        json.write(key = "inactive_shape", value = inactiveShape)
        json.write(key = "items_placement", value = itemsPlacement)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "minimum_item_size", value = minimumItemSize)
        json.write(key = "paddings", value = paddings)
        json.write(key = "pager_id", value = pagerId)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "shape", value = shape)
        json.write(key = "space_between_centers", value = spaceBetweenCenters)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "indicator"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ACTIVE_ITEM_COLOR_DEFAULT_VALUE = Expression.constant(0xffdc60.toInt())
        private val ACTIVE_ITEM_SIZE_DEFAULT_VALUE = Expression.constant(1.3)
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val ANIMATION_DEFAULT_VALUE = Expression.constant(Animation.SCALE)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val INACTIVE_ITEM_COLOR_DEFAULT_VALUE = Expression.constant(0x33919cb5.toInt())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val MINIMUM_ITEM_SIZE_DEFAULT_VALUE = Expression.constant(0.5)
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SHAPE_DEFAULT_VALUE = DivShape.RoundedRectangle(DivRoundedRectangleShape())
        private val SPACE_BETWEEN_CENTERS_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(15L))
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_ANIMATION = TypeHelper.from(default = DivIndicator.Animation.values().first()) { it is DivIndicator.Animation }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivIndicator {
            val logger = env.logger
            return DivIndicator(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE,
                activeItemColor = JsonParser.readOptionalExpression(json, "active_item_color", STRING_TO_COLOR_INT, logger, env, ACTIVE_ITEM_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: ACTIVE_ITEM_COLOR_DEFAULT_VALUE,
                activeItemSize = JsonParser.readOptionalExpression(json, "active_item_size", NUMBER_TO_DOUBLE, ACTIVE_ITEM_SIZE_VALIDATOR, logger, env, ACTIVE_ITEM_SIZE_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ACTIVE_ITEM_SIZE_DEFAULT_VALUE,
                activeShape = JsonParser.readOptional(json, "active_shape", DivRoundedRectangleShape.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                animation = JsonParser.readOptionalExpression(json, "animation", Animation.Converter.FROM_STRING, logger, env, ANIMATION_DEFAULT_VALUE, TYPE_HELPER_ANIMATION) ?: ANIMATION_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env) ?: BORDER_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", logger, env),
                inactiveItemColor = JsonParser.readOptionalExpression(json, "inactive_item_color", STRING_TO_COLOR_INT, logger, env, INACTIVE_ITEM_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: INACTIVE_ITEM_COLOR_DEFAULT_VALUE,
                inactiveMinimumShape = JsonParser.readOptional(json, "inactive_minimum_shape", DivRoundedRectangleShape.CREATOR, logger, env),
                inactiveShape = JsonParser.readOptional(json, "inactive_shape", DivRoundedRectangleShape.CREATOR, logger, env),
                itemsPlacement = JsonParser.readOptional(json, "items_placement", DivIndicatorItemPlacement.CREATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env) ?: MARGINS_DEFAULT_VALUE,
                minimumItemSize = JsonParser.readOptionalExpression(json, "minimum_item_size", NUMBER_TO_DOUBLE, MINIMUM_ITEM_SIZE_VALIDATOR, logger, env, MINIMUM_ITEM_SIZE_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: MINIMUM_ITEM_SIZE_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE,
                pagerId = JsonParser.readOptional(json, "pager_id", logger, env),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                shape = JsonParser.readOptional(json, "shape", DivShape.CREATOR, logger, env) ?: SHAPE_DEFAULT_VALUE,
                spaceBetweenCenters = JsonParser.readOptional(json, "space_between_centers", DivFixedSize.CREATOR, logger, env) ?: SPACE_BETWEEN_CENTERS_DEFAULT_VALUE,
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env) ?: TRANSFORM_DEFAULT_VALUE,
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ACTIVE_ITEM_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val ACTIVE_ITEM_SIZE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val MINIMUM_ITEM_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val MINIMUM_ITEM_SIZE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivIndicator(env, json = it) }
    }


    enum class Animation(private val value: String) {
        SCALE("scale"),
        WORM("worm"),
        SLIDER("slider");

        companion object Converter {
            fun toString(obj: Animation): String {
                return obj.value
            }

            fun fromString(string: String): Animation? {
                return when (string) {
                    SCALE.value -> SCALE
                    WORM.value -> WORM
                    SLIDER.value -> SLIDER
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    SCALE.value -> SCALE
                    WORM.value -> WORM
                    SLIDER.value -> SLIDER
                    else -> null
                }
            }
        }
    }
}
