// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivInputMask : JSONSerializable {
    class FixedLength(val value: DivFixedLengthInputMask) : DivInputMask()
    class Currency(val value: DivCurrencyInputMask) : DivInputMask()
    class Phone(val value: DivPhoneInputMask) : DivInputMask()

    fun value(): DivInputMaskBase {
        return when (this) {
            is FixedLength -> value
            is Currency -> value
            is Phone -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is FixedLength -> value.writeToJSON()
            is Currency -> value.writeToJSON()
            is Phone -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivInputMask {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivFixedLengthInputMask.TYPE -> return FixedLength(DivFixedLengthInputMask(env, json))
                DivCurrencyInputMask.TYPE -> return Currency(DivCurrencyInputMask(env, json))
                DivPhoneInputMask.TYPE -> return Phone(DivPhoneInputMask(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivInputMaskTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivInputMask(env, json = it) }
    }
}
