// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivInputTemplate : JSONSerializable, JsonTemplate<DivInput> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val background: Field<List<DivBackgroundTemplate>>
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val disappearActions: Field<List<DivDisappearActionTemplate>>
    @JvmField final val extensions: Field<List<DivExtensionTemplate>>
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val fontFamily: Field<Expression<String>>
    @JvmField final val fontSize: Field<Expression<Long>> // constraint: number >= 0; default value: 12
    @JvmField final val fontSizeUnit: Field<Expression<DivSizeUnit>> // default value: sp
    @JvmField final val fontWeight: Field<Expression<DivFontWeight>> // default value: regular
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val highlightColor: Field<Expression<Int>>
    @JvmField final val hintColor: Field<Expression<Int>> // default value: #73000000
    @JvmField final val hintText: Field<Expression<String>>
    @JvmField final val id: Field<String>
    @JvmField final val keyboardType: Field<Expression<DivInput.KeyboardType>> // default value: multi_line_text
    @JvmField final val letterSpacing: Field<Expression<Double>> // default value: 0
    @JvmField final val lineHeight: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val mask: Field<DivInputMaskTemplate>
    @JvmField final val maxVisibleLines: Field<Expression<Long>> // constraint: number > 0
    @JvmField final val nativeInterface: Field<NativeInterfaceTemplate>
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val rowSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val selectAllOnFocus: Field<Expression<Boolean>> // default value: false
    @JvmField final val selectedActions: Field<List<DivActionTemplate>>
    @JvmField final val textAlignmentHorizontal: Field<Expression<DivAlignmentHorizontal>> // default value: start
    @JvmField final val textAlignmentVertical: Field<Expression<DivAlignmentVertical>> // default value: center
    @JvmField final val textColor: Field<Expression<Int>> // default value: #FF000000
    @JvmField final val textVariable: Field<String>
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>>
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val validators: Field<List<DivInputValidatorTemplate>>
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>>
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivInputTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        disappearActions = JsonTemplateParser.readOptionalListField(json, "disappear_actions", topLevel, parent?.disappearActions, DivDisappearActionTemplate.CREATOR, logger, env)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        fontFamily = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_family", topLevel, parent?.fontFamily, logger, env, TYPE_HELPER_STRING)
        fontSize = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size", topLevel, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        fontSizeUnit = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size_unit", topLevel, parent?.fontSizeUnit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_SIZE_UNIT)
        fontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_weight", topLevel, parent?.fontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_WEIGHT)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        highlightColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "highlight_color", topLevel, parent?.highlightColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        hintColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "hint_color", topLevel, parent?.hintColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        hintText = JsonTemplateParser.readOptionalFieldWithExpression(json, "hint_text", topLevel, parent?.hintText, logger, env, TYPE_HELPER_STRING)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, logger, env)
        keyboardType = JsonTemplateParser.readOptionalFieldWithExpression(json, "keyboard_type", topLevel, parent?.keyboardType, DivInput.KeyboardType.Converter.FROM_STRING, logger, env, TYPE_HELPER_KEYBOARD_TYPE)
        letterSpacing = JsonTemplateParser.readOptionalFieldWithExpression(json, "letter_spacing", topLevel, parent?.letterSpacing, NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
        lineHeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "line_height", topLevel, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        mask = JsonTemplateParser.readOptionalField(json, "mask", topLevel, parent?.mask, DivInputMaskTemplate.CREATOR, logger, env)
        maxVisibleLines = JsonTemplateParser.readOptionalFieldWithExpression(json, "max_visible_lines", topLevel, parent?.maxVisibleLines, NUMBER_TO_INT, MAX_VISIBLE_LINES_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        nativeInterface = JsonTemplateParser.readOptionalField(json, "native_interface", topLevel, parent?.nativeInterface, NativeInterfaceTemplate.CREATOR, logger, env)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        selectAllOnFocus = JsonTemplateParser.readOptionalFieldWithExpression(json, "select_all_on_focus", topLevel, parent?.selectAllOnFocus, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, logger, env)
        textAlignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_alignment_horizontal", topLevel, parent?.textAlignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL)
        textAlignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_alignment_vertical", topLevel, parent?.textAlignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL)
        textColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_color", topLevel, parent?.textColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        textVariable = JsonTemplateParser.readField(json, "text_variable", topLevel, parent?.textVariable, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        validators = JsonTemplateParser.readOptionalListField(json, "validators", topLevel, parent?.validators, DivInputValidatorTemplate.CREATOR, logger, env)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivInput {
        return DivInput(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = rawData, reader = ACCESSIBILITY_READER) ?: ACCESSIBILITY_DEFAULT_VALUE,
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = rawData, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = rawData, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = rawData, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = rawData, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = rawData, reader = BORDER_READER) ?: BORDER_DEFAULT_VALUE,
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = rawData, reader = COLUMN_SPAN_READER),
            disappearActions = disappearActions.resolveOptionalTemplateList(env = env, key = "disappear_actions", data = rawData, reader = DISAPPEAR_ACTIONS_READER),
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = rawData, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = rawData, reader = FOCUS_READER),
            fontFamily = fontFamily.resolveOptional(env = env, key = "font_family", data = rawData, reader = FONT_FAMILY_READER),
            fontSize = fontSize.resolveOptional(env = env, key = "font_size", data = rawData, reader = FONT_SIZE_READER) ?: FONT_SIZE_DEFAULT_VALUE,
            fontSizeUnit = fontSizeUnit.resolveOptional(env = env, key = "font_size_unit", data = rawData, reader = FONT_SIZE_UNIT_READER) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
            fontWeight = fontWeight.resolveOptional(env = env, key = "font_weight", data = rawData, reader = FONT_WEIGHT_READER) ?: FONT_WEIGHT_DEFAULT_VALUE,
            height = height.resolveOptionalTemplate(env = env, key = "height", data = rawData, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            highlightColor = highlightColor.resolveOptional(env = env, key = "highlight_color", data = rawData, reader = HIGHLIGHT_COLOR_READER),
            hintColor = hintColor.resolveOptional(env = env, key = "hint_color", data = rawData, reader = HINT_COLOR_READER) ?: HINT_COLOR_DEFAULT_VALUE,
            hintText = hintText.resolveOptional(env = env, key = "hint_text", data = rawData, reader = HINT_TEXT_READER),
            id = id.resolveOptional(env = env, key = "id", data = rawData, reader = ID_READER),
            keyboardType = keyboardType.resolveOptional(env = env, key = "keyboard_type", data = rawData, reader = KEYBOARD_TYPE_READER) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
            letterSpacing = letterSpacing.resolveOptional(env = env, key = "letter_spacing", data = rawData, reader = LETTER_SPACING_READER) ?: LETTER_SPACING_DEFAULT_VALUE,
            lineHeight = lineHeight.resolveOptional(env = env, key = "line_height", data = rawData, reader = LINE_HEIGHT_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = rawData, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
            mask = mask.resolveOptionalTemplate(env = env, key = "mask", data = rawData, reader = MASK_READER),
            maxVisibleLines = maxVisibleLines.resolveOptional(env = env, key = "max_visible_lines", data = rawData, reader = MAX_VISIBLE_LINES_READER),
            nativeInterface = nativeInterface.resolveOptionalTemplate(env = env, key = "native_interface", data = rawData, reader = NATIVE_INTERFACE_READER),
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = rawData, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE,
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = rawData, reader = ROW_SPAN_READER),
            selectAllOnFocus = selectAllOnFocus.resolveOptional(env = env, key = "select_all_on_focus", data = rawData, reader = SELECT_ALL_ON_FOCUS_READER) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = rawData, reader = SELECTED_ACTIONS_READER),
            textAlignmentHorizontal = textAlignmentHorizontal.resolveOptional(env = env, key = "text_alignment_horizontal", data = rawData, reader = TEXT_ALIGNMENT_HORIZONTAL_READER) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
            textAlignmentVertical = textAlignmentVertical.resolveOptional(env = env, key = "text_alignment_vertical", data = rawData, reader = TEXT_ALIGNMENT_VERTICAL_READER) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
            textColor = textColor.resolveOptional(env = env, key = "text_color", data = rawData, reader = TEXT_COLOR_READER) ?: TEXT_COLOR_DEFAULT_VALUE,
            textVariable = textVariable.resolve(env = env, key = "text_variable", data = rawData, reader = TEXT_VARIABLE_READER),
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = rawData, reader = TOOLTIPS_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = rawData, reader = TRANSFORM_READER) ?: TRANSFORM_DEFAULT_VALUE,
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = rawData, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = rawData, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = rawData, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = rawData, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            validators = validators.resolveOptionalTemplateList(env = env, key = "validators", data = rawData, reader = VALIDATORS_READER),
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = rawData, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = rawData, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = rawData, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = rawData, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeField(key = "disappear_actions", field = disappearActions)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeFieldWithExpression(key = "font_family", field = fontFamily)
        json.writeFieldWithExpression(key = "font_size", field = fontSize)
        json.writeFieldWithExpression(key = "font_size_unit", field = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeFieldWithExpression(key = "font_weight", field = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
        json.writeField(key = "height", field = height)
        json.writeFieldWithExpression(key = "highlight_color", field = highlightColor, converter = COLOR_INT_TO_STRING)
        json.writeFieldWithExpression(key = "hint_color", field = hintColor, converter = COLOR_INT_TO_STRING)
        json.writeFieldWithExpression(key = "hint_text", field = hintText)
        json.writeField(key = "id", field = id)
        json.writeFieldWithExpression(key = "keyboard_type", field = keyboardType, converter = { v: DivInput.KeyboardType -> DivInput.KeyboardType.toString(v) })
        json.writeFieldWithExpression(key = "letter_spacing", field = letterSpacing)
        json.writeFieldWithExpression(key = "line_height", field = lineHeight)
        json.writeField(key = "margins", field = margins)
        json.writeField(key = "mask", field = mask)
        json.writeFieldWithExpression(key = "max_visible_lines", field = maxVisibleLines)
        json.writeField(key = "native_interface", field = nativeInterface)
        json.writeField(key = "paddings", field = paddings)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeFieldWithExpression(key = "select_all_on_focus", field = selectAllOnFocus)
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeFieldWithExpression(key = "text_alignment_horizontal", field = textAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "text_alignment_vertical", field = textAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "text_color", field = textColor, converter = COLOR_INT_TO_STRING)
        json.writeField(key = "text_variable", field = textVariable)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "transform", field = transform)
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeField(key = "validators", field = validators)
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "input"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        private val KEYBOARD_TYPE_DEFAULT_VALUE = Expression.constant(DivInput.KeyboardType.MULTI_LINE_TEXT)
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SELECT_ALL_ON_FOCUS_DEFAULT_VALUE = Expression.constant(false)
        private val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        private val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        private val TYPE_HELPER_KEYBOARD_TYPE = TypeHelper.from(default = DivInput.KeyboardType.values().first()) { it is DivInput.KeyboardType }
        private val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val MAX_VISIBLE_LINES_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val MAX_VISIBLE_LINES_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) ?: BORDER_DEFAULT_VALUE }
        val COLUMN_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val DISAPPEAR_ACTIONS_READER: Reader<List<DivDisappearAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivDisappearAction.CREATOR, env.logger, env) }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val FONT_FAMILY_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, env.logger, env, TYPE_HELPER_STRING) }
        val FONT_SIZE_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, env.logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE }
        val FONT_SIZE_UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE }
        val FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val HIGHLIGHT_COLOR_READER: Reader<Expression<Int>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }
        val HINT_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, HINT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: HINT_COLOR_DEFAULT_VALUE }
        val HINT_TEXT_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, env.logger, env, TYPE_HELPER_STRING) }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val KEYBOARD_TYPE_READER: Reader<Expression<DivInput.KeyboardType>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivInput.KeyboardType.Converter.FROM_STRING, env.logger, env, KEYBOARD_TYPE_DEFAULT_VALUE, TYPE_HELPER_KEYBOARD_TYPE) ?: KEYBOARD_TYPE_DEFAULT_VALUE }
        val LETTER_SPACING_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, env.logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE }
        val LINE_HEIGHT_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
        val MASK_READER: Reader<DivInputMask?> = { key, json, env -> JsonParser.readOptional(json, key, DivInputMask.CREATOR, env.logger, env) }
        val MAX_VISIBLE_LINES_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val NATIVE_INTERFACE_READER: Reader<DivInput.NativeInterface?> = { key, json, env -> JsonParser.readOptional(json, key, DivInput.NativeInterface.CREATOR, env.logger, env) }
        val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }
        val ROW_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SELECT_ALL_ON_FOCUS_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val TEXT_ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE }
        val TEXT_ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE }
        val TEXT_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE }
        val TEXT_VARIABLE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) ?: TRANSFORM_DEFAULT_VALUE }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val VALIDATORS_READER: Reader<List<DivInputValidator>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivInputValidator.CREATOR, env.logger, env) }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivInputTemplate(env, json = it) }
    }


    @Mockable
    class NativeInterfaceTemplate : JSONSerializable, JsonTemplate<DivInput.NativeInterface> {
        @JvmField final val color: Field<Expression<Int>>

        constructor (
            env: ParsingEnvironment,
            parent: NativeInterfaceTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            color = JsonTemplateParser.readFieldWithExpression(json, "color", topLevel, parent?.color, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivInput.NativeInterface {
            return DivInput.NativeInterface(
                color = color.resolve(env = env, key = "color", data = rawData, reader = COLOR_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeFieldWithExpression(key = "color", field = color, converter = COLOR_INT_TO_STRING)
            return json
        }

        companion object {
            val COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TYPE_HELPER_COLOR) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> NativeInterfaceTemplate(env, json = it) }
        }

    }
}
