// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivPagerLayoutMode : JSONSerializable {
    class PageSize(val value: DivPageSize) : DivPagerLayoutMode()
    class NeighbourPageSize(val value: DivNeighbourPageSize) : DivPagerLayoutMode()

    fun value(): Any {
        return when (this) {
            is PageSize -> value
            is NeighbourPageSize -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is PageSize -> value.writeToJSON()
            is NeighbourPageSize -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivPagerLayoutMode {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivPageSize.TYPE -> return PageSize(DivPageSize(env, json))
                DivNeighbourPageSize.TYPE -> return NeighbourPageSize(DivNeighbourPageSize(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivPagerLayoutModeTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivPagerLayoutMode(env, json = it) }
    }
}
