// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivPatchTemplate : JSONSerializable, JsonTemplate<DivPatch> {
    @JvmField final val changes: Field<List<ChangeTemplate>> // at least 1 elements
    @JvmField final val mode: Field<Expression<DivPatch.Mode>> // default value: partial

    constructor (
        env: ParsingEnvironment,
        parent: DivPatchTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        changes = JsonTemplateParser.readListField(json, "changes", topLevel, parent?.changes, ChangeTemplate.CREATOR, CHANGES_TEMPLATE_VALIDATOR, logger, env)
        mode = JsonTemplateParser.readOptionalFieldWithExpression(json, "mode", topLevel, parent?.mode, DivPatch.Mode.Converter.FROM_STRING, logger, env, TYPE_HELPER_MODE)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivPatch {
        return DivPatch(
            changes = changes.resolveTemplateList(env = env, key = "changes", data = rawData, CHANGES_VALIDATOR, reader = CHANGES_READER),
            mode = mode.resolveOptional(env = env, key = "mode", data = rawData, reader = MODE_READER) ?: MODE_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "changes", field = changes)
        json.writeFieldWithExpression(key = "mode", field = mode, converter = { v: DivPatch.Mode -> DivPatch.Mode.toString(v) })
        return json
    }

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(DivPatch.Mode.PARTIAL)

        private val TYPE_HELPER_MODE = TypeHelper.from(default = DivPatch.Mode.values().first()) { it is DivPatch.Mode }

        private val CHANGES_VALIDATOR = ListValidator<DivPatch.Change> { it: List<*> -> it.size >= 1 }
        private val CHANGES_TEMPLATE_VALIDATOR = ListValidator<DivPatchTemplate.ChangeTemplate> { it: List<*> -> it.size >= 1 }

        val CHANGES_READER: Reader<List<DivPatch.Change>> = { key, json, env -> JsonParser.readList(json, key, DivPatch.Change.CREATOR, CHANGES_VALIDATOR, env.logger, env) }
        val MODE_READER: Reader<Expression<DivPatch.Mode>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivPatch.Mode.Converter.FROM_STRING, env.logger, env, MODE_DEFAULT_VALUE, TYPE_HELPER_MODE) ?: MODE_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivPatchTemplate(env, json = it) }
    }


    @Mockable
    class ChangeTemplate : JSONSerializable, JsonTemplate<DivPatch.Change> {
        @JvmField final val id: Field<String>
        @JvmField final val items: Field<List<DivTemplate>>

        constructor (
            env: ParsingEnvironment,
            parent: ChangeTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            id = JsonTemplateParser.readField(json, "id", topLevel, parent?.id, logger, env)
            items = JsonTemplateParser.readOptionalListField(json, "items", topLevel, parent?.items, DivTemplate.CREATOR, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivPatch.Change {
            return DivPatch.Change(
                id = id.resolve(env = env, key = "id", data = rawData, reader = ID_READER),
                items = items.resolveOptionalTemplateList(env = env, key = "items", data = rawData, reader = ITEMS_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "id", field = id)
            json.writeField(key = "items", field = items)
            return json
        }

        companion object {
            val ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
            val ITEMS_READER: Reader<List<Div>?> = { key, json, env -> JsonParser.readOptionalList(json, key, Div.CREATOR, env.logger, env) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> ChangeTemplate(env, json = it) }
        }

    }
}
