// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivScaleTransitionTemplate : JSONSerializable, JsonTemplate<DivScaleTransition> {
    @JvmField final val duration: Field<Expression<Long>> // constraint: number >= 0; default value: 200
    @JvmField final val interpolator: Field<Expression<DivAnimationInterpolator>> // default value: ease_in_out
    @JvmField final val pivotX: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 0.5
    @JvmField final val pivotY: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 0.5
    @JvmField final val scale: Field<Expression<Double>> // constraint: number >= 0.0; default value: 0.0
    @JvmField final val startDelay: Field<Expression<Long>> // constraint: number >= 0; default value: 0

    constructor (
        env: ParsingEnvironment,
        parent: DivScaleTransitionTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        duration = JsonTemplateParser.readOptionalFieldWithExpression(json, "duration", topLevel, parent?.duration, NUMBER_TO_INT, DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        interpolator = JsonTemplateParser.readOptionalFieldWithExpression(json, "interpolator", topLevel, parent?.interpolator, DivAnimationInterpolator.Converter.FROM_STRING, logger, env, TYPE_HELPER_INTERPOLATOR)
        pivotX = JsonTemplateParser.readOptionalFieldWithExpression(json, "pivot_x", topLevel, parent?.pivotX, NUMBER_TO_DOUBLE, PIVOT_X_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        pivotY = JsonTemplateParser.readOptionalFieldWithExpression(json, "pivot_y", topLevel, parent?.pivotY, NUMBER_TO_DOUBLE, PIVOT_Y_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        scale = JsonTemplateParser.readOptionalFieldWithExpression(json, "scale", topLevel, parent?.scale, NUMBER_TO_DOUBLE, SCALE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        startDelay = JsonTemplateParser.readOptionalFieldWithExpression(json, "start_delay", topLevel, parent?.startDelay, NUMBER_TO_INT, START_DELAY_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivScaleTransition {
        return DivScaleTransition(
            duration = duration.resolveOptional(env = env, key = "duration", data = rawData, reader = DURATION_READER) ?: DURATION_DEFAULT_VALUE,
            interpolator = interpolator.resolveOptional(env = env, key = "interpolator", data = rawData, reader = INTERPOLATOR_READER) ?: INTERPOLATOR_DEFAULT_VALUE,
            pivotX = pivotX.resolveOptional(env = env, key = "pivot_x", data = rawData, reader = PIVOT_X_READER) ?: PIVOT_X_DEFAULT_VALUE,
            pivotY = pivotY.resolveOptional(env = env, key = "pivot_y", data = rawData, reader = PIVOT_Y_READER) ?: PIVOT_Y_DEFAULT_VALUE,
            scale = scale.resolveOptional(env = env, key = "scale", data = rawData, reader = SCALE_READER) ?: SCALE_DEFAULT_VALUE,
            startDelay = startDelay.resolveOptional(env = env, key = "start_delay", data = rawData, reader = START_DELAY_READER) ?: START_DELAY_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "duration", field = duration)
        json.writeFieldWithExpression(key = "interpolator", field = interpolator, converter = { v: DivAnimationInterpolator -> DivAnimationInterpolator.toString(v) })
        json.writeFieldWithExpression(key = "pivot_x", field = pivotX)
        json.writeFieldWithExpression(key = "pivot_y", field = pivotY)
        json.writeFieldWithExpression(key = "scale", field = scale)
        json.writeFieldWithExpression(key = "start_delay", field = startDelay)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "scale"

        private val DURATION_DEFAULT_VALUE = Expression.constant(200L)
        private val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.EASE_IN_OUT)
        private val PIVOT_X_DEFAULT_VALUE = Expression.constant(0.5)
        private val PIVOT_Y_DEFAULT_VALUE = Expression.constant(0.5)
        private val SCALE_DEFAULT_VALUE = Expression.constant(0.0)
        private val START_DELAY_DEFAULT_VALUE = Expression.constant(0L)

        private val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }

        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val PIVOT_X_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val PIVOT_X_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val PIVOT_Y_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val PIVOT_Y_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val SCALE_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 }
        private val SCALE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 }
        private val START_DELAY_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val START_DELAY_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

        val DURATION_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, DURATION_VALIDATOR, env.logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE }
        val INTERPOLATOR_READER: Reader<Expression<DivAnimationInterpolator>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAnimationInterpolator.Converter.FROM_STRING, env.logger, env, INTERPOLATOR_DEFAULT_VALUE, TYPE_HELPER_INTERPOLATOR) ?: INTERPOLATOR_DEFAULT_VALUE }
        val PIVOT_X_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, PIVOT_X_VALIDATOR, env.logger, env, PIVOT_X_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: PIVOT_X_DEFAULT_VALUE }
        val PIVOT_Y_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, PIVOT_Y_VALIDATOR, env.logger, env, PIVOT_Y_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: PIVOT_Y_DEFAULT_VALUE }
        val SCALE_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, SCALE_VALIDATOR, env.logger, env, SCALE_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: SCALE_DEFAULT_VALUE }
        val START_DELAY_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, START_DELAY_VALIDATOR, env.logger, env, START_DELAY_DEFAULT_VALUE, TYPE_HELPER_INT) ?: START_DELAY_DEFAULT_VALUE }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivScaleTransitionTemplate(env, json = it) }
    }

}
