// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivSliderTemplate : JSONSerializable, JsonTemplate<DivSlider> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val background: Field<List<DivBackgroundTemplate>>
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val disappearActions: Field<List<DivDisappearActionTemplate>>
    @JvmField final val extensions: Field<List<DivExtensionTemplate>>
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val id: Field<String>
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val maxValue: Field<Expression<Long>> // default value: 100
    @JvmField final val minValue: Field<Expression<Long>> // default value: 0
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val ranges: Field<List<RangeTemplate>>
    @JvmField final val rowSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val secondaryValueAccessibility: Field<DivAccessibilityTemplate>
    @JvmField final val selectedActions: Field<List<DivActionTemplate>>
    @JvmField final val thumbSecondaryStyle: Field<DivDrawableTemplate>
    @JvmField final val thumbSecondaryTextStyle: Field<TextStyleTemplate>
    @JvmField final val thumbSecondaryValueVariable: Field<String>
    @JvmField final val thumbStyle: Field<DivDrawableTemplate>
    @JvmField final val thumbTextStyle: Field<TextStyleTemplate>
    @JvmField final val thumbValueVariable: Field<String>
    @JvmField final val tickMarkActiveStyle: Field<DivDrawableTemplate>
    @JvmField final val tickMarkInactiveStyle: Field<DivDrawableTemplate>
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>>
    @JvmField final val trackActiveStyle: Field<DivDrawableTemplate>
    @JvmField final val trackInactiveStyle: Field<DivDrawableTemplate>
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>>
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivSliderTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        disappearActions = JsonTemplateParser.readOptionalListField(json, "disappear_actions", topLevel, parent?.disappearActions, DivDisappearActionTemplate.CREATOR, logger, env)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, logger, env)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        maxValue = JsonTemplateParser.readOptionalFieldWithExpression(json, "max_value", topLevel, parent?.maxValue, NUMBER_TO_INT, logger, env, TYPE_HELPER_INT)
        minValue = JsonTemplateParser.readOptionalFieldWithExpression(json, "min_value", topLevel, parent?.minValue, NUMBER_TO_INT, logger, env, TYPE_HELPER_INT)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        ranges = JsonTemplateParser.readOptionalListField(json, "ranges", topLevel, parent?.ranges, RangeTemplate.CREATOR, logger, env)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        secondaryValueAccessibility = JsonTemplateParser.readOptionalField(json, "secondary_value_accessibility", topLevel, parent?.secondaryValueAccessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, logger, env)
        thumbSecondaryStyle = JsonTemplateParser.readOptionalField(json, "thumb_secondary_style", topLevel, parent?.thumbSecondaryStyle, DivDrawableTemplate.CREATOR, logger, env)
        thumbSecondaryTextStyle = JsonTemplateParser.readOptionalField(json, "thumb_secondary_text_style", topLevel, parent?.thumbSecondaryTextStyle, TextStyleTemplate.CREATOR, logger, env)
        thumbSecondaryValueVariable = JsonTemplateParser.readOptionalField(json, "thumb_secondary_value_variable", topLevel, parent?.thumbSecondaryValueVariable, logger, env)
        thumbStyle = JsonTemplateParser.readField(json, "thumb_style", topLevel, parent?.thumbStyle, DivDrawableTemplate.CREATOR, logger, env)
        thumbTextStyle = JsonTemplateParser.readOptionalField(json, "thumb_text_style", topLevel, parent?.thumbTextStyle, TextStyleTemplate.CREATOR, logger, env)
        thumbValueVariable = JsonTemplateParser.readOptionalField(json, "thumb_value_variable", topLevel, parent?.thumbValueVariable, logger, env)
        tickMarkActiveStyle = JsonTemplateParser.readOptionalField(json, "tick_mark_active_style", topLevel, parent?.tickMarkActiveStyle, DivDrawableTemplate.CREATOR, logger, env)
        tickMarkInactiveStyle = JsonTemplateParser.readOptionalField(json, "tick_mark_inactive_style", topLevel, parent?.tickMarkInactiveStyle, DivDrawableTemplate.CREATOR, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, logger, env)
        trackActiveStyle = JsonTemplateParser.readField(json, "track_active_style", topLevel, parent?.trackActiveStyle, DivDrawableTemplate.CREATOR, logger, env)
        trackInactiveStyle = JsonTemplateParser.readField(json, "track_inactive_style", topLevel, parent?.trackInactiveStyle, DivDrawableTemplate.CREATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivSlider {
        return DivSlider(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = rawData, reader = ACCESSIBILITY_READER) ?: ACCESSIBILITY_DEFAULT_VALUE,
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = rawData, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = rawData, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = rawData, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = rawData, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = rawData, reader = BORDER_READER) ?: BORDER_DEFAULT_VALUE,
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = rawData, reader = COLUMN_SPAN_READER),
            disappearActions = disappearActions.resolveOptionalTemplateList(env = env, key = "disappear_actions", data = rawData, reader = DISAPPEAR_ACTIONS_READER),
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = rawData, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = rawData, reader = FOCUS_READER),
            height = height.resolveOptionalTemplate(env = env, key = "height", data = rawData, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            id = id.resolveOptional(env = env, key = "id", data = rawData, reader = ID_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = rawData, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
            maxValue = maxValue.resolveOptional(env = env, key = "max_value", data = rawData, reader = MAX_VALUE_READER) ?: MAX_VALUE_DEFAULT_VALUE,
            minValue = minValue.resolveOptional(env = env, key = "min_value", data = rawData, reader = MIN_VALUE_READER) ?: MIN_VALUE_DEFAULT_VALUE,
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = rawData, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE,
            ranges = ranges.resolveOptionalTemplateList(env = env, key = "ranges", data = rawData, reader = RANGES_READER),
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = rawData, reader = ROW_SPAN_READER),
            secondaryValueAccessibility = secondaryValueAccessibility.resolveOptionalTemplate(env = env, key = "secondary_value_accessibility", data = rawData, reader = SECONDARY_VALUE_ACCESSIBILITY_READER) ?: SECONDARY_VALUE_ACCESSIBILITY_DEFAULT_VALUE,
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = rawData, reader = SELECTED_ACTIONS_READER),
            thumbSecondaryStyle = thumbSecondaryStyle.resolveOptionalTemplate(env = env, key = "thumb_secondary_style", data = rawData, reader = THUMB_SECONDARY_STYLE_READER),
            thumbSecondaryTextStyle = thumbSecondaryTextStyle.resolveOptionalTemplate(env = env, key = "thumb_secondary_text_style", data = rawData, reader = THUMB_SECONDARY_TEXT_STYLE_READER),
            thumbSecondaryValueVariable = thumbSecondaryValueVariable.resolveOptional(env = env, key = "thumb_secondary_value_variable", data = rawData, reader = THUMB_SECONDARY_VALUE_VARIABLE_READER),
            thumbStyle = thumbStyle.resolveTemplate(env = env, key = "thumb_style", data = rawData, reader = THUMB_STYLE_READER),
            thumbTextStyle = thumbTextStyle.resolveOptionalTemplate(env = env, key = "thumb_text_style", data = rawData, reader = THUMB_TEXT_STYLE_READER),
            thumbValueVariable = thumbValueVariable.resolveOptional(env = env, key = "thumb_value_variable", data = rawData, reader = THUMB_VALUE_VARIABLE_READER),
            tickMarkActiveStyle = tickMarkActiveStyle.resolveOptionalTemplate(env = env, key = "tick_mark_active_style", data = rawData, reader = TICK_MARK_ACTIVE_STYLE_READER),
            tickMarkInactiveStyle = tickMarkInactiveStyle.resolveOptionalTemplate(env = env, key = "tick_mark_inactive_style", data = rawData, reader = TICK_MARK_INACTIVE_STYLE_READER),
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = rawData, reader = TOOLTIPS_READER),
            trackActiveStyle = trackActiveStyle.resolveTemplate(env = env, key = "track_active_style", data = rawData, reader = TRACK_ACTIVE_STYLE_READER),
            trackInactiveStyle = trackInactiveStyle.resolveTemplate(env = env, key = "track_inactive_style", data = rawData, reader = TRACK_INACTIVE_STYLE_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = rawData, reader = TRANSFORM_READER) ?: TRANSFORM_DEFAULT_VALUE,
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = rawData, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = rawData, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = rawData, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = rawData, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = rawData, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = rawData, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = rawData, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = rawData, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeField(key = "disappear_actions", field = disappearActions)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeField(key = "height", field = height)
        json.writeField(key = "id", field = id)
        json.writeField(key = "margins", field = margins)
        json.writeFieldWithExpression(key = "max_value", field = maxValue)
        json.writeFieldWithExpression(key = "min_value", field = minValue)
        json.writeField(key = "paddings", field = paddings)
        json.writeField(key = "ranges", field = ranges)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeField(key = "secondary_value_accessibility", field = secondaryValueAccessibility)
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeField(key = "thumb_secondary_style", field = thumbSecondaryStyle)
        json.writeField(key = "thumb_secondary_text_style", field = thumbSecondaryTextStyle)
        json.writeField(key = "thumb_secondary_value_variable", field = thumbSecondaryValueVariable)
        json.writeField(key = "thumb_style", field = thumbStyle)
        json.writeField(key = "thumb_text_style", field = thumbTextStyle)
        json.writeField(key = "thumb_value_variable", field = thumbValueVariable)
        json.writeField(key = "tick_mark_active_style", field = tickMarkActiveStyle)
        json.writeField(key = "tick_mark_inactive_style", field = tickMarkInactiveStyle)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "track_active_style", field = trackActiveStyle)
        json.writeField(key = "track_inactive_style", field = trackInactiveStyle)
        json.writeField(key = "transform", field = transform)
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "slider"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val MAX_VALUE_DEFAULT_VALUE = Expression.constant(100L)
        private val MIN_VALUE_DEFAULT_VALUE = Expression.constant(0L)
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val SECONDARY_VALUE_ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) ?: BORDER_DEFAULT_VALUE }
        val COLUMN_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val DISAPPEAR_ACTIONS_READER: Reader<List<DivDisappearAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivDisappearAction.CREATOR, env.logger, env) }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
        val MAX_VALUE_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, env.logger, env, MAX_VALUE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: MAX_VALUE_DEFAULT_VALUE }
        val MIN_VALUE_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, env.logger, env, MIN_VALUE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: MIN_VALUE_DEFAULT_VALUE }
        val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }
        val RANGES_READER: Reader<List<DivSlider.Range>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivSlider.Range.CREATOR, env.logger, env) }
        val ROW_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SECONDARY_VALUE_ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: SECONDARY_VALUE_ACCESSIBILITY_DEFAULT_VALUE }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val THUMB_SECONDARY_STYLE_READER: Reader<DivDrawable?> = { key, json, env -> JsonParser.readOptional(json, key, DivDrawable.CREATOR, env.logger, env) }
        val THUMB_SECONDARY_TEXT_STYLE_READER: Reader<DivSlider.TextStyle?> = { key, json, env -> JsonParser.readOptional(json, key, DivSlider.TextStyle.CREATOR, env.logger, env) }
        val THUMB_SECONDARY_VALUE_VARIABLE_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val THUMB_STYLE_READER: Reader<DivDrawable> = { key, json, env -> JsonParser.read(json, key, DivDrawable.CREATOR, env.logger, env) }
        val THUMB_TEXT_STYLE_READER: Reader<DivSlider.TextStyle?> = { key, json, env -> JsonParser.readOptional(json, key, DivSlider.TextStyle.CREATOR, env.logger, env) }
        val THUMB_VALUE_VARIABLE_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val TICK_MARK_ACTIVE_STYLE_READER: Reader<DivDrawable?> = { key, json, env -> JsonParser.readOptional(json, key, DivDrawable.CREATOR, env.logger, env) }
        val TICK_MARK_INACTIVE_STYLE_READER: Reader<DivDrawable?> = { key, json, env -> JsonParser.readOptional(json, key, DivDrawable.CREATOR, env.logger, env) }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, env.logger, env) }
        val TRACK_ACTIVE_STYLE_READER: Reader<DivDrawable> = { key, json, env -> JsonParser.read(json, key, DivDrawable.CREATOR, env.logger, env) }
        val TRACK_INACTIVE_STYLE_READER: Reader<DivDrawable> = { key, json, env -> JsonParser.read(json, key, DivDrawable.CREATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) ?: TRANSFORM_DEFAULT_VALUE }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSliderTemplate(env, json = it) }
    }


    @Mockable
    class TextStyleTemplate : JSONSerializable, JsonTemplate<DivSlider.TextStyle> {
        @JvmField final val fontSize: Field<Expression<Long>> // constraint: number >= 0
        @JvmField final val fontSizeUnit: Field<Expression<DivSizeUnit>> // default value: sp
        @JvmField final val fontWeight: Field<Expression<DivFontWeight>> // default value: regular
        @JvmField final val offset: Field<DivPointTemplate>
        @JvmField final val textColor: Field<Expression<Int>> // default value: #FF000000

        constructor (
            env: ParsingEnvironment,
            parent: TextStyleTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            fontSize = JsonTemplateParser.readFieldWithExpression(json, "font_size", topLevel, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            fontSizeUnit = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_size_unit", topLevel, parent?.fontSizeUnit, DivSizeUnit.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_SIZE_UNIT)
            fontWeight = JsonTemplateParser.readOptionalFieldWithExpression(json, "font_weight", topLevel, parent?.fontWeight, DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_FONT_WEIGHT)
            offset = JsonTemplateParser.readOptionalField(json, "offset", topLevel, parent?.offset, DivPointTemplate.CREATOR, logger, env)
            textColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "text_color", topLevel, parent?.textColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivSlider.TextStyle {
            return DivSlider.TextStyle(
                fontSize = fontSize.resolve(env = env, key = "font_size", data = rawData, reader = FONT_SIZE_READER),
                fontSizeUnit = fontSizeUnit.resolveOptional(env = env, key = "font_size_unit", data = rawData, reader = FONT_SIZE_UNIT_READER) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = fontWeight.resolveOptional(env = env, key = "font_weight", data = rawData, reader = FONT_WEIGHT_READER) ?: FONT_WEIGHT_DEFAULT_VALUE,
                offset = offset.resolveOptionalTemplate(env = env, key = "offset", data = rawData, reader = OFFSET_READER),
                textColor = textColor.resolveOptional(env = env, key = "text_color", data = rawData, reader = TEXT_COLOR_READER) ?: TEXT_COLOR_DEFAULT_VALUE
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeFieldWithExpression(key = "font_size", field = fontSize)
            json.writeFieldWithExpression(key = "font_size_unit", field = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeFieldWithExpression(key = "font_weight", field = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeField(key = "offset", field = offset)
            json.writeFieldWithExpression(key = "text_color", field = textColor, converter = COLOR_INT_TO_STRING)
            return json
        }

        companion object {
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
            private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
            private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())

            private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
            private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }

            private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
            private val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

            val FONT_SIZE_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val FONT_SIZE_UNIT_READER: Reader<Expression<DivSizeUnit>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivSizeUnit.Converter.FROM_STRING, env.logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE }
            val FONT_WEIGHT_READER: Reader<Expression<DivFontWeight>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivFontWeight.Converter.FROM_STRING, env.logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE }
            val OFFSET_READER: Reader<DivPoint?> = { key, json, env -> JsonParser.readOptional(json, key, DivPoint.CREATOR, env.logger, env) }
            val TEXT_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> TextStyleTemplate(env, json = it) }
        }

    }

    @Mockable
    class RangeTemplate : JSONSerializable, JsonTemplate<DivSlider.Range> {
        @JvmField final val end: Field<Expression<Long>>
        @JvmField final val margins: Field<DivEdgeInsetsTemplate>
        @JvmField final val start: Field<Expression<Long>>
        @JvmField final val trackActiveStyle: Field<DivDrawableTemplate>
        @JvmField final val trackInactiveStyle: Field<DivDrawableTemplate>

        constructor (
            env: ParsingEnvironment,
            parent: RangeTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            end = JsonTemplateParser.readOptionalFieldWithExpression(json, "end", topLevel, parent?.end, NUMBER_TO_INT, logger, env, TYPE_HELPER_INT)
            margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
            start = JsonTemplateParser.readOptionalFieldWithExpression(json, "start", topLevel, parent?.start, NUMBER_TO_INT, logger, env, TYPE_HELPER_INT)
            trackActiveStyle = JsonTemplateParser.readOptionalField(json, "track_active_style", topLevel, parent?.trackActiveStyle, DivDrawableTemplate.CREATOR, logger, env)
            trackInactiveStyle = JsonTemplateParser.readOptionalField(json, "track_inactive_style", topLevel, parent?.trackInactiveStyle, DivDrawableTemplate.CREATOR, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivSlider.Range {
            return DivSlider.Range(
                end = end.resolveOptional(env = env, key = "end", data = rawData, reader = END_READER),
                margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = rawData, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
                start = start.resolveOptional(env = env, key = "start", data = rawData, reader = START_READER),
                trackActiveStyle = trackActiveStyle.resolveOptionalTemplate(env = env, key = "track_active_style", data = rawData, reader = TRACK_ACTIVE_STYLE_READER),
                trackInactiveStyle = trackInactiveStyle.resolveOptionalTemplate(env = env, key = "track_inactive_style", data = rawData, reader = TRACK_INACTIVE_STYLE_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeFieldWithExpression(key = "end", field = end)
            json.writeField(key = "margins", field = margins)
            json.writeFieldWithExpression(key = "start", field = start)
            json.writeField(key = "track_active_style", field = trackActiveStyle)
            json.writeField(key = "track_inactive_style", field = trackInactiveStyle)
            return json
        }

        companion object {
            private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()

            val END_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, env.logger, env, TYPE_HELPER_INT) }
            val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
            val START_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, env.logger, env, TYPE_HELPER_INT) }
            val TRACK_ACTIVE_STYLE_READER: Reader<DivDrawable?> = { key, json, env -> JsonParser.readOptional(json, key, DivDrawable.CREATOR, env.logger, env) }
            val TRACK_INACTIVE_STYLE_READER: Reader<DivDrawable?> = { key, json, env -> JsonParser.readOptional(json, key, DivDrawable.CREATOR, env.logger, env) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> RangeTemplate(env, json = it) }
        }

    }
}
