// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivStateTemplate : JSONSerializable, JsonTemplate<DivState> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val background: Field<List<DivBackgroundTemplate>>
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val defaultStateId: Field<Expression<String>>
    @JvmField final val disappearActions: Field<List<DivDisappearActionTemplate>>
    @JvmField final val divId: Field<String>
    @JvmField final val extensions: Field<List<DivExtensionTemplate>>
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val id: Field<String>
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val rowSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val selectedActions: Field<List<DivActionTemplate>>
    @JvmField final val stateIdVariable: Field<String>
    @JvmField final val states: Field<List<StateTemplate>> // at least 1 elements
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>>
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionAnimationSelector: Field<Expression<DivTransitionSelector>> // default value: state_change
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>>
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivStateTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        defaultStateId = JsonTemplateParser.readOptionalFieldWithExpression(json, "default_state_id", topLevel, parent?.defaultStateId, logger, env, TYPE_HELPER_STRING)
        disappearActions = JsonTemplateParser.readOptionalListField(json, "disappear_actions", topLevel, parent?.disappearActions, DivDisappearActionTemplate.CREATOR, logger, env)
        divId = JsonTemplateParser.readOptionalField(json, "div_id", topLevel, parent?.divId, logger, env)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, logger, env)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, logger, env)
        stateIdVariable = JsonTemplateParser.readOptionalField(json, "state_id_variable", topLevel, parent?.stateIdVariable, logger, env)
        states = JsonTemplateParser.readListField(json, "states", topLevel, parent?.states, StateTemplate.CREATOR, STATES_TEMPLATE_VALIDATOR, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionAnimationSelector = JsonTemplateParser.readOptionalFieldWithExpression(json, "transition_animation_selector", topLevel, parent?.transitionAnimationSelector, DivTransitionSelector.Converter.FROM_STRING, logger, env, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivState {
        return DivState(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = rawData, reader = ACCESSIBILITY_READER) ?: ACCESSIBILITY_DEFAULT_VALUE,
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = rawData, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = rawData, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = rawData, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = rawData, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = rawData, reader = BORDER_READER) ?: BORDER_DEFAULT_VALUE,
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = rawData, reader = COLUMN_SPAN_READER),
            defaultStateId = defaultStateId.resolveOptional(env = env, key = "default_state_id", data = rawData, reader = DEFAULT_STATE_ID_READER),
            disappearActions = disappearActions.resolveOptionalTemplateList(env = env, key = "disappear_actions", data = rawData, reader = DISAPPEAR_ACTIONS_READER),
            divId = divId.resolveOptional(env = env, key = "div_id", data = rawData, reader = DIV_ID_READER),
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = rawData, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = rawData, reader = FOCUS_READER),
            height = height.resolveOptionalTemplate(env = env, key = "height", data = rawData, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            id = id.resolveOptional(env = env, key = "id", data = rawData, reader = ID_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = rawData, reader = MARGINS_READER) ?: MARGINS_DEFAULT_VALUE,
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = rawData, reader = PADDINGS_READER) ?: PADDINGS_DEFAULT_VALUE,
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = rawData, reader = ROW_SPAN_READER),
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = rawData, reader = SELECTED_ACTIONS_READER),
            stateIdVariable = stateIdVariable.resolveOptional(env = env, key = "state_id_variable", data = rawData, reader = STATE_ID_VARIABLE_READER),
            states = states.resolveTemplateList(env = env, key = "states", data = rawData, STATES_VALIDATOR, reader = STATES_READER),
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = rawData, reader = TOOLTIPS_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = rawData, reader = TRANSFORM_READER) ?: TRANSFORM_DEFAULT_VALUE,
            transitionAnimationSelector = transitionAnimationSelector.resolveOptional(env = env, key = "transition_animation_selector", data = rawData, reader = TRANSITION_ANIMATION_SELECTOR_READER) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = rawData, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = rawData, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = rawData, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = rawData, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = rawData, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = rawData, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = rawData, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = rawData, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeFieldWithExpression(key = "default_state_id", field = defaultStateId)
        json.writeField(key = "disappear_actions", field = disappearActions)
        json.writeField(key = "div_id", field = divId)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeField(key = "height", field = height)
        json.writeField(key = "id", field = id)
        json.writeField(key = "margins", field = margins)
        json.writeField(key = "paddings", field = paddings)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeField(key = "state_id_variable", field = stateIdVariable)
        json.writeField(key = "states", field = states)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "transform", field = transform)
        json.writeFieldWithExpression(key = "transition_animation_selector", field = transitionAnimationSelector, converter = { v: DivTransitionSelector -> DivTransitionSelector.toString(v) })
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "state"

        private val ACCESSIBILITY_DEFAULT_VALUE = DivAccessibility()
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val BORDER_DEFAULT_VALUE = DivBorder()
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val MARGINS_DEFAULT_VALUE = DivEdgeInsets()
        private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets()
        private val TRANSFORM_DEFAULT_VALUE = DivTransform()
        private val TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE = Expression.constant(DivTransitionSelector.STATE_CHANGE)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR = TypeHelper.from(default = DivTransitionSelector.values().first()) { it is DivTransitionSelector }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val STATES_VALIDATOR = ListValidator<DivState.State> { it: List<*> -> it.size >= 1 }
        private val STATES_TEMPLATE_VALIDATOR = ListValidator<DivStateTemplate.StateTemplate> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) ?: ACCESSIBILITY_DEFAULT_VALUE }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) ?: BORDER_DEFAULT_VALUE }
        val COLUMN_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val DEFAULT_STATE_ID_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, env.logger, env, TYPE_HELPER_STRING) }
        val DISAPPEAR_ACTIONS_READER: Reader<List<DivDisappearAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivDisappearAction.CREATOR, env.logger, env) }
        val DIV_ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val MARGINS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: MARGINS_DEFAULT_VALUE }
        val PADDINGS_READER: Reader<DivEdgeInsets> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) ?: PADDINGS_DEFAULT_VALUE }
        val ROW_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val STATE_ID_VARIABLE_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val STATES_READER: Reader<List<DivState.State>> = { key, json, env -> JsonParser.readList(json, key, DivState.State.CREATOR, STATES_VALIDATOR, env.logger, env) }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) ?: TRANSFORM_DEFAULT_VALUE }
        val TRANSITION_ANIMATION_SELECTOR_READER: Reader<Expression<DivTransitionSelector>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivTransitionSelector.Converter.FROM_STRING, env.logger, env, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivStateTemplate(env, json = it) }
    }


    @Mockable
    class StateTemplate : JSONSerializable, JsonTemplate<DivState.State> {
        @JvmField final val animationIn: Field<DivAnimationTemplate>
        @JvmField final val animationOut: Field<DivAnimationTemplate>
        @JvmField final val div: Field<DivTemplate>
        @JvmField final val stateId: Field<String>
        @JvmField final val swipeOutActions: Field<List<DivActionTemplate>>

        constructor (
            env: ParsingEnvironment,
            parent: StateTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            animationIn = JsonTemplateParser.readOptionalField(json, "animation_in", topLevel, parent?.animationIn, DivAnimationTemplate.CREATOR, logger, env)
            animationOut = JsonTemplateParser.readOptionalField(json, "animation_out", topLevel, parent?.animationOut, DivAnimationTemplate.CREATOR, logger, env)
            div = JsonTemplateParser.readOptionalField(json, "div", topLevel, parent?.div, DivTemplate.CREATOR, logger, env)
            stateId = JsonTemplateParser.readField(json, "state_id", topLevel, parent?.stateId, logger, env)
            swipeOutActions = JsonTemplateParser.readOptionalListField(json, "swipe_out_actions", topLevel, parent?.swipeOutActions, DivActionTemplate.CREATOR, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivState.State {
            return DivState.State(
                animationIn = animationIn.resolveOptionalTemplate(env = env, key = "animation_in", data = rawData, reader = ANIMATION_IN_READER),
                animationOut = animationOut.resolveOptionalTemplate(env = env, key = "animation_out", data = rawData, reader = ANIMATION_OUT_READER),
                div = div.resolveOptionalTemplate(env = env, key = "div", data = rawData, reader = DIV_READER),
                stateId = stateId.resolve(env = env, key = "state_id", data = rawData, reader = STATE_ID_READER),
                swipeOutActions = swipeOutActions.resolveOptionalTemplateList(env = env, key = "swipe_out_actions", data = rawData, reader = SWIPE_OUT_ACTIONS_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "animation_in", field = animationIn)
            json.writeField(key = "animation_out", field = animationOut)
            json.writeField(key = "div", field = div)
            json.writeField(key = "state_id", field = stateId)
            json.writeField(key = "swipe_out_actions", field = swipeOutActions)
            return json
        }

        companion object {
            val ANIMATION_IN_READER: Reader<DivAnimation?> = { key, json, env -> JsonParser.readOptional(json, key, DivAnimation.CREATOR, env.logger, env) }
            val ANIMATION_OUT_READER: Reader<DivAnimation?> = { key, json, env -> JsonParser.readOptional(json, key, DivAnimation.CREATOR, env.logger, env) }
            val DIV_READER: Reader<Div?> = { key, json, env -> JsonParser.readOptional(json, key, Div.CREATOR, env.logger, env) }
            val STATE_ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
            val SWIPE_OUT_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> StateTemplate(env, json = it) }
        }

    }
}
