// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivStretchIndicatorItemPlacement @DivModelInternalApi constructor (
    @JvmField final val itemSpacing: DivFixedSize = ITEM_SPACING_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(5L))
    @JvmField final val maxVisibleItems: Expression<Long> = MAX_VISIBLE_ITEMS_DEFAULT_VALUE, // constraint: number > 0; default value: 10
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "item_spacing", value = itemSpacing)
        json.writeExpression(key = "max_visible_items", value = maxVisibleItems)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "stretch"

        private val ITEM_SPACING_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(5L))
        private val MAX_VISIBLE_ITEMS_DEFAULT_VALUE = Expression.constant(10L)

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivStretchIndicatorItemPlacement {
            val logger = env.logger
            return DivStretchIndicatorItemPlacement(
                itemSpacing = JsonParser.readOptional(json, "item_spacing", DivFixedSize.CREATOR, logger, env) ?: ITEM_SPACING_DEFAULT_VALUE,
                maxVisibleItems = JsonParser.readOptionalExpression(json, "max_visible_items", NUMBER_TO_INT, MAX_VISIBLE_ITEMS_VALIDATOR, logger, env, MAX_VISIBLE_ITEMS_DEFAULT_VALUE, TYPE_HELPER_INT) ?: MAX_VISIBLE_ITEMS_DEFAULT_VALUE
            )
        }

        private val MAX_VISIBLE_ITEMS_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val MAX_VISIBLE_ITEMS_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivStretchIndicatorItemPlacement(env, json = it) }
    }

}
