// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivStretchIndicatorItemPlacementTemplate : JSONSerializable, JsonTemplate<DivStretchIndicatorItemPlacement> {
    @JvmField final val itemSpacing: Field<DivFixedSizeTemplate> // default value: DivFixedSize(value = Expression.constant(5L))
    @JvmField final val maxVisibleItems: Field<Expression<Long>> // constraint: number > 0; default value: 10

    constructor (
        env: ParsingEnvironment,
        parent: DivStretchIndicatorItemPlacementTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        itemSpacing = JsonTemplateParser.readOptionalField(json, "item_spacing", topLevel, parent?.itemSpacing, DivFixedSizeTemplate.CREATOR, logger, env)
        maxVisibleItems = JsonTemplateParser.readOptionalFieldWithExpression(json, "max_visible_items", topLevel, parent?.maxVisibleItems, NUMBER_TO_INT, MAX_VISIBLE_ITEMS_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivStretchIndicatorItemPlacement {
        return DivStretchIndicatorItemPlacement(
            itemSpacing = itemSpacing.resolveOptionalTemplate(env = env, key = "item_spacing", data = rawData, reader = ITEM_SPACING_READER) ?: ITEM_SPACING_DEFAULT_VALUE,
            maxVisibleItems = maxVisibleItems.resolveOptional(env = env, key = "max_visible_items", data = rawData, reader = MAX_VISIBLE_ITEMS_READER) ?: MAX_VISIBLE_ITEMS_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "item_spacing", field = itemSpacing)
        json.writeFieldWithExpression(key = "max_visible_items", field = maxVisibleItems)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "stretch"

        private val ITEM_SPACING_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(5L))
        private val MAX_VISIBLE_ITEMS_DEFAULT_VALUE = Expression.constant(10L)

        private val MAX_VISIBLE_ITEMS_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val MAX_VISIBLE_ITEMS_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }

        val ITEM_SPACING_READER: Reader<DivFixedSize> = { key, json, env -> JsonParser.readOptional(json, key, DivFixedSize.CREATOR, env.logger, env) ?: ITEM_SPACING_DEFAULT_VALUE }
        val MAX_VISIBLE_ITEMS_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, MAX_VISIBLE_ITEMS_VALIDATOR, env.logger, env, MAX_VISIBLE_ITEMS_DEFAULT_VALUE, TYPE_HELPER_INT) ?: MAX_VISIBLE_ITEMS_DEFAULT_VALUE }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivStretchIndicatorItemPlacementTemplate(env, json = it) }
    }

}
