// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivTypedValueTemplate : JSONSerializable, JsonTemplate<DivTypedValue> {
    class Str(val value: StrValueTemplate) : DivTypedValueTemplate()
    class Integer(val value: IntegerValueTemplate) : DivTypedValueTemplate()
    class Number(val value: NumberValueTemplate) : DivTypedValueTemplate()
    class Color(val value: ColorValueTemplate) : DivTypedValueTemplate()
    class Bool(val value: BoolValueTemplate) : DivTypedValueTemplate()
    class Url(val value: UrlValueTemplate) : DivTypedValueTemplate()
    class Dict(val value: DictValueTemplate) : DivTypedValueTemplate()
    class Array(val value: ArrayValueTemplate) : DivTypedValueTemplate()

    fun value(): Any {
        return when (this) {
            is Str -> value
            is Integer -> value
            is Number -> value
            is Color -> value
            is Bool -> value
            is Url -> value
            is Dict -> value
            is Array -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Str -> value.writeToJSON()
            is Integer -> value.writeToJSON()
            is Number -> value.writeToJSON()
            is Color -> value.writeToJSON()
            is Bool -> value.writeToJSON()
            is Url -> value.writeToJSON()
            is Dict -> value.writeToJSON()
            is Array -> value.writeToJSON()
        }
    }

    override fun resolve(env: ParsingEnvironment, data: JSONObject): DivTypedValue {
        return when (this) {
            is Str -> DivTypedValue.Str(value.resolve(env, data))
            is Integer -> DivTypedValue.Integer(value.resolve(env, data))
            is Number -> DivTypedValue.Number(value.resolve(env, data))
            is Color -> DivTypedValue.Color(value.resolve(env, data))
            is Bool -> DivTypedValue.Bool(value.resolve(env, data))
            is Url -> DivTypedValue.Url(value.resolve(env, data))
            is Dict -> DivTypedValue.Dict(value.resolve(env, data))
            is Array -> DivTypedValue.Array(value.resolve(env, data))
        }
    }

    val type: String
        get() {
            return when (this) {
                is Str -> StrValueTemplate.TYPE
                is Integer -> IntegerValueTemplate.TYPE
                is Number -> NumberValueTemplate.TYPE
                is Color -> ColorValueTemplate.TYPE
                is Bool -> BoolValueTemplate.TYPE
                is Url -> UrlValueTemplate.TYPE
                is Dict -> DictValueTemplate.TYPE
                is Array -> ArrayValueTemplate.TYPE
            }
        }

    companion object {
        @Throws(ParsingException::class)
        operator fun invoke(
            env: ParsingEnvironment,
            topLevel: Boolean = false,
            json: JSONObject
        ): DivTypedValueTemplate {
            val logger = env.logger
            val receivedType: String = json.read("type", logger = logger, env = env)
            val parent = env.templates[receivedType] as? DivTypedValueTemplate
            val type = parent?.type ?: receivedType
            when (type) {
                StrValueTemplate.TYPE -> return Str(StrValueTemplate(env, parent?.value() as StrValueTemplate?, topLevel, json))
                IntegerValueTemplate.TYPE -> return Integer(IntegerValueTemplate(env, parent?.value() as IntegerValueTemplate?, topLevel, json))
                NumberValueTemplate.TYPE -> return Number(NumberValueTemplate(env, parent?.value() as NumberValueTemplate?, topLevel, json))
                ColorValueTemplate.TYPE -> return Color(ColorValueTemplate(env, parent?.value() as ColorValueTemplate?, topLevel, json))
                BoolValueTemplate.TYPE -> return Bool(BoolValueTemplate(env, parent?.value() as BoolValueTemplate?, topLevel, json))
                UrlValueTemplate.TYPE -> return Url(UrlValueTemplate(env, parent?.value() as UrlValueTemplate?, topLevel, json))
                DictValueTemplate.TYPE -> return Dict(DictValueTemplate(env, parent?.value() as DictValueTemplate?, topLevel, json))
                ArrayValueTemplate.TYPE -> return Array(ArrayValueTemplate(env, parent?.value() as ArrayValueTemplate?, topLevel, json))
                else -> throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTypedValueTemplate(env, json = it) }
    }
}
