// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivVideoSource @DivModelInternalApi constructor (
    @JvmField final val bitrate: Expression<Long>? = null,
    @JvmField final val mimeType: Expression<String>,
    @JvmField final val resolution: Resolution? = null,
    @JvmField final val url: Expression<Uri>,
) : JSONSerializable {

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "bitrate", value = bitrate)
        json.writeExpression(key = "mime_type", value = mimeType)
        json.write(key = "resolution", value = resolution)
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "url", value = url, converter = URI_TO_STRING)
        return json
    }

    companion object {
        const val TYPE = "video_source"

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivVideoSource {
            val logger = env.logger
            return DivVideoSource(
                bitrate = JsonParser.readOptionalExpression(json, "bitrate", NUMBER_TO_INT, logger, env, TYPE_HELPER_INT),
                mimeType = JsonParser.readExpression(json, "mime_type", logger, env, TYPE_HELPER_STRING),
                resolution = JsonParser.readOptional(json, "resolution", Resolution.CREATOR, logger, env),
                url = JsonParser.readExpression(json, "url", STRING_TO_URI, logger, env, TYPE_HELPER_URI)
            )
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVideoSource(env, json = it) }
    }


    @Mockable
    class Resolution @DivModelInternalApi constructor (
        @JvmField final val height: Expression<Long>, // constraint: number > 0
        @JvmField final val width: Expression<Long>, // constraint: number > 0
    ) : JSONSerializable {

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "height", value = height)
            json.write(key = "type", value = TYPE)
            json.writeExpression(key = "width", value = width)
            return json
        }

        companion object {
            const val TYPE = "resolution"

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Resolution {
                val logger = env.logger
                return Resolution(
                    height = JsonParser.readExpression(json, "height", NUMBER_TO_INT, HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    width = JsonParser.readExpression(json, "width", NUMBER_TO_INT, WIDTH_VALIDATOR, logger, env, TYPE_HELPER_INT)
                )
            }

            private val HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
            private val HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
            private val WIDTH_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
            private val WIDTH_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Resolution(env, json = it) }
        }

    }
}
