// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivVideoSourceTemplate : JSONSerializable, JsonTemplate<DivVideoSource> {
    @JvmField final val bitrate: Field<Expression<Long>>
    @JvmField final val mimeType: Field<Expression<String>>
    @JvmField final val resolution: Field<ResolutionTemplate>
    @JvmField final val url: Field<Expression<Uri>>

    constructor (
        env: ParsingEnvironment,
        parent: DivVideoSourceTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        bitrate = JsonTemplateParser.readOptionalFieldWithExpression(json, "bitrate", topLevel, parent?.bitrate, NUMBER_TO_INT, logger, env, TYPE_HELPER_INT)
        mimeType = JsonTemplateParser.readFieldWithExpression(json, "mime_type", topLevel, parent?.mimeType, logger, env, TYPE_HELPER_STRING)
        resolution = JsonTemplateParser.readOptionalField(json, "resolution", topLevel, parent?.resolution, ResolutionTemplate.CREATOR, logger, env)
        url = JsonTemplateParser.readFieldWithExpression(json, "url", topLevel, parent?.url, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivVideoSource {
        return DivVideoSource(
            bitrate = bitrate.resolveOptional(env = env, key = "bitrate", data = rawData, reader = BITRATE_READER),
            mimeType = mimeType.resolve(env = env, key = "mime_type", data = rawData, reader = MIME_TYPE_READER),
            resolution = resolution.resolveOptionalTemplate(env = env, key = "resolution", data = rawData, reader = RESOLUTION_READER),
            url = url.resolve(env = env, key = "url", data = rawData, reader = URL_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "bitrate", field = bitrate)
        json.writeFieldWithExpression(key = "mime_type", field = mimeType)
        json.writeField(key = "resolution", field = resolution)
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "url", field = url, converter = URI_TO_STRING)
        return json
    }

    companion object {
        const val TYPE = "video_source"

        val BITRATE_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, env.logger, env, TYPE_HELPER_INT) }
        val MIME_TYPE_READER: Reader<Expression<String>> = { key, json, env -> JsonParser.readExpression(json, key, env.logger, env, TYPE_HELPER_STRING) }
        val RESOLUTION_READER: Reader<DivVideoSource.Resolution?> = { key, json, env -> JsonParser.readOptional(json, key, DivVideoSource.Resolution.CREATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val URL_READER: Reader<Expression<Uri>> = { key, json, env -> JsonParser.readExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVideoSourceTemplate(env, json = it) }
    }


    @Mockable
    class ResolutionTemplate : JSONSerializable, JsonTemplate<DivVideoSource.Resolution> {
        @JvmField final val height: Field<Expression<Long>> // constraint: number > 0
        @JvmField final val width: Field<Expression<Long>> // constraint: number > 0

        constructor (
            env: ParsingEnvironment,
            parent: ResolutionTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            height = JsonTemplateParser.readFieldWithExpression(json, "height", topLevel, parent?.height, NUMBER_TO_INT, HEIGHT_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
            width = JsonTemplateParser.readFieldWithExpression(json, "width", topLevel, parent?.width, NUMBER_TO_INT, WIDTH_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivVideoSource.Resolution {
            return DivVideoSource.Resolution(
                height = height.resolve(env = env, key = "height", data = rawData, reader = HEIGHT_READER),
                width = width.resolve(env = env, key = "width", data = rawData, reader = WIDTH_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeFieldWithExpression(key = "height", field = height)
            json.write(key = "type", value = TYPE)
            json.writeFieldWithExpression(key = "width", field = width)
            return json
        }

        companion object {
            const val TYPE = "resolution"

            private val HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
            private val HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
            private val WIDTH_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
            private val WIDTH_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }

            val HEIGHT_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, HEIGHT_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
            val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
            val WIDTH_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readExpression(json, key, NUMBER_TO_INT, WIDTH_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> ResolutionTemplate(env, json = it) }
        }

    }
}
