// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivAnimationTemplate : JSONSerializable, JsonTemplate<DivAnimation> {
    @JvmField final val duration: Field<Expression<Long>> // constraint: number >= 0; default value: 300
    @JvmField final val endValue: Field<Expression<Double>>
    @JvmField final val interpolator: Field<Expression<DivAnimationInterpolator>> // default value: spring
    @JvmField final val items: Field<List<DivAnimationTemplate>>
    @JvmField final val name: Field<Expression<DivAnimation.Name>>
    @JvmField final val repeat: Field<DivCountTemplate> // default value: DivCount.Infinity(DivInfinityCount())
    @JvmField final val startDelay: Field<Expression<Long>> // constraint: number >= 0; default value: 0
    @JvmField final val startValue: Field<Expression<Double>>

    constructor (
        env: ParsingEnvironment,
        parent: DivAnimationTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        duration = JsonTemplateParser.readOptionalFieldWithExpression(json, "duration", topLevel, parent?.duration, NUMBER_TO_INT, DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        endValue = JsonTemplateParser.readOptionalFieldWithExpression(json, "end_value", topLevel, parent?.endValue, NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
        interpolator = JsonTemplateParser.readOptionalFieldWithExpression(json, "interpolator", topLevel, parent?.interpolator, DivAnimationInterpolator.Converter.FROM_STRING, logger, env, TYPE_HELPER_INTERPOLATOR)
        items = JsonTemplateParser.readOptionalListField(json, "items", topLevel, parent?.items, DivAnimationTemplate.CREATOR, logger, env)
        name = JsonTemplateParser.readFieldWithExpression(json, "name", topLevel, parent?.name, DivAnimation.Name.Converter.FROM_STRING, logger, env, TYPE_HELPER_NAME)
        repeat = JsonTemplateParser.readOptionalField(json, "repeat", topLevel, parent?.repeat, DivCountTemplate.CREATOR, logger, env)
        startDelay = JsonTemplateParser.readOptionalFieldWithExpression(json, "start_delay", topLevel, parent?.startDelay, NUMBER_TO_INT, START_DELAY_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        startValue = JsonTemplateParser.readOptionalFieldWithExpression(json, "start_value", topLevel, parent?.startValue, NUMBER_TO_DOUBLE, logger, env, TYPE_HELPER_DOUBLE)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivAnimation {
        return DivAnimation(
            duration = duration.resolveOptional(env = env, key = "duration", data = rawData, reader = DURATION_READER) ?: DURATION_DEFAULT_VALUE,
            endValue = endValue.resolveOptional(env = env, key = "end_value", data = rawData, reader = END_VALUE_READER),
            interpolator = interpolator.resolveOptional(env = env, key = "interpolator", data = rawData, reader = INTERPOLATOR_READER) ?: INTERPOLATOR_DEFAULT_VALUE,
            items = items.resolveOptionalTemplateList(env = env, key = "items", data = rawData, reader = ITEMS_READER),
            name = name.resolve(env = env, key = "name", data = rawData, reader = NAME_READER),
            repeat = repeat.resolveOptionalTemplate(env = env, key = "repeat", data = rawData, reader = REPEAT_READER) ?: REPEAT_DEFAULT_VALUE,
            startDelay = startDelay.resolveOptional(env = env, key = "start_delay", data = rawData, reader = START_DELAY_READER) ?: START_DELAY_DEFAULT_VALUE,
            startValue = startValue.resolveOptional(env = env, key = "start_value", data = rawData, reader = START_VALUE_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeFieldWithExpression(key = "duration", field = duration)
        json.writeFieldWithExpression(key = "end_value", field = endValue)
        json.writeFieldWithExpression(key = "interpolator", field = interpolator, converter = { v: DivAnimationInterpolator -> DivAnimationInterpolator.toString(v) })
        json.writeField(key = "items", field = items)
        json.writeFieldWithExpression(key = "name", field = name, converter = { v: DivAnimation.Name -> DivAnimation.Name.toString(v) })
        json.writeField(key = "repeat", field = repeat)
        json.writeFieldWithExpression(key = "start_delay", field = startDelay)
        json.writeFieldWithExpression(key = "start_value", field = startValue)
        return json
    }

    companion object {
        private val DURATION_DEFAULT_VALUE = Expression.constant(300L)
        private val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.SPRING)
        private val REPEAT_DEFAULT_VALUE = DivCount.Infinity(DivInfinityCount())
        private val START_DELAY_DEFAULT_VALUE = Expression.constant(0L)

        private val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }
        private val TYPE_HELPER_NAME = TypeHelper.from(default = DivAnimation.Name.values().first()) { it is DivAnimation.Name }

        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val START_DELAY_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val START_DELAY_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

        val DURATION_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, DURATION_VALIDATOR, env.logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE }
        val END_VALUE_READER: Reader<Expression<Double>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, env.logger, env, TYPE_HELPER_DOUBLE) }
        val INTERPOLATOR_READER: Reader<Expression<DivAnimationInterpolator>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAnimationInterpolator.Converter.FROM_STRING, env.logger, env, INTERPOLATOR_DEFAULT_VALUE, TYPE_HELPER_INTERPOLATOR) ?: INTERPOLATOR_DEFAULT_VALUE }
        val ITEMS_READER: Reader<List<DivAnimation>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAnimation.CREATOR, env.logger, env) }
        val NAME_READER: Reader<Expression<DivAnimation.Name>> = { key, json, env -> JsonParser.readExpression(json, key, DivAnimation.Name.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_NAME) }
        val REPEAT_READER: Reader<DivCount> = { key, json, env -> JsonParser.readOptional(json, key, DivCount.CREATOR, env.logger, env) ?: REPEAT_DEFAULT_VALUE }
        val START_DELAY_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, START_DELAY_VALIDATOR, env.logger, env, START_DELAY_DEFAULT_VALUE, TYPE_HELPER_INT) ?: START_DELAY_DEFAULT_VALUE }
        val START_VALUE_READER: Reader<Expression<Double>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, env.logger, env, TYPE_HELPER_DOUBLE) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAnimationTemplate(env, json = it) }
    }

}
