// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivAppearanceTransition : JSONSerializable, Hashable {
    class Set(val value: DivAppearanceSetTransition) : DivAppearanceTransition()
    class Fade(val value: DivFadeTransition) : DivAppearanceTransition()
    class Scale(val value: DivScaleTransition) : DivAppearanceTransition()
    class Slide(val value: DivSlideTransition) : DivAppearanceTransition()

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        return when(this) {
            is Set -> 31 + this.value.hash()
            is Fade -> 62 + this.value.hash()
            is Scale -> 93 + this.value.hash()
            is Slide -> 124 + this.value.hash()
        }.also {
            _hash = it
        }
    }

    fun value(): Any {
        return when (this) {
            is Set -> value
            is Fade -> value
            is Scale -> value
            is Slide -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Set -> value.writeToJSON()
            is Fade -> value.writeToJSON()
            is Scale -> value.writeToJSON()
            is Slide -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivAppearanceTransition {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivAppearanceSetTransition.TYPE -> return Set(DivAppearanceSetTransition(env, json))
                DivFadeTransition.TYPE -> return Fade(DivFadeTransition(env, json))
                DivScaleTransition.TYPE -> return Scale(DivScaleTransition(env, json))
                DivSlideTransition.TYPE -> return Slide(DivSlideTransition(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivAppearanceTransitionTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivAppearanceTransition(env, json = it) }
    }
}
