// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivContainer @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    @JvmField final val action: DivAction? = null,
    @JvmField final val actionAnimation: DivAnimation = ACTION_ANIMATION_DEFAULT_VALUE, // default value: DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField final val actions: List<DivAction>? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val aspect: DivAspect? = null,
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    @JvmField final val clipToBounds: Expression<Boolean> = CLIP_TO_BOUNDS_DEFAULT_VALUE, // default value: true
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val contentAlignmentHorizontal: Expression<DivContentAlignmentHorizontal> = CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: start
    @JvmField final val contentAlignmentVertical: Expression<DivContentAlignmentVertical> = CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: top
    override val disappearActions: List<DivDisappearAction>? = null,
    @JvmField final val doubletapActions: List<DivAction>? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null,
    @JvmField final val itemBuilder: DivCollectionItemBuilder? = null,
    @JvmField final val items: List<Div>? = null,
    @JvmField final val layoutMode: Expression<LayoutMode> = LAYOUT_MODE_DEFAULT_VALUE, // default value: no_wrap
    @JvmField final val lineSeparator: Separator? = null,
    @JvmField final val longtapActions: List<DivAction>? = null,
    override val margins: DivEdgeInsets? = null,
    @JvmField final val orientation: Expression<Orientation> = ORIENTATION_DEFAULT_VALUE, // default value: vertical
    override val paddings: DivEdgeInsets? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    override val selectedActions: List<DivAction>? = null,
    @JvmField final val separator: Separator? = null,
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (action?.hash() ?: 0) +
            actionAnimation.hash() +
            (actions?.sumOf { it.hash() } ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (aspect?.hash() ?: 0) +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            clipToBounds.hashCode() +
            (columnSpan?.hashCode() ?: 0) +
            contentAlignmentHorizontal.hashCode() +
            contentAlignmentVertical.hashCode() +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (doubletapActions?.sumOf { it.hash() } ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            height.hash() +
            (id?.hashCode() ?: 0) +
            (itemBuilder?.hash() ?: 0) +
            (items?.sumOf { it.hash() } ?: 0) +
            layoutMode.hashCode() +
            (lineSeparator?.hash() ?: 0) +
            (longtapActions?.sumOf { it.hash() } ?: 0) +
            (margins?.hash() ?: 0) +
            orientation.hashCode() +
            (paddings?.hash() ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            (separator?.hash() ?: 0) +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.write(key = "action", value = action)
        json.write(key = "action_animation", value = actionAnimation)
        json.write(key = "actions", value = actions)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "aspect", value = aspect)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "clip_to_bounds", value = clipToBounds)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.writeExpression(key = "content_alignment_horizontal", value = contentAlignmentHorizontal, converter = { v: DivContentAlignmentHorizontal -> DivContentAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "content_alignment_vertical", value = contentAlignmentVertical, converter = { v: DivContentAlignmentVertical -> DivContentAlignmentVertical.toString(v) })
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "doubletap_actions", value = doubletapActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "item_builder", value = itemBuilder)
        json.write(key = "items", value = items)
        json.writeExpression(key = "layout_mode", value = layoutMode, converter = { v: LayoutMode -> LayoutMode.toString(v) })
        json.write(key = "line_separator", value = lineSeparator)
        json.write(key = "longtap_actions", value = longtapActions)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "orientation", value = orientation, converter = { v: Orientation -> Orientation.toString(v) })
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "separator", value = separator)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    fun copyWithNewProperties(
        items: List<Div>,
    ) = DivContainer(
        accessibility,
        action,
        actionAnimation,
        actions,
        alignmentHorizontal,
        alignmentVertical,
        alpha,
        aspect,
        background,
        border,
        clipToBounds,
        columnSpan,
        contentAlignmentHorizontal,
        contentAlignmentVertical,
        disappearActions,
        doubletapActions,
        extensions,
        focus,
        height,
        id,
        itemBuilder,
        items,
        layoutMode,
        lineSeparator,
        longtapActions,
        margins,
        orientation,
        paddings,
        rowSpan,
        selectedActions,
        separator,
        tooltips,
        transform,
        transitionChange,
        transitionIn,
        transitionOut,
        transitionTriggers,
        visibility,
        visibilityAction,
        visibilityActions,
        width,
    )

    companion object {
        const val TYPE = "container"

        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CLIP_TO_BOUNDS_DEFAULT_VALUE = Expression.constant(true)
        private val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivContentAlignmentHorizontal.START)
        private val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivContentAlignmentVertical.TOP)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val LAYOUT_MODE_DEFAULT_VALUE = Expression.constant(LayoutMode.NO_WRAP)
        private val ORIENTATION_DEFAULT_VALUE = Expression.constant(Orientation.VERTICAL)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivContentAlignmentHorizontal.values().first()) { it is DivContentAlignmentHorizontal }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivContentAlignmentVertical.values().first()) { it is DivContentAlignmentVertical }
        private val TYPE_HELPER_LAYOUT_MODE = TypeHelper.from(default = DivContainer.LayoutMode.values().first()) { it is DivContainer.LayoutMode }
        private val TYPE_HELPER_ORIENTATION = TypeHelper.from(default = DivContainer.Orientation.values().first()) { it is DivContainer.Orientation }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivContainer {
            val logger = env.logger
            return DivContainer(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                action = JsonParser.readOptional(json, "action", DivAction.CREATOR, logger, env),
                actionAnimation = JsonParser.readOptional(json, "action_animation", DivAnimation.CREATOR, logger, env) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                aspect = JsonParser.readOptional(json, "aspect", DivAspect.CREATOR, logger, env),
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                clipToBounds = JsonParser.readOptionalExpression(json, "clip_to_bounds", ANY_TO_BOOLEAN, logger, env, CLIP_TO_BOUNDS_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: CLIP_TO_BOUNDS_DEFAULT_VALUE,
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                contentAlignmentHorizontal = JsonParser.readOptionalExpression(json, "content_alignment_horizontal", DivContentAlignmentHorizontal.Converter.FROM_STRING, logger, env, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonParser.readOptionalExpression(json, "content_alignment_vertical", DivContentAlignmentVertical.Converter.FROM_STRING, logger, env, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                doubletapActions = JsonParser.readOptionalList(json, "doubletap_actions", DivAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", logger, env),
                itemBuilder = JsonParser.readOptional(json, "item_builder", DivCollectionItemBuilder.CREATOR, logger, env),
                items = JsonParser.readOptionalList(json, "items", Div.CREATOR, logger, env),
                layoutMode = JsonParser.readOptionalExpression(json, "layout_mode", LayoutMode.Converter.FROM_STRING, logger, env, LAYOUT_MODE_DEFAULT_VALUE, TYPE_HELPER_LAYOUT_MODE) ?: LAYOUT_MODE_DEFAULT_VALUE,
                lineSeparator = JsonParser.readOptional(json, "line_separator", Separator.CREATOR, logger, env),
                longtapActions = JsonParser.readOptionalList(json, "longtap_actions", DivAction.CREATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                orientation = JsonParser.readOptionalExpression(json, "orientation", Orientation.Converter.FROM_STRING, logger, env, ORIENTATION_DEFAULT_VALUE, TYPE_HELPER_ORIENTATION) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                separator = JsonParser.readOptional(json, "separator", Separator.CREATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivContainer(env, json = it) }
    }


    @Mockable
    class Separator @DivModelInternalApi constructor (
        @JvmField final val margins: DivEdgeInsets? = null,
        @JvmField final val showAtEnd: Expression<Boolean> = SHOW_AT_END_DEFAULT_VALUE, // default value: false
        @JvmField final val showAtStart: Expression<Boolean> = SHOW_AT_START_DEFAULT_VALUE, // default value: false
        @JvmField final val showBetween: Expression<Boolean> = SHOW_BETWEEN_DEFAULT_VALUE, // default value: true
        @JvmField final val style: DivDrawable,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                (margins?.hash() ?: 0) +
                showAtEnd.hashCode() +
                showAtStart.hashCode() +
                showBetween.hashCode() +
                style.hash()
            _hash = hash
            return hash
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "margins", value = margins)
            json.writeExpression(key = "show_at_end", value = showAtEnd)
            json.writeExpression(key = "show_at_start", value = showAtStart)
            json.writeExpression(key = "show_between", value = showBetween)
            json.write(key = "style", value = style)
            return json
        }

        companion object {
            private val SHOW_AT_END_DEFAULT_VALUE = Expression.constant(false)
            private val SHOW_AT_START_DEFAULT_VALUE = Expression.constant(false)
            private val SHOW_BETWEEN_DEFAULT_VALUE = Expression.constant(true)

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Separator {
                val logger = env.logger
                return Separator(
                    margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                    showAtEnd = JsonParser.readOptionalExpression(json, "show_at_end", ANY_TO_BOOLEAN, logger, env, SHOW_AT_END_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SHOW_AT_END_DEFAULT_VALUE,
                    showAtStart = JsonParser.readOptionalExpression(json, "show_at_start", ANY_TO_BOOLEAN, logger, env, SHOW_AT_START_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SHOW_AT_START_DEFAULT_VALUE,
                    showBetween = JsonParser.readOptionalExpression(json, "show_between", ANY_TO_BOOLEAN, logger, env, SHOW_BETWEEN_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SHOW_BETWEEN_DEFAULT_VALUE,
                    style = JsonParser.read(json, "style", DivDrawable.CREATOR, logger, env)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Separator(env, json = it) }
        }

    }

    enum class Orientation(private val value: String) {
        VERTICAL("vertical"),
        HORIZONTAL("horizontal"),
        OVERLAP("overlap");

        companion object Converter {
            fun toString(obj: Orientation): String {
                return obj.value
            }

            fun fromString(string: String): Orientation? {
                return when (string) {
                    VERTICAL.value -> VERTICAL
                    HORIZONTAL.value -> HORIZONTAL
                    OVERLAP.value -> OVERLAP
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    VERTICAL.value -> VERTICAL
                    HORIZONTAL.value -> HORIZONTAL
                    OVERLAP.value -> OVERLAP
                    else -> null
                }
            }
        }
    }

    enum class LayoutMode(private val value: String) {
        NO_WRAP("no_wrap"),
        WRAP("wrap");

        companion object Converter {
            fun toString(obj: LayoutMode): String {
                return obj.value
            }

            fun fromString(string: String): LayoutMode? {
                return when (string) {
                    NO_WRAP.value -> NO_WRAP
                    WRAP.value -> WRAP
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    NO_WRAP.value -> NO_WRAP
                    WRAP.value -> WRAP
                    else -> null
                }
            }
        }
    }
}
