// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivDisappearAction @DivModelInternalApi constructor (
    @JvmField final val disappearDuration: Expression<Long> = DISAPPEAR_DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 800
    override val downloadCallbacks: DivDownloadCallbacks? = null,
    override val isEnabled: Expression<Boolean> = IS_ENABLED_DEFAULT_VALUE, // default value: true
    override val logId: String,
    override val logLimit: Expression<Long> = LOG_LIMIT_DEFAULT_VALUE, // constraint: number >= 0; default value: 1
    override val payload: JSONObject? = null,
    override val referer: Expression<Uri>? = null,
    override val typed: DivActionTyped? = null,
    override val url: Expression<Uri>? = null,
    @JvmField final val visibilityPercentage: Expression<Long> = VISIBILITY_PERCENTAGE_DEFAULT_VALUE, // constraint: number >= 0 && number < 100; default value: 0
) : JSONSerializable, Hashable, DivSightAction {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            disappearDuration.hashCode() +
            (downloadCallbacks?.hash() ?: 0) +
            isEnabled.hashCode() +
            logId.hashCode() +
            logLimit.hashCode() +
            (payload?.hashCode() ?: 0) +
            (referer?.hashCode() ?: 0) +
            (typed?.hash() ?: 0) +
            (url?.hashCode() ?: 0) +
            visibilityPercentage.hashCode()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "disappear_duration", value = disappearDuration)
        json.write(key = "download_callbacks", value = downloadCallbacks)
        json.writeExpression(key = "is_enabled", value = isEnabled)
        json.write(key = "log_id", value = logId)
        json.writeExpression(key = "log_limit", value = logLimit)
        json.write(key = "payload", value = payload)
        json.writeExpression(key = "referer", value = referer, converter = URI_TO_STRING)
        json.write(key = "typed", value = typed)
        json.writeExpression(key = "url", value = url, converter = URI_TO_STRING)
        json.writeExpression(key = "visibility_percentage", value = visibilityPercentage)
        return json
    }

    companion object {
        private val DISAPPEAR_DURATION_DEFAULT_VALUE = Expression.constant(800L)
        private val IS_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        private val LOG_LIMIT_DEFAULT_VALUE = Expression.constant(1L)
        private val VISIBILITY_PERCENTAGE_DEFAULT_VALUE = Expression.constant(0L)

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivDisappearAction {
            val logger = env.logger
            return DivDisappearAction(
                disappearDuration = JsonParser.readOptionalExpression(json, "disappear_duration", NUMBER_TO_INT, DISAPPEAR_DURATION_VALIDATOR, logger, env, DISAPPEAR_DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DISAPPEAR_DURATION_DEFAULT_VALUE,
                downloadCallbacks = JsonParser.readOptional(json, "download_callbacks", DivDownloadCallbacks.CREATOR, logger, env),
                isEnabled = JsonParser.readOptionalExpression(json, "is_enabled", ANY_TO_BOOLEAN, logger, env, IS_ENABLED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: IS_ENABLED_DEFAULT_VALUE,
                logId = JsonParser.read(json, "log_id", logger, env),
                logLimit = JsonParser.readOptionalExpression(json, "log_limit", NUMBER_TO_INT, LOG_LIMIT_VALIDATOR, logger, env, LOG_LIMIT_DEFAULT_VALUE, TYPE_HELPER_INT) ?: LOG_LIMIT_DEFAULT_VALUE,
                payload = JsonParser.readOptional(json, "payload", logger, env),
                referer = JsonParser.readOptionalExpression(json, "referer", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                typed = JsonParser.readOptional(json, "typed", DivActionTyped.CREATOR, logger, env),
                url = JsonParser.readOptionalExpression(json, "url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                visibilityPercentage = JsonParser.readOptionalExpression(json, "visibility_percentage", NUMBER_TO_INT, VISIBILITY_PERCENTAGE_VALIDATOR, logger, env, VISIBILITY_PERCENTAGE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: VISIBILITY_PERCENTAGE_DEFAULT_VALUE
            )
        }

        private val DISAPPEAR_DURATION_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val DISAPPEAR_DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LOG_LIMIT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LOG_LIMIT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val VISIBILITY_PERCENTAGE_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 && it < 100 }
        private val VISIBILITY_PERCENTAGE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 && it < 100 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivDisappearAction(env, json = it) }
    }

}
