// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivGifImage @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    @JvmField final val action: DivAction? = null,
    @JvmField final val actionAnimation: DivAnimation = ACTION_ANIMATION_DEFAULT_VALUE, // default value: DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField final val actions: List<DivAction>? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val aspect: DivAspect? = null,
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val contentAlignmentHorizontal: Expression<DivAlignmentHorizontal> = CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: center
    @JvmField final val contentAlignmentVertical: Expression<DivAlignmentVertical> = CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: center
    override val disappearActions: List<DivDisappearAction>? = null,
    @JvmField final val doubletapActions: List<DivAction>? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    @JvmField final val gifUrl: Expression<Uri>,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null,
    @JvmField final val longtapActions: List<DivAction>? = null,
    override val margins: DivEdgeInsets? = null,
    override val paddings: DivEdgeInsets? = null,
    @JvmField final val placeholderColor: Expression<Int> = PLACEHOLDER_COLOR_DEFAULT_VALUE, // default value: #14000000
    @JvmField final val preloadRequired: Expression<Boolean> = PRELOAD_REQUIRED_DEFAULT_VALUE, // default value: false
    @JvmField final val preview: Expression<String>? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val scale: Expression<DivImageScale> = SCALE_DEFAULT_VALUE, // default value: fill
    override val selectedActions: List<DivAction>? = null,
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (action?.hash() ?: 0) +
            actionAnimation.hash() +
            (actions?.sumOf { it.hash() } ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (aspect?.hash() ?: 0) +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            contentAlignmentHorizontal.hashCode() +
            contentAlignmentVertical.hashCode() +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (doubletapActions?.sumOf { it.hash() } ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            gifUrl.hashCode() +
            height.hash() +
            (id?.hashCode() ?: 0) +
            (longtapActions?.sumOf { it.hash() } ?: 0) +
            (margins?.hash() ?: 0) +
            (paddings?.hash() ?: 0) +
            placeholderColor.hashCode() +
            preloadRequired.hashCode() +
            (preview?.hashCode() ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            scale.hashCode() +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.write(key = "action", value = action)
        json.write(key = "action_animation", value = actionAnimation)
        json.write(key = "actions", value = actions)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "aspect", value = aspect)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.writeExpression(key = "content_alignment_horizontal", value = contentAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "content_alignment_vertical", value = contentAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "doubletap_actions", value = doubletapActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.writeExpression(key = "gif_url", value = gifUrl, converter = URI_TO_STRING)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "longtap_actions", value = longtapActions)
        json.write(key = "margins", value = margins)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "placeholder_color", value = placeholderColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "preload_required", value = preloadRequired)
        json.writeExpression(key = "preview", value = preview)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.writeExpression(key = "scale", value = scale, converter = { v: DivImageScale -> DivImageScale.toString(v) })
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "gif"

        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.CENTER)
        private val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val PLACEHOLDER_COLOR_DEFAULT_VALUE = Expression.constant(0x14000000.toInt())
        private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        private val SCALE_DEFAULT_VALUE = Expression.constant(DivImageScale.FILL)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_SCALE = TypeHelper.from(default = DivImageScale.values().first()) { it is DivImageScale }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivGifImage {
            val logger = env.logger
            return DivGifImage(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                action = JsonParser.readOptional(json, "action", DivAction.CREATOR, logger, env),
                actionAnimation = JsonParser.readOptional(json, "action_animation", DivAnimation.CREATOR, logger, env) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonParser.readOptionalList(json, "actions", DivAction.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                aspect = JsonParser.readOptional(json, "aspect", DivAspect.CREATOR, logger, env),
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                contentAlignmentHorizontal = JsonParser.readOptionalExpression(json, "content_alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonParser.readOptionalExpression(json, "content_alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                doubletapActions = JsonParser.readOptionalList(json, "doubletap_actions", DivAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                gifUrl = JsonParser.readExpression(json, "gif_url", STRING_TO_URI, logger, env, TYPE_HELPER_URI),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", logger, env),
                longtapActions = JsonParser.readOptionalList(json, "longtap_actions", DivAction.CREATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                placeholderColor = JsonParser.readOptionalExpression(json, "placeholder_color", STRING_TO_COLOR_INT, logger, env, PLACEHOLDER_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: PLACEHOLDER_COLOR_DEFAULT_VALUE,
                preloadRequired = JsonParser.readOptionalExpression(json, "preload_required", ANY_TO_BOOLEAN, logger, env, PRELOAD_REQUIRED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                preview = JsonParser.readOptionalExpression(json, "preview", logger, env, TYPE_HELPER_STRING),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                scale = JsonParser.readOptionalExpression(json, "scale", DivImageScale.Converter.FROM_STRING, logger, env, SCALE_DEFAULT_VALUE, TYPE_HELPER_SCALE) ?: SCALE_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivGifImage(env, json = it) }
    }

}
