// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivGifImageTemplate : JSONSerializable, JsonTemplate<DivGifImage> {
    @JvmField final val accessibility: Field<DivAccessibilityTemplate>
    @JvmField final val action: Field<DivActionTemplate>
    @JvmField final val actionAnimation: Field<DivAnimationTemplate> // default value: DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField final val actions: Field<List<DivActionTemplate>>
    @JvmField final val alignmentHorizontal: Field<Expression<DivAlignmentHorizontal>>
    @JvmField final val alignmentVertical: Field<Expression<DivAlignmentVertical>>
    @JvmField final val alpha: Field<Expression<Double>> // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val aspect: Field<DivAspectTemplate>
    @JvmField final val background: Field<List<DivBackgroundTemplate>>
    @JvmField final val border: Field<DivBorderTemplate>
    @JvmField final val columnSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val contentAlignmentHorizontal: Field<Expression<DivAlignmentHorizontal>> // default value: center
    @JvmField final val contentAlignmentVertical: Field<Expression<DivAlignmentVertical>> // default value: center
    @JvmField final val disappearActions: Field<List<DivDisappearActionTemplate>>
    @JvmField final val doubletapActions: Field<List<DivActionTemplate>>
    @JvmField final val extensions: Field<List<DivExtensionTemplate>>
    @JvmField final val focus: Field<DivFocusTemplate>
    @JvmField final val gifUrl: Field<Expression<Uri>>
    @JvmField final val height: Field<DivSizeTemplate> // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val id: Field<String>
    @JvmField final val longtapActions: Field<List<DivActionTemplate>>
    @JvmField final val margins: Field<DivEdgeInsetsTemplate>
    @JvmField final val paddings: Field<DivEdgeInsetsTemplate>
    @JvmField final val placeholderColor: Field<Expression<Int>> // default value: #14000000
    @JvmField final val preloadRequired: Field<Expression<Boolean>> // default value: false
    @JvmField final val preview: Field<Expression<String>>
    @JvmField final val rowSpan: Field<Expression<Long>> // constraint: number >= 0
    @JvmField final val scale: Field<Expression<DivImageScale>> // default value: fill
    @JvmField final val selectedActions: Field<List<DivActionTemplate>>
    @JvmField final val tooltips: Field<List<DivTooltipTemplate>>
    @JvmField final val transform: Field<DivTransformTemplate>
    @JvmField final val transitionChange: Field<DivChangeTransitionTemplate>
    @JvmField final val transitionIn: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionOut: Field<DivAppearanceTransitionTemplate>
    @JvmField final val transitionTriggers: Field<List<DivTransitionTrigger>> // at least 1 elements
    @JvmField final val visibility: Field<Expression<DivVisibility>> // default value: visible
    @JvmField final val visibilityAction: Field<DivVisibilityActionTemplate>
    @JvmField final val visibilityActions: Field<List<DivVisibilityActionTemplate>>
    @JvmField final val width: Field<DivSizeTemplate> // default value: DivSize.MatchParent(DivMatchParentSize())

    constructor (
        env: ParsingEnvironment,
        parent: DivGifImageTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        accessibility = JsonTemplateParser.readOptionalField(json, "accessibility", topLevel, parent?.accessibility, DivAccessibilityTemplate.CREATOR, logger, env)
        action = JsonTemplateParser.readOptionalField(json, "action", topLevel, parent?.action, DivActionTemplate.CREATOR, logger, env)
        actionAnimation = JsonTemplateParser.readOptionalField(json, "action_animation", topLevel, parent?.actionAnimation, DivAnimationTemplate.CREATOR, logger, env)
        actions = JsonTemplateParser.readOptionalListField(json, "actions", topLevel, parent?.actions, DivActionTemplate.CREATOR, logger, env)
        alignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_horizontal", topLevel, parent?.alignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL)
        alignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "alignment_vertical", topLevel, parent?.alignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL)
        alpha = JsonTemplateParser.readOptionalFieldWithExpression(json, "alpha", topLevel, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_DOUBLE)
        aspect = JsonTemplateParser.readOptionalField(json, "aspect", topLevel, parent?.aspect, DivAspectTemplate.CREATOR, logger, env)
        background = JsonTemplateParser.readOptionalListField(json, "background", topLevel, parent?.background, DivBackgroundTemplate.CREATOR, logger, env)
        border = JsonTemplateParser.readOptionalField(json, "border", topLevel, parent?.border, DivBorderTemplate.CREATOR, logger, env)
        columnSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "column_span", topLevel, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        contentAlignmentHorizontal = JsonTemplateParser.readOptionalFieldWithExpression(json, "content_alignment_horizontal", topLevel, parent?.contentAlignmentHorizontal, DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL)
        contentAlignmentVertical = JsonTemplateParser.readOptionalFieldWithExpression(json, "content_alignment_vertical", topLevel, parent?.contentAlignmentVertical, DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL)
        disappearActions = JsonTemplateParser.readOptionalListField(json, "disappear_actions", topLevel, parent?.disappearActions, DivDisappearActionTemplate.CREATOR, logger, env)
        doubletapActions = JsonTemplateParser.readOptionalListField(json, "doubletap_actions", topLevel, parent?.doubletapActions, DivActionTemplate.CREATOR, logger, env)
        extensions = JsonTemplateParser.readOptionalListField(json, "extensions", topLevel, parent?.extensions, DivExtensionTemplate.CREATOR, logger, env)
        focus = JsonTemplateParser.readOptionalField(json, "focus", topLevel, parent?.focus, DivFocusTemplate.CREATOR, logger, env)
        gifUrl = JsonTemplateParser.readFieldWithExpression(json, "gif_url", topLevel, parent?.gifUrl, STRING_TO_URI, logger, env, TYPE_HELPER_URI)
        height = JsonTemplateParser.readOptionalField(json, "height", topLevel, parent?.height, DivSizeTemplate.CREATOR, logger, env)
        id = JsonTemplateParser.readOptionalField(json, "id", topLevel, parent?.id, logger, env)
        longtapActions = JsonTemplateParser.readOptionalListField(json, "longtap_actions", topLevel, parent?.longtapActions, DivActionTemplate.CREATOR, logger, env)
        margins = JsonTemplateParser.readOptionalField(json, "margins", topLevel, parent?.margins, DivEdgeInsetsTemplate.CREATOR, logger, env)
        paddings = JsonTemplateParser.readOptionalField(json, "paddings", topLevel, parent?.paddings, DivEdgeInsetsTemplate.CREATOR, logger, env)
        placeholderColor = JsonTemplateParser.readOptionalFieldWithExpression(json, "placeholder_color", topLevel, parent?.placeholderColor, STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
        preloadRequired = JsonTemplateParser.readOptionalFieldWithExpression(json, "preload_required", topLevel, parent?.preloadRequired, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        preview = JsonTemplateParser.readOptionalFieldWithExpression(json, "preview", topLevel, parent?.preview, logger, env, TYPE_HELPER_STRING)
        rowSpan = JsonTemplateParser.readOptionalFieldWithExpression(json, "row_span", topLevel, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        scale = JsonTemplateParser.readOptionalFieldWithExpression(json, "scale", topLevel, parent?.scale, DivImageScale.Converter.FROM_STRING, logger, env, TYPE_HELPER_SCALE)
        selectedActions = JsonTemplateParser.readOptionalListField(json, "selected_actions", topLevel, parent?.selectedActions, DivActionTemplate.CREATOR, logger, env)
        tooltips = JsonTemplateParser.readOptionalListField(json, "tooltips", topLevel, parent?.tooltips, DivTooltipTemplate.CREATOR, logger, env)
        transform = JsonTemplateParser.readOptionalField(json, "transform", topLevel, parent?.transform, DivTransformTemplate.CREATOR, logger, env)
        transitionChange = JsonTemplateParser.readOptionalField(json, "transition_change", topLevel, parent?.transitionChange, DivChangeTransitionTemplate.CREATOR, logger, env)
        transitionIn = JsonTemplateParser.readOptionalField(json, "transition_in", topLevel, parent?.transitionIn, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionOut = JsonTemplateParser.readOptionalField(json, "transition_out", topLevel, parent?.transitionOut, DivAppearanceTransitionTemplate.CREATOR, logger, env)
        transitionTriggers = JsonTemplateParser.readOptionalListField(json, "transition_triggers", topLevel, parent?.transitionTriggers, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR, logger, env)
        visibility = JsonTemplateParser.readOptionalFieldWithExpression(json, "visibility", topLevel, parent?.visibility, DivVisibility.Converter.FROM_STRING, logger, env, TYPE_HELPER_VISIBILITY)
        visibilityAction = JsonTemplateParser.readOptionalField(json, "visibility_action", topLevel, parent?.visibilityAction, DivVisibilityActionTemplate.CREATOR, logger, env)
        visibilityActions = JsonTemplateParser.readOptionalListField(json, "visibility_actions", topLevel, parent?.visibilityActions, DivVisibilityActionTemplate.CREATOR, logger, env)
        width = JsonTemplateParser.readOptionalField(json, "width", topLevel, parent?.width, DivSizeTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivGifImage {
        return DivGifImage(
            accessibility = accessibility.resolveOptionalTemplate(env = env, key = "accessibility", data = rawData, reader = ACCESSIBILITY_READER),
            action = action.resolveOptionalTemplate(env = env, key = "action", data = rawData, reader = ACTION_READER),
            actionAnimation = actionAnimation.resolveOptionalTemplate(env = env, key = "action_animation", data = rawData, reader = ACTION_ANIMATION_READER) ?: ACTION_ANIMATION_DEFAULT_VALUE,
            actions = actions.resolveOptionalTemplateList(env = env, key = "actions", data = rawData, reader = ACTIONS_READER),
            alignmentHorizontal = alignmentHorizontal.resolveOptional(env = env, key = "alignment_horizontal", data = rawData, reader = ALIGNMENT_HORIZONTAL_READER),
            alignmentVertical = alignmentVertical.resolveOptional(env = env, key = "alignment_vertical", data = rawData, reader = ALIGNMENT_VERTICAL_READER),
            alpha = alpha.resolveOptional(env = env, key = "alpha", data = rawData, reader = ALPHA_READER) ?: ALPHA_DEFAULT_VALUE,
            aspect = aspect.resolveOptionalTemplate(env = env, key = "aspect", data = rawData, reader = ASPECT_READER),
            background = background.resolveOptionalTemplateList(env = env, key = "background", data = rawData, reader = BACKGROUND_READER),
            border = border.resolveOptionalTemplate(env = env, key = "border", data = rawData, reader = BORDER_READER),
            columnSpan = columnSpan.resolveOptional(env = env, key = "column_span", data = rawData, reader = COLUMN_SPAN_READER),
            contentAlignmentHorizontal = contentAlignmentHorizontal.resolveOptional(env = env, key = "content_alignment_horizontal", data = rawData, reader = CONTENT_ALIGNMENT_HORIZONTAL_READER) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
            contentAlignmentVertical = contentAlignmentVertical.resolveOptional(env = env, key = "content_alignment_vertical", data = rawData, reader = CONTENT_ALIGNMENT_VERTICAL_READER) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
            disappearActions = disappearActions.resolveOptionalTemplateList(env = env, key = "disappear_actions", data = rawData, reader = DISAPPEAR_ACTIONS_READER),
            doubletapActions = doubletapActions.resolveOptionalTemplateList(env = env, key = "doubletap_actions", data = rawData, reader = DOUBLETAP_ACTIONS_READER),
            extensions = extensions.resolveOptionalTemplateList(env = env, key = "extensions", data = rawData, reader = EXTENSIONS_READER),
            focus = focus.resolveOptionalTemplate(env = env, key = "focus", data = rawData, reader = FOCUS_READER),
            gifUrl = gifUrl.resolve(env = env, key = "gif_url", data = rawData, reader = GIF_URL_READER),
            height = height.resolveOptionalTemplate(env = env, key = "height", data = rawData, reader = HEIGHT_READER) ?: HEIGHT_DEFAULT_VALUE,
            id = id.resolveOptional(env = env, key = "id", data = rawData, reader = ID_READER),
            longtapActions = longtapActions.resolveOptionalTemplateList(env = env, key = "longtap_actions", data = rawData, reader = LONGTAP_ACTIONS_READER),
            margins = margins.resolveOptionalTemplate(env = env, key = "margins", data = rawData, reader = MARGINS_READER),
            paddings = paddings.resolveOptionalTemplate(env = env, key = "paddings", data = rawData, reader = PADDINGS_READER),
            placeholderColor = placeholderColor.resolveOptional(env = env, key = "placeholder_color", data = rawData, reader = PLACEHOLDER_COLOR_READER) ?: PLACEHOLDER_COLOR_DEFAULT_VALUE,
            preloadRequired = preloadRequired.resolveOptional(env = env, key = "preload_required", data = rawData, reader = PRELOAD_REQUIRED_READER) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
            preview = preview.resolveOptional(env = env, key = "preview", data = rawData, reader = PREVIEW_READER),
            rowSpan = rowSpan.resolveOptional(env = env, key = "row_span", data = rawData, reader = ROW_SPAN_READER),
            scale = scale.resolveOptional(env = env, key = "scale", data = rawData, reader = SCALE_READER) ?: SCALE_DEFAULT_VALUE,
            selectedActions = selectedActions.resolveOptionalTemplateList(env = env, key = "selected_actions", data = rawData, reader = SELECTED_ACTIONS_READER),
            tooltips = tooltips.resolveOptionalTemplateList(env = env, key = "tooltips", data = rawData, reader = TOOLTIPS_READER),
            transform = transform.resolveOptionalTemplate(env = env, key = "transform", data = rawData, reader = TRANSFORM_READER),
            transitionChange = transitionChange.resolveOptionalTemplate(env = env, key = "transition_change", data = rawData, reader = TRANSITION_CHANGE_READER),
            transitionIn = transitionIn.resolveOptionalTemplate(env = env, key = "transition_in", data = rawData, reader = TRANSITION_IN_READER),
            transitionOut = transitionOut.resolveOptionalTemplate(env = env, key = "transition_out", data = rawData, reader = TRANSITION_OUT_READER),
            transitionTriggers = transitionTriggers.resolveOptionalList(env = env, key = "transition_triggers", data = rawData, TRANSITION_TRIGGERS_VALIDATOR, reader = TRANSITION_TRIGGERS_READER),
            visibility = visibility.resolveOptional(env = env, key = "visibility", data = rawData, reader = VISIBILITY_READER) ?: VISIBILITY_DEFAULT_VALUE,
            visibilityAction = visibilityAction.resolveOptionalTemplate(env = env, key = "visibility_action", data = rawData, reader = VISIBILITY_ACTION_READER),
            visibilityActions = visibilityActions.resolveOptionalTemplateList(env = env, key = "visibility_actions", data = rawData, reader = VISIBILITY_ACTIONS_READER),
            width = width.resolveOptionalTemplate(env = env, key = "width", data = rawData, reader = WIDTH_READER) ?: WIDTH_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "accessibility", field = accessibility)
        json.writeField(key = "action", field = action)
        json.writeField(key = "action_animation", field = actionAnimation)
        json.writeField(key = "actions", field = actions)
        json.writeFieldWithExpression(key = "alignment_horizontal", field = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "alignment_vertical", field = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeFieldWithExpression(key = "alpha", field = alpha)
        json.writeField(key = "aspect", field = aspect)
        json.writeField(key = "background", field = background)
        json.writeField(key = "border", field = border)
        json.writeFieldWithExpression(key = "column_span", field = columnSpan)
        json.writeFieldWithExpression(key = "content_alignment_horizontal", field = contentAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeFieldWithExpression(key = "content_alignment_vertical", field = contentAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeField(key = "disappear_actions", field = disappearActions)
        json.writeField(key = "doubletap_actions", field = doubletapActions)
        json.writeField(key = "extensions", field = extensions)
        json.writeField(key = "focus", field = focus)
        json.writeFieldWithExpression(key = "gif_url", field = gifUrl, converter = URI_TO_STRING)
        json.writeField(key = "height", field = height)
        json.writeField(key = "id", field = id)
        json.writeField(key = "longtap_actions", field = longtapActions)
        json.writeField(key = "margins", field = margins)
        json.writeField(key = "paddings", field = paddings)
        json.writeFieldWithExpression(key = "placeholder_color", field = placeholderColor, converter = COLOR_INT_TO_STRING)
        json.writeFieldWithExpression(key = "preload_required", field = preloadRequired)
        json.writeFieldWithExpression(key = "preview", field = preview)
        json.writeFieldWithExpression(key = "row_span", field = rowSpan)
        json.writeFieldWithExpression(key = "scale", field = scale, converter = { v: DivImageScale -> DivImageScale.toString(v) })
        json.writeField(key = "selected_actions", field = selectedActions)
        json.writeField(key = "tooltips", field = tooltips)
        json.writeField(key = "transform", field = transform)
        json.writeField(key = "transition_change", field = transitionChange)
        json.writeField(key = "transition_in", field = transitionIn)
        json.writeField(key = "transition_out", field = transitionOut)
        json.writeField(key = "transition_triggers", field = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeFieldWithExpression(key = "visibility", field = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.writeField(key = "visibility_action", field = visibilityAction)
        json.writeField(key = "visibility_actions", field = visibilityActions)
        json.writeField(key = "width", field = width)
        return json
    }

    companion object {
        const val TYPE = "gif"

        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.CENTER)
        private val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val PLACEHOLDER_COLOR_DEFAULT_VALUE = Expression.constant(0x14000000.toInt())
        private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        private val SCALE_DEFAULT_VALUE = Expression.constant(DivImageScale.FILL)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_SCALE = TypeHelper.from(default = DivImageScale.values().first()) { it is DivImageScale }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val TRANSITION_TRIGGERS_TEMPLATE_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val ACCESSIBILITY_READER: Reader<DivAccessibility?> = { key, json, env -> JsonParser.readOptional(json, key, DivAccessibility.CREATOR, env.logger, env) }
        val ACTION_READER: Reader<DivAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivAction.CREATOR, env.logger, env) }
        val ACTION_ANIMATION_READER: Reader<DivAnimation> = { key, json, env -> JsonParser.readOptional(json, key, DivAnimation.CREATOR, env.logger, env) ?: ACTION_ANIMATION_DEFAULT_VALUE }
        val ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL) }
        val ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL) }
        val ALPHA_READER: Reader<Expression<Double>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, env.logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE }
        val ASPECT_READER: Reader<DivAspect?> = { key, json, env -> JsonParser.readOptional(json, key, DivAspect.CREATOR, env.logger, env) }
        val BACKGROUND_READER: Reader<List<DivBackground>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivBackground.CREATOR, env.logger, env) }
        val BORDER_READER: Reader<DivBorder?> = { key, json, env -> JsonParser.readOptional(json, key, DivBorder.CREATOR, env.logger, env) }
        val COLUMN_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val CONTENT_ALIGNMENT_HORIZONTAL_READER: Reader<Expression<DivAlignmentHorizontal>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentHorizontal.Converter.FROM_STRING, env.logger, env, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE }
        val CONTENT_ALIGNMENT_VERTICAL_READER: Reader<Expression<DivAlignmentVertical>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivAlignmentVertical.Converter.FROM_STRING, env.logger, env, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE }
        val DISAPPEAR_ACTIONS_READER: Reader<List<DivDisappearAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivDisappearAction.CREATOR, env.logger, env) }
        val DOUBLETAP_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val EXTENSIONS_READER: Reader<List<DivExtension>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivExtension.CREATOR, env.logger, env) }
        val FOCUS_READER: Reader<DivFocus?> = { key, json, env -> JsonParser.readOptional(json, key, DivFocus.CREATOR, env.logger, env) }
        val GIF_URL_READER: Reader<Expression<Uri>> = { key, json, env -> JsonParser.readExpression(json, key, STRING_TO_URI, env.logger, env, TYPE_HELPER_URI) }
        val HEIGHT_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: HEIGHT_DEFAULT_VALUE }
        val ID_READER: Reader<String?> = { key, json, env -> JsonParser.readOptional(json, key, env.logger, env) }
        val LONGTAP_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val MARGINS_READER: Reader<DivEdgeInsets?> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) }
        val PADDINGS_READER: Reader<DivEdgeInsets?> = { key, json, env -> JsonParser.readOptional(json, key, DivEdgeInsets.CREATOR, env.logger, env) }
        val PLACEHOLDER_COLOR_READER: Reader<Expression<Int>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, STRING_TO_COLOR_INT, env.logger, env, PLACEHOLDER_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: PLACEHOLDER_COLOR_DEFAULT_VALUE }
        val PRELOAD_REQUIRED_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, PRELOAD_REQUIRED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: PRELOAD_REQUIRED_DEFAULT_VALUE }
        val PREVIEW_READER: Reader<Expression<String>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, env.logger, env, TYPE_HELPER_STRING) }
        val ROW_SPAN_READER: Reader<Expression<Long>?> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, ROW_SPAN_VALIDATOR, env.logger, env, TYPE_HELPER_INT) }
        val SCALE_READER: Reader<Expression<DivImageScale>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivImageScale.Converter.FROM_STRING, env.logger, env, SCALE_DEFAULT_VALUE, TYPE_HELPER_SCALE) ?: SCALE_DEFAULT_VALUE }
        val SELECTED_ACTIONS_READER: Reader<List<DivAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivAction.CREATOR, env.logger, env) }
        val TOOLTIPS_READER: Reader<List<DivTooltip>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTooltip.CREATOR, env.logger, env) }
        val TRANSFORM_READER: Reader<DivTransform?> = { key, json, env -> JsonParser.readOptional(json, key, DivTransform.CREATOR, env.logger, env) }
        val TRANSITION_CHANGE_READER: Reader<DivChangeTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivChangeTransition.CREATOR, env.logger, env) }
        val TRANSITION_IN_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_OUT_READER: Reader<DivAppearanceTransition?> = { key, json, env -> JsonParser.readOptional(json, key, DivAppearanceTransition.CREATOR, env.logger, env) }
        val TRANSITION_TRIGGERS_READER: Reader<List<DivTransitionTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, env.logger, env) }
        val TYPE_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val VISIBILITY_READER: Reader<Expression<DivVisibility>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivVisibility.Converter.FROM_STRING, env.logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE }
        val VISIBILITY_ACTION_READER: Reader<DivVisibilityAction?> = { key, json, env -> JsonParser.readOptional(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val VISIBILITY_ACTIONS_READER: Reader<List<DivVisibilityAction>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVisibilityAction.CREATOR, env.logger, env) }
        val WIDTH_READER: Reader<DivSize> = { key, json, env -> JsonParser.readOptional(json, key, DivSize.CREATOR, env.logger, env) ?: WIDTH_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivGifImageTemplate(env, json = it) }
    }

}
