// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivInput @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    @JvmField final val fontFamily: Expression<String>? = null,
    @JvmField final val fontSize: Expression<Long> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
    @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
    @JvmField final val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val highlightColor: Expression<Int>? = null,
    @JvmField final val hintColor: Expression<Int> = HINT_COLOR_DEFAULT_VALUE, // default value: #73000000
    @JvmField final val hintText: Expression<String>? = null,
    override val id: String? = null,
    @JvmField final val keyboardType: Expression<KeyboardType> = KEYBOARD_TYPE_DEFAULT_VALUE, // default value: multi_line_text
    @JvmField final val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
    @JvmField final val lineHeight: Expression<Long>? = null, // constraint: number >= 0
    override val margins: DivEdgeInsets? = null,
    @JvmField final val mask: DivInputMask? = null,
    @JvmField final val maxVisibleLines: Expression<Long>? = null, // constraint: number > 0
    @JvmField final val nativeInterface: NativeInterface? = null,
    override val paddings: DivEdgeInsets? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val selectAllOnFocus: Expression<Boolean> = SELECT_ALL_ON_FOCUS_DEFAULT_VALUE, // default value: false
    override val selectedActions: List<DivAction>? = null,
    @JvmField final val textAlignmentHorizontal: Expression<DivAlignmentHorizontal> = TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: start
    @JvmField final val textAlignmentVertical: Expression<DivAlignmentVertical> = TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: center
    @JvmField final val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    @JvmField final val textVariable: String,
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    @JvmField final val validators: List<DivInputValidator>? = null,
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            (fontFamily?.hashCode() ?: 0) +
            fontSize.hashCode() +
            fontSizeUnit.hashCode() +
            fontWeight.hashCode() +
            height.hash() +
            (highlightColor?.hashCode() ?: 0) +
            hintColor.hashCode() +
            (hintText?.hashCode() ?: 0) +
            (id?.hashCode() ?: 0) +
            keyboardType.hashCode() +
            letterSpacing.hashCode() +
            (lineHeight?.hashCode() ?: 0) +
            (margins?.hash() ?: 0) +
            (mask?.hash() ?: 0) +
            (maxVisibleLines?.hashCode() ?: 0) +
            (nativeInterface?.hash() ?: 0) +
            (paddings?.hash() ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            selectAllOnFocus.hashCode() +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            textAlignmentHorizontal.hashCode() +
            textAlignmentVertical.hashCode() +
            textColor.hashCode() +
            textVariable.hashCode() +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            (validators?.sumOf { it.hash() } ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.writeExpression(key = "font_family", value = fontFamily)
        json.writeExpression(key = "font_size", value = fontSize)
        json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
        json.write(key = "height", value = height)
        json.writeExpression(key = "highlight_color", value = highlightColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "hint_color", value = hintColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "hint_text", value = hintText)
        json.write(key = "id", value = id)
        json.writeExpression(key = "keyboard_type", value = keyboardType, converter = { v: KeyboardType -> KeyboardType.toString(v) })
        json.writeExpression(key = "letter_spacing", value = letterSpacing)
        json.writeExpression(key = "line_height", value = lineHeight)
        json.write(key = "margins", value = margins)
        json.write(key = "mask", value = mask)
        json.writeExpression(key = "max_visible_lines", value = maxVisibleLines)
        json.write(key = "native_interface", value = nativeInterface)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.writeExpression(key = "select_all_on_focus", value = selectAllOnFocus)
        json.write(key = "selected_actions", value = selectedActions)
        json.writeExpression(key = "text_alignment_horizontal", value = textAlignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "text_alignment_vertical", value = textAlignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "text_color", value = textColor, converter = COLOR_INT_TO_STRING)
        json.write(key = "text_variable", value = textVariable)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.write(key = "validators", value = validators)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "input"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        private val KEYBOARD_TYPE_DEFAULT_VALUE = Expression.constant(KeyboardType.MULTI_LINE_TEXT)
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val SELECT_ALL_ON_FOCUS_DEFAULT_VALUE = Expression.constant(false)
        private val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        private val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        private val TYPE_HELPER_KEYBOARD_TYPE = TypeHelper.from(default = DivInput.KeyboardType.values().first()) { it is DivInput.KeyboardType }
        private val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivInput {
            val logger = env.logger
            return DivInput(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                fontFamily = JsonParser.readOptionalExpression(json, "font_family", logger, env, TYPE_HELPER_STRING),
                fontSize = JsonParser.readOptionalExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE,
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                highlightColor = JsonParser.readOptionalExpression(json, "highlight_color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                hintColor = JsonParser.readOptionalExpression(json, "hint_color", STRING_TO_COLOR_INT, logger, env, HINT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonParser.readOptionalExpression(json, "hint_text", logger, env, TYPE_HELPER_STRING),
                id = JsonParser.readOptional(json, "id", logger, env),
                keyboardType = JsonParser.readOptionalExpression(json, "keyboard_type", KeyboardType.Converter.FROM_STRING, logger, env, KEYBOARD_TYPE_DEFAULT_VALUE, TYPE_HELPER_KEYBOARD_TYPE) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
                letterSpacing = JsonParser.readOptionalExpression(json, "letter_spacing", NUMBER_TO_DOUBLE, logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonParser.readOptionalExpression(json, "line_height", NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                mask = JsonParser.readOptional(json, "mask", DivInputMask.CREATOR, logger, env),
                maxVisibleLines = JsonParser.readOptionalExpression(json, "max_visible_lines", NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR, logger, env, TYPE_HELPER_INT),
                nativeInterface = JsonParser.readOptional(json, "native_interface", NativeInterface.CREATOR, logger, env),
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectAllOnFocus = JsonParser.readOptionalExpression(json, "select_all_on_focus", ANY_TO_BOOLEAN, logger, env, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                textAlignmentHorizontal = JsonParser.readOptionalExpression(json, "text_alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonParser.readOptionalExpression(json, "text_alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonParser.readOptionalExpression(json, "text_color", STRING_TO_COLOR_INT, logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE,
                textVariable = JsonParser.read(json, "text_variable", logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                validators = JsonParser.readOptionalList(json, "validators", DivInputValidator.CREATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val MAX_VISIBLE_LINES_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val MAX_VISIBLE_LINES_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivInput(env, json = it) }
    }


    @Mockable
    class NativeInterface @DivModelInternalApi constructor (
        @JvmField final val color: Expression<Int>,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                color.hashCode()
            _hash = hash
            return hash
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "color", value = color, converter = COLOR_INT_TO_STRING)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): NativeInterface {
                val logger = env.logger
                return NativeInterface(
                    color = JsonParser.readExpression(json, "color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> NativeInterface(env, json = it) }
        }

    }

    enum class KeyboardType(private val value: String) {
        SINGLE_LINE_TEXT("single_line_text"),
        MULTI_LINE_TEXT("multi_line_text"),
        PHONE("phone"),
        NUMBER("number"),
        EMAIL("email"),
        URI("uri");

        companion object Converter {
            fun toString(obj: KeyboardType): String {
                return obj.value
            }

            fun fromString(string: String): KeyboardType? {
                return when (string) {
                    SINGLE_LINE_TEXT.value -> SINGLE_LINE_TEXT
                    MULTI_LINE_TEXT.value -> MULTI_LINE_TEXT
                    PHONE.value -> PHONE
                    NUMBER.value -> NUMBER
                    EMAIL.value -> EMAIL
                    URI.value -> URI
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    SINGLE_LINE_TEXT.value -> SINGLE_LINE_TEXT
                    MULTI_LINE_TEXT.value -> MULTI_LINE_TEXT
                    PHONE.value -> PHONE
                    NUMBER.value -> NUMBER
                    EMAIL.value -> EMAIL
                    URI.value -> URI
                    else -> null
                }
            }
        }
    }
}
