// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivInputValidator : JSONSerializable, Hashable {
    class Regex(val value: DivInputValidatorRegex) : DivInputValidator()
    class Expression(val value: DivInputValidatorExpression) : DivInputValidator()

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        return when(this) {
            is Regex -> 31 + this.value.hash()
            is Expression -> 62 + this.value.hash()
        }.also {
            _hash = it
        }
    }

    fun value(): Any {
        return when (this) {
            is Regex -> value
            is Expression -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Regex -> value.writeToJSON()
            is Expression -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivInputValidator {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivInputValidatorRegex.TYPE -> return Regex(DivInputValidatorRegex(env, json))
                DivInputValidatorExpression.TYPE -> return Expression(DivInputValidatorExpression(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivInputValidatorTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivInputValidator(env, json = it) }
    }
}
