// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivSelect @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    @JvmField final val fontFamily: Expression<String>? = null,
    @JvmField final val fontSize: Expression<Long> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
    @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
    @JvmField final val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField final val hintColor: Expression<Int> = HINT_COLOR_DEFAULT_VALUE, // default value: #73000000
    @JvmField final val hintText: Expression<String>? = null,
    override val id: String? = null,
    @JvmField final val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
    @JvmField final val lineHeight: Expression<Long>? = null, // constraint: number >= 0
    override val margins: DivEdgeInsets? = null,
    @JvmField final val options: List<Option>, // at least 1 elements
    override val paddings: DivEdgeInsets? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    override val selectedActions: List<DivAction>? = null,
    @JvmField final val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    @JvmField final val valueVariable: String,
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            (fontFamily?.hashCode() ?: 0) +
            fontSize.hashCode() +
            fontSizeUnit.hashCode() +
            fontWeight.hashCode() +
            height.hash() +
            hintColor.hashCode() +
            (hintText?.hashCode() ?: 0) +
            (id?.hashCode() ?: 0) +
            letterSpacing.hashCode() +
            (lineHeight?.hashCode() ?: 0) +
            (margins?.hash() ?: 0) +
            options.sumOf { it.hash() } +
            (paddings?.hash() ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            textColor.hashCode() +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            valueVariable.hashCode() +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.writeExpression(key = "font_family", value = fontFamily)
        json.writeExpression(key = "font_size", value = fontSize)
        json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
        json.write(key = "height", value = height)
        json.writeExpression(key = "hint_color", value = hintColor, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "hint_text", value = hintText)
        json.write(key = "id", value = id)
        json.writeExpression(key = "letter_spacing", value = letterSpacing)
        json.writeExpression(key = "line_height", value = lineHeight)
        json.write(key = "margins", value = margins)
        json.write(key = "options", value = options)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "selected_actions", value = selectedActions)
        json.writeExpression(key = "text_color", value = textColor, converter = COLOR_INT_TO_STRING)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.write(key = "value_variable", value = valueVariable)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "select"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivSelect {
            val logger = env.logger
            return DivSelect(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                fontFamily = JsonParser.readOptionalExpression(json, "font_family", logger, env, TYPE_HELPER_STRING),
                fontSize = JsonParser.readOptionalExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE,
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                hintColor = JsonParser.readOptionalExpression(json, "hint_color", STRING_TO_COLOR_INT, logger, env, HINT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonParser.readOptionalExpression(json, "hint_text", logger, env, TYPE_HELPER_STRING),
                id = JsonParser.readOptional(json, "id", logger, env),
                letterSpacing = JsonParser.readOptionalExpression(json, "letter_spacing", NUMBER_TO_DOUBLE, logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonParser.readOptionalExpression(json, "line_height", NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                options = JsonParser.readList(json, "options", Option.CREATOR, OPTIONS_VALIDATOR, logger, env),
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                textColor = JsonParser.readOptionalExpression(json, "text_color", STRING_TO_COLOR_INT, logger, env, TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: TEXT_COLOR_DEFAULT_VALUE,
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                valueVariable = JsonParser.read(json, "value_variable", logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val FONT_SIZE_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LINE_HEIGHT_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val OPTIONS_VALIDATOR = ListValidator<DivSelect.Option> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivSelect(env, json = it) }
    }


    @Mockable
    class Option @DivModelInternalApi constructor (
        @JvmField final val text: Expression<String>? = null,
        @JvmField final val value: Expression<String>,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                (text?.hashCode() ?: 0) +
                value.hashCode()
            _hash = hash
            return hash
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "text", value = text)
            json.writeExpression(key = "value", value = value)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Option {
                val logger = env.logger
                return Option(
                    text = JsonParser.readOptionalExpression(json, "text", logger, env, TYPE_HELPER_STRING),
                    value = JsonParser.readExpression(json, "value", logger, env, TYPE_HELPER_STRING)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Option(env, json = it) }
        }

    }
}
