// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivShapeDrawable @DivModelInternalApi constructor (
    @JvmField final val color: Expression<Int>,
    @JvmField final val shape: DivShape,
    @JvmField final val stroke: DivStroke? = null,
) : JSONSerializable, Hashable {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            color.hashCode() +
            shape.hash() +
            (stroke?.hash() ?: 0)
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "color", value = color, converter = COLOR_INT_TO_STRING)
        json.write(key = "shape", value = shape)
        json.write(key = "stroke", value = stroke)
        json.write(key = "type", value = TYPE)
        return json
    }

    companion object {
        const val TYPE = "shape_drawable"

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivShapeDrawable {
            val logger = env.logger
            return DivShapeDrawable(
                color = JsonParser.readExpression(json, "color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                shape = JsonParser.read(json, "shape", DivShape.CREATOR, logger, env),
                stroke = JsonParser.readOptional(json, "stroke", DivStroke.CREATOR, logger, env)
            )
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivShapeDrawable(env, json = it) }
    }

}
