// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivTooltipTemplate : JSONSerializable, JsonTemplate<DivTooltip> {
    @JvmField final val animationIn: Field<DivAnimationTemplate>
    @JvmField final val animationOut: Field<DivAnimationTemplate>
    @JvmField final val div: Field<DivTemplate>
    @JvmField final val duration: Field<Expression<Long>> // constraint: number >= 0; default value: 5000
    @JvmField final val id: Field<String>
    @JvmField final val offset: Field<DivPointTemplate>
    @JvmField final val position: Field<Expression<DivTooltip.Position>>

    constructor (
        env: ParsingEnvironment,
        parent: DivTooltipTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        animationIn = JsonTemplateParser.readOptionalField(json, "animation_in", topLevel, parent?.animationIn, DivAnimationTemplate.CREATOR, logger, env)
        animationOut = JsonTemplateParser.readOptionalField(json, "animation_out", topLevel, parent?.animationOut, DivAnimationTemplate.CREATOR, logger, env)
        div = JsonTemplateParser.readField(json, "div", topLevel, parent?.div, DivTemplate.CREATOR, logger, env)
        duration = JsonTemplateParser.readOptionalFieldWithExpression(json, "duration", topLevel, parent?.duration, NUMBER_TO_INT, DURATION_TEMPLATE_VALIDATOR, logger, env, TYPE_HELPER_INT)
        id = JsonTemplateParser.readField(json, "id", topLevel, parent?.id, logger, env)
        offset = JsonTemplateParser.readOptionalField(json, "offset", topLevel, parent?.offset, DivPointTemplate.CREATOR, logger, env)
        position = JsonTemplateParser.readFieldWithExpression(json, "position", topLevel, parent?.position, DivTooltip.Position.Converter.FROM_STRING, logger, env, TYPE_HELPER_POSITION)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivTooltip {
        return DivTooltip(
            animationIn = animationIn.resolveOptionalTemplate(env = env, key = "animation_in", data = rawData, reader = ANIMATION_IN_READER),
            animationOut = animationOut.resolveOptionalTemplate(env = env, key = "animation_out", data = rawData, reader = ANIMATION_OUT_READER),
            div = div.resolveTemplate(env = env, key = "div", data = rawData, reader = DIV_READER),
            duration = duration.resolveOptional(env = env, key = "duration", data = rawData, reader = DURATION_READER) ?: DURATION_DEFAULT_VALUE,
            id = id.resolve(env = env, key = "id", data = rawData, reader = ID_READER),
            offset = offset.resolveOptionalTemplate(env = env, key = "offset", data = rawData, reader = OFFSET_READER),
            position = position.resolve(env = env, key = "position", data = rawData, reader = POSITION_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "animation_in", field = animationIn)
        json.writeField(key = "animation_out", field = animationOut)
        json.writeField(key = "div", field = div)
        json.writeFieldWithExpression(key = "duration", field = duration)
        json.writeField(key = "id", field = id)
        json.writeField(key = "offset", field = offset)
        json.writeFieldWithExpression(key = "position", field = position, converter = { v: DivTooltip.Position -> DivTooltip.Position.toString(v) })
        return json
    }

    companion object {
        private val DURATION_DEFAULT_VALUE = Expression.constant(5000L)

        private val TYPE_HELPER_POSITION = TypeHelper.from(default = DivTooltip.Position.values().first()) { it is DivTooltip.Position }

        private val DURATION_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

        val ANIMATION_IN_READER: Reader<DivAnimation?> = { key, json, env -> JsonParser.readOptional(json, key, DivAnimation.CREATOR, env.logger, env) }
        val ANIMATION_OUT_READER: Reader<DivAnimation?> = { key, json, env -> JsonParser.readOptional(json, key, DivAnimation.CREATOR, env.logger, env) }
        val DIV_READER: Reader<Div> = { key, json, env -> JsonParser.read(json, key, Div.CREATOR, env.logger, env) }
        val DURATION_READER: Reader<Expression<Long>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, NUMBER_TO_INT, DURATION_VALIDATOR, env.logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE }
        val ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val OFFSET_READER: Reader<DivPoint?> = { key, json, env -> JsonParser.readOptional(json, key, DivPoint.CREATOR, env.logger, env) }
        val POSITION_READER: Reader<Expression<DivTooltip.Position>> = { key, json, env -> JsonParser.readExpression(json, key, DivTooltip.Position.Converter.FROM_STRING, env.logger, env, TYPE_HELPER_POSITION) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTooltipTemplate(env, json = it) }
    }

}
