// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivTriggerTemplate : JSONSerializable, JsonTemplate<DivTrigger> {
    @JvmField final val actions: Field<List<DivActionTemplate>> // at least 1 elements
    @JvmField final val condition: Field<Expression<Boolean>>
    @JvmField final val mode: Field<Expression<DivTrigger.Mode>> // default value: on_condition

    constructor (
        env: ParsingEnvironment,
        parent: DivTriggerTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        actions = JsonTemplateParser.readListField(json, "actions", topLevel, parent?.actions, DivActionTemplate.CREATOR, ACTIONS_TEMPLATE_VALIDATOR, logger, env)
        condition = JsonTemplateParser.readFieldWithExpression(json, "condition", topLevel, parent?.condition, ANY_TO_BOOLEAN, logger, env, TYPE_HELPER_BOOLEAN)
        mode = JsonTemplateParser.readOptionalFieldWithExpression(json, "mode", topLevel, parent?.mode, DivTrigger.Mode.Converter.FROM_STRING, logger, env, TYPE_HELPER_MODE)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivTrigger {
        return DivTrigger(
            actions = actions.resolveTemplateList(env = env, key = "actions", data = rawData, ACTIONS_VALIDATOR, reader = ACTIONS_READER),
            condition = condition.resolve(env = env, key = "condition", data = rawData, reader = CONDITION_READER),
            mode = mode.resolveOptional(env = env, key = "mode", data = rawData, reader = MODE_READER) ?: MODE_DEFAULT_VALUE
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "actions", field = actions)
        json.writeFieldWithExpression(key = "condition", field = condition)
        json.writeFieldWithExpression(key = "mode", field = mode, converter = { v: DivTrigger.Mode -> DivTrigger.Mode.toString(v) })
        return json
    }

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(DivTrigger.Mode.ON_CONDITION)

        private val TYPE_HELPER_MODE = TypeHelper.from(default = DivTrigger.Mode.values().first()) { it is DivTrigger.Mode }

        private val ACTIONS_VALIDATOR = ListValidator<DivAction> { it: List<*> -> it.size >= 1 }
        private val ACTIONS_TEMPLATE_VALIDATOR = ListValidator<DivActionTemplate> { it: List<*> -> it.size >= 1 }

        val ACTIONS_READER: Reader<List<DivAction>> = { key, json, env -> JsonParser.readList(json, key, DivAction.CREATOR, ACTIONS_VALIDATOR, env.logger, env) }
        val CONDITION_READER: Reader<Expression<Boolean>> = { key, json, env -> JsonParser.readExpression(json, key, ANY_TO_BOOLEAN, env.logger, env, TYPE_HELPER_BOOLEAN) }
        val MODE_READER: Reader<Expression<DivTrigger.Mode>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivTrigger.Mode.Converter.FROM_STRING, env.logger, env, MODE_DEFAULT_VALUE, TYPE_HELPER_MODE) ?: MODE_DEFAULT_VALUE }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTriggerTemplate(env, json = it) }
    }

}
