// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivVideo @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField final val aspect: DivAspect? = null,
    @JvmField final val autostart: Expression<Boolean> = AUTOSTART_DEFAULT_VALUE, // default value: false
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    @JvmField final val bufferingActions: List<DivAction>? = null,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    @JvmField final val elapsedTimeVariable: String? = null,
    @JvmField final val endActions: List<DivAction>? = null,
    override val extensions: List<DivExtension>? = null,
    @JvmField final val fatalActions: List<DivAction>? = null,
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null,
    override val margins: DivEdgeInsets? = null,
    @JvmField final val muted: Expression<Boolean> = MUTED_DEFAULT_VALUE, // default value: false
    override val paddings: DivEdgeInsets? = null,
    @JvmField final val pauseActions: List<DivAction>? = null,
    @JvmField final val playerSettingsPayload: JSONObject? = null,
    @JvmField final val preloadRequired: Expression<Boolean> = PRELOAD_REQUIRED_DEFAULT_VALUE, // default value: false
    @JvmField final val preview: Expression<String>? = null,
    @JvmField final val repeatable: Expression<Boolean> = REPEATABLE_DEFAULT_VALUE, // default value: false
    @JvmField final val resumeActions: List<DivAction>? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val scale: Expression<DivVideoScale> = SCALE_DEFAULT_VALUE, // default value: fit
    override val selectedActions: List<DivAction>? = null,
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    @JvmField final val videoSources: List<DivVideoSource>, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (aspect?.hash() ?: 0) +
            autostart.hashCode() +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (bufferingActions?.sumOf { it.hash() } ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (elapsedTimeVariable?.hashCode() ?: 0) +
            (endActions?.sumOf { it.hash() } ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (fatalActions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            height.hash() +
            (id?.hashCode() ?: 0) +
            (margins?.hash() ?: 0) +
            muted.hashCode() +
            (paddings?.hash() ?: 0) +
            (pauseActions?.sumOf { it.hash() } ?: 0) +
            (playerSettingsPayload?.hashCode() ?: 0) +
            preloadRequired.hashCode() +
            (preview?.hashCode() ?: 0) +
            repeatable.hashCode() +
            (resumeActions?.sumOf { it.hash() } ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            scale.hashCode() +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            videoSources.sumOf { it.hash() } +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "aspect", value = aspect)
        json.writeExpression(key = "autostart", value = autostart)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.write(key = "buffering_actions", value = bufferingActions)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "elapsed_time_variable", value = elapsedTimeVariable)
        json.write(key = "end_actions", value = endActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "fatal_actions", value = fatalActions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "muted", value = muted)
        json.write(key = "paddings", value = paddings)
        json.write(key = "pause_actions", value = pauseActions)
        json.write(key = "player_settings_payload", value = playerSettingsPayload)
        json.writeExpression(key = "preload_required", value = preloadRequired)
        json.writeExpression(key = "preview", value = preview)
        json.writeExpression(key = "repeatable", value = repeatable)
        json.write(key = "resume_actions", value = resumeActions)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.writeExpression(key = "scale", value = scale, converter = { v: DivVideoScale -> DivVideoScale.toString(v) })
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.write(key = "video_sources", value = videoSources)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    companion object {
        const val TYPE = "video"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val AUTOSTART_DEFAULT_VALUE = Expression.constant(false)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val MUTED_DEFAULT_VALUE = Expression.constant(false)
        private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        private val REPEATABLE_DEFAULT_VALUE = Expression.constant(false)
        private val SCALE_DEFAULT_VALUE = Expression.constant(DivVideoScale.FIT)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_SCALE = TypeHelper.from(default = DivVideoScale.values().first()) { it is DivVideoScale }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivVideo {
            val logger = env.logger
            return DivVideo(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                aspect = JsonParser.readOptional(json, "aspect", DivAspect.CREATOR, logger, env),
                autostart = JsonParser.readOptionalExpression(json, "autostart", ANY_TO_BOOLEAN, logger, env, AUTOSTART_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: AUTOSTART_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                bufferingActions = JsonParser.readOptionalList(json, "buffering_actions", DivAction.CREATOR, logger, env),
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                elapsedTimeVariable = JsonParser.readOptional(json, "elapsed_time_variable", logger, env),
                endActions = JsonParser.readOptionalList(json, "end_actions", DivAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                fatalActions = JsonParser.readOptionalList(json, "fatal_actions", DivAction.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                muted = JsonParser.readOptionalExpression(json, "muted", ANY_TO_BOOLEAN, logger, env, MUTED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: MUTED_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                pauseActions = JsonParser.readOptionalList(json, "pause_actions", DivAction.CREATOR, logger, env),
                playerSettingsPayload = JsonParser.readOptional(json, "player_settings_payload", logger, env),
                preloadRequired = JsonParser.readOptionalExpression(json, "preload_required", ANY_TO_BOOLEAN, logger, env, PRELOAD_REQUIRED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                preview = JsonParser.readOptionalExpression(json, "preview", logger, env, TYPE_HELPER_STRING),
                repeatable = JsonParser.readOptionalExpression(json, "repeatable", ANY_TO_BOOLEAN, logger, env, REPEATABLE_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: REPEATABLE_DEFAULT_VALUE,
                resumeActions = JsonParser.readOptionalList(json, "resume_actions", DivAction.CREATOR, logger, env),
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                scale = JsonParser.readOptionalExpression(json, "scale", DivVideoScale.Converter.FROM_STRING, logger, env, SCALE_DEFAULT_VALUE, TYPE_HELPER_SCALE) ?: SCALE_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                videoSources = JsonParser.readList(json, "video_sources", DivVideoSource.CREATOR, VIDEO_SOURCES_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_TEMPLATE_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_TEMPLATE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
        private val VIDEO_SOURCES_VALIDATOR = ListValidator<DivVideoSource> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVideo(env, json = it) }
    }

}
