// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivActionTyped : JSONSerializable, Hashable {
    class ArrayInsertValue(val value: DivActionArrayInsertValue) : DivActionTyped()
    class ArrayRemoveValue(val value: DivActionArrayRemoveValue) : DivActionTyped()
    class SetVariable(val value: DivActionSetVariable) : DivActionTyped()
    class FocusElement(val value: DivActionFocusElement) : DivActionTyped()
    class CopyToClipboard(val value: DivActionCopyToClipboard) : DivActionTyped()

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        return when(this) {
            is ArrayInsertValue -> 31 + this.value.hash()
            is ArrayRemoveValue -> 62 + this.value.hash()
            is SetVariable -> 93 + this.value.hash()
            is FocusElement -> 124 + this.value.hash()
            is CopyToClipboard -> 155 + this.value.hash()
        }.also {
            _hash = it
        }
    }

    fun value(): Any {
        return when (this) {
            is ArrayInsertValue -> value
            is ArrayRemoveValue -> value
            is SetVariable -> value
            is FocusElement -> value
            is CopyToClipboard -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is ArrayInsertValue -> value.writeToJSON()
            is ArrayRemoveValue -> value.writeToJSON()
            is SetVariable -> value.writeToJSON()
            is FocusElement -> value.writeToJSON()
            is CopyToClipboard -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivActionTyped {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                DivActionArrayInsertValue.TYPE -> return ArrayInsertValue(DivActionArrayInsertValue(env, json))
                DivActionArrayRemoveValue.TYPE -> return ArrayRemoveValue(DivActionArrayRemoveValue(env, json))
                DivActionSetVariable.TYPE -> return SetVariable(DivActionSetVariable(env, json))
                DivActionFocusElement.TYPE -> return FocusElement(DivActionFocusElement(env, json))
                DivActionCopyToClipboard.TYPE -> return CopyToClipboard(DivActionCopyToClipboard(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivActionTypedTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivActionTyped(env, json = it) }
    }
}
