// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivDataTemplate : JSONSerializable, JsonTemplate<DivData> {
    @JvmField final val logId: Field<String>
    @JvmField final val states: Field<List<StateTemplate>> // at least 1 elements
    @JvmField final val timers: Field<List<DivTimerTemplate>>
    @JvmField final val transitionAnimationSelector: Field<Expression<DivTransitionSelector>> // default value: none
    @JvmField final val variableTriggers: Field<List<DivTriggerTemplate>>
    @JvmField final val variables: Field<List<DivVariableTemplate>>

    constructor (
        env: ParsingEnvironment,
        parent: DivDataTemplate? = null,
        topLevel: Boolean = false,
        json: JSONObject
    ) {
        val logger = env.logger
        logId = JsonTemplateParser.readField(json, "log_id", topLevel, parent?.logId, logger, env)
        states = JsonTemplateParser.readListField(json, "states", topLevel, parent?.states, StateTemplate.CREATOR, STATES_TEMPLATE_VALIDATOR, logger, env)
        timers = JsonTemplateParser.readOptionalListField(json, "timers", topLevel, parent?.timers, DivTimerTemplate.CREATOR, logger, env)
        transitionAnimationSelector = JsonTemplateParser.readOptionalFieldWithExpression(json, "transition_animation_selector", topLevel, parent?.transitionAnimationSelector, DivTransitionSelector.Converter.FROM_STRING, logger, env, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR)
        variableTriggers = JsonTemplateParser.readOptionalListField(json, "variable_triggers", topLevel, parent?.variableTriggers, DivTriggerTemplate.CREATOR, logger, env)
        variables = JsonTemplateParser.readOptionalListField(json, "variables", topLevel, parent?.variables, DivVariableTemplate.CREATOR, logger, env)
    }

    override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivData {
        return DivData(
            logId = logId.resolve(env = env, key = "log_id", data = rawData, reader = LOG_ID_READER),
            states = states.resolveTemplateList(env = env, key = "states", data = rawData, STATES_VALIDATOR, reader = STATES_READER),
            timers = timers.resolveOptionalTemplateList(env = env, key = "timers", data = rawData, reader = TIMERS_READER),
            transitionAnimationSelector = transitionAnimationSelector.resolveOptional(env = env, key = "transition_animation_selector", data = rawData, reader = TRANSITION_ANIMATION_SELECTOR_READER) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
            variableTriggers = variableTriggers.resolveOptionalTemplateList(env = env, key = "variable_triggers", data = rawData, reader = VARIABLE_TRIGGERS_READER),
            variables = variables.resolveOptionalTemplateList(env = env, key = "variables", data = rawData, reader = VARIABLES_READER)
        )
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeField(key = "log_id", field = logId)
        json.writeField(key = "states", field = states)
        json.writeField(key = "timers", field = timers)
        json.writeFieldWithExpression(key = "transition_animation_selector", field = transitionAnimationSelector, converter = { v: DivTransitionSelector -> DivTransitionSelector.toString(v) })
        json.writeField(key = "variable_triggers", field = variableTriggers)
        json.writeField(key = "variables", field = variables)
        return json
    }

    companion object {
        private val TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE = Expression.constant(DivTransitionSelector.NONE)

        private val TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR = TypeHelper.from(default = DivTransitionSelector.values().first()) { it is DivTransitionSelector }

        private val STATES_VALIDATOR = ListValidator<DivData.State> { it: List<*> -> it.size >= 1 }
        private val STATES_TEMPLATE_VALIDATOR = ListValidator<DivDataTemplate.StateTemplate> { it: List<*> -> it.size >= 1 }

        val LOG_ID_READER: Reader<String> = { key, json, env -> JsonParser.read(json, key, env.logger, env) }
        val STATES_READER: Reader<List<DivData.State>> = { key, json, env -> JsonParser.readList(json, key, DivData.State.CREATOR, STATES_VALIDATOR, env.logger, env) }
        val TIMERS_READER: Reader<List<DivTimer>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTimer.CREATOR, env.logger, env) }
        val TRANSITION_ANIMATION_SELECTOR_READER: Reader<Expression<DivTransitionSelector>> = { key, json, env -> JsonParser.readOptionalExpression(json, key, DivTransitionSelector.Converter.FROM_STRING, env.logger, env, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE, TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE }
        val VARIABLE_TRIGGERS_READER: Reader<List<DivTrigger>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivTrigger.CREATOR, env.logger, env) }
        val VARIABLES_READER: Reader<List<DivVariable>?> = { key, json, env -> JsonParser.readOptionalList(json, key, DivVariable.CREATOR, env.logger, env) }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivDataTemplate(env, json = it) }
    }


    @Mockable
    class StateTemplate : JSONSerializable, JsonTemplate<DivData.State> {
        @JvmField final val div: Field<DivTemplate>
        @JvmField final val stateId: Field<Long>

        constructor (
            env: ParsingEnvironment,
            parent: StateTemplate? = null,
            topLevel: Boolean = false,
            json: JSONObject
        ) {
            val logger = env.logger
            div = JsonTemplateParser.readField(json, "div", topLevel, parent?.div, DivTemplate.CREATOR, logger, env)
            stateId = JsonTemplateParser.readField(json, "state_id", topLevel, parent?.stateId, NUMBER_TO_INT, logger, env)
        }

        override fun resolve(env: ParsingEnvironment, rawData: JSONObject): DivData.State {
            return DivData.State(
                div = div.resolveTemplate(env = env, key = "div", data = rawData, reader = DIV_READER),
                stateId = stateId.resolve(env = env, key = "state_id", data = rawData, reader = STATE_ID_READER)
            )
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeField(key = "div", field = div)
            json.writeField(key = "state_id", field = stateId)
            return json
        }

        companion object {
            val DIV_READER: Reader<Div> = { key, json, env -> JsonParser.read(json, key, Div.CREATOR, env.logger, env) }
            val STATE_ID_READER: Reader<Long> = { key, json, env -> JsonParser.read(json, key, NUMBER_TO_INT, env.logger, env) }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> StateTemplate(env, json = it) }
        }

    }
}
