// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivGallery @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    @JvmField final val columnCount: Expression<Long>? = null, // constraint: number > 0
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val crossContentAlignment: Expression<CrossContentAlignment> = CROSS_CONTENT_ALIGNMENT_DEFAULT_VALUE, // default value: start
    @JvmField final val crossSpacing: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val defaultItem: Expression<Long> = DEFAULT_ITEM_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
    override val disappearActions: List<DivDisappearAction>? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null,
    @JvmField final val itemSpacing: Expression<Long> = ITEM_SPACING_DEFAULT_VALUE, // constraint: number >= 0; default value: 8
    @JvmField final val items: List<Div>? = null,
    override val margins: DivEdgeInsets? = null,
    @JvmField final val orientation: Expression<Orientation> = ORIENTATION_DEFAULT_VALUE, // default value: horizontal
    override val paddings: DivEdgeInsets? = null,
    @JvmField final val restrictParentScroll: Expression<Boolean> = RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, // default value: false
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField final val scrollMode: Expression<ScrollMode> = SCROLL_MODE_DEFAULT_VALUE, // default value: default
    @JvmField final val scrollbar: Expression<Scrollbar> = SCROLLBAR_DEFAULT_VALUE, // default value: none
    override val selectedActions: List<DivAction>? = null,
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (columnCount?.hashCode() ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            crossContentAlignment.hashCode() +
            (crossSpacing?.hashCode() ?: 0) +
            defaultItem.hashCode() +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            height.hash() +
            (id?.hashCode() ?: 0) +
            itemSpacing.hashCode() +
            (items?.sumOf { it.hash() } ?: 0) +
            (margins?.hash() ?: 0) +
            orientation.hashCode() +
            (paddings?.hash() ?: 0) +
            restrictParentScroll.hashCode() +
            (rowSpan?.hashCode() ?: 0) +
            scrollMode.hashCode() +
            scrollbar.hashCode() +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_count", value = columnCount)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.writeExpression(key = "cross_content_alignment", value = crossContentAlignment, converter = { v: CrossContentAlignment -> CrossContentAlignment.toString(v) })
        json.writeExpression(key = "cross_spacing", value = crossSpacing)
        json.writeExpression(key = "default_item", value = defaultItem)
        json.write(key = "disappear_actions", value = disappearActions)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.writeExpression(key = "item_spacing", value = itemSpacing)
        json.write(key = "items", value = items)
        json.write(key = "margins", value = margins)
        json.writeExpression(key = "orientation", value = orientation, converter = { v: Orientation -> Orientation.toString(v) })
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "restrict_parent_scroll", value = restrictParentScroll)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.writeExpression(key = "scroll_mode", value = scrollMode, converter = { v: ScrollMode -> ScrollMode.toString(v) })
        json.writeExpression(key = "scrollbar", value = scrollbar, converter = { v: Scrollbar -> Scrollbar.toString(v) })
        json.write(key = "selected_actions", value = selectedActions)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    fun copyWithNewProperties(
        items: List<Div>,
    ) = DivGallery(
        accessibility,
        alignmentHorizontal,
        alignmentVertical,
        alpha,
        background,
        border,
        columnCount,
        columnSpan,
        crossContentAlignment,
        crossSpacing,
        defaultItem,
        disappearActions,
        extensions,
        focus,
        height,
        id,
        itemSpacing,
        items,
        margins,
        orientation,
        paddings,
        restrictParentScroll,
        rowSpan,
        scrollMode,
        scrollbar,
        selectedActions,
        tooltips,
        transform,
        transitionChange,
        transitionIn,
        transitionOut,
        transitionTriggers,
        visibility,
        visibilityAction,
        visibilityActions,
        width,
    )

    companion object {
        const val TYPE = "gallery"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CROSS_CONTENT_ALIGNMENT_DEFAULT_VALUE = Expression.constant(CrossContentAlignment.START)
        private val DEFAULT_ITEM_DEFAULT_VALUE = Expression.constant(0L)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val ITEM_SPACING_DEFAULT_VALUE = Expression.constant(8L)
        private val ORIENTATION_DEFAULT_VALUE = Expression.constant(Orientation.HORIZONTAL)
        private val RESTRICT_PARENT_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        private val SCROLL_MODE_DEFAULT_VALUE = Expression.constant(ScrollMode.DEFAULT)
        private val SCROLLBAR_DEFAULT_VALUE = Expression.constant(Scrollbar.NONE)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_CROSS_CONTENT_ALIGNMENT = TypeHelper.from(default = DivGallery.CrossContentAlignment.values().first()) { it is DivGallery.CrossContentAlignment }
        private val TYPE_HELPER_ORIENTATION = TypeHelper.from(default = DivGallery.Orientation.values().first()) { it is DivGallery.Orientation }
        private val TYPE_HELPER_SCROLL_MODE = TypeHelper.from(default = DivGallery.ScrollMode.values().first()) { it is DivGallery.ScrollMode }
        private val TYPE_HELPER_SCROLLBAR = TypeHelper.from(default = DivGallery.Scrollbar.values().first()) { it is DivGallery.Scrollbar }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivGallery {
            val logger = env.logger
            return DivGallery(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                columnCount = JsonParser.readOptionalExpression(json, "column_count", NUMBER_TO_INT, COLUMN_COUNT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                crossContentAlignment = JsonParser.readOptionalExpression(json, "cross_content_alignment", CrossContentAlignment.Converter.FROM_STRING, logger, env, CROSS_CONTENT_ALIGNMENT_DEFAULT_VALUE, TYPE_HELPER_CROSS_CONTENT_ALIGNMENT) ?: CROSS_CONTENT_ALIGNMENT_DEFAULT_VALUE,
                crossSpacing = JsonParser.readOptionalExpression(json, "cross_spacing", NUMBER_TO_INT, CROSS_SPACING_VALIDATOR, logger, env, TYPE_HELPER_INT),
                defaultItem = JsonParser.readOptionalExpression(json, "default_item", NUMBER_TO_INT, DEFAULT_ITEM_VALIDATOR, logger, env, DEFAULT_ITEM_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DEFAULT_ITEM_DEFAULT_VALUE,
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", logger, env),
                itemSpacing = JsonParser.readOptionalExpression(json, "item_spacing", NUMBER_TO_INT, ITEM_SPACING_VALIDATOR, logger, env, ITEM_SPACING_DEFAULT_VALUE, TYPE_HELPER_INT) ?: ITEM_SPACING_DEFAULT_VALUE,
                items = JsonParser.readOptionalList(json, "items", Div.CREATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                orientation = JsonParser.readOptionalExpression(json, "orientation", Orientation.Converter.FROM_STRING, logger, env, ORIENTATION_DEFAULT_VALUE, TYPE_HELPER_ORIENTATION) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                restrictParentScroll = JsonParser.readOptionalExpression(json, "restrict_parent_scroll", ANY_TO_BOOLEAN, logger, env, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                scrollMode = JsonParser.readOptionalExpression(json, "scroll_mode", ScrollMode.Converter.FROM_STRING, logger, env, SCROLL_MODE_DEFAULT_VALUE, TYPE_HELPER_SCROLL_MODE) ?: SCROLL_MODE_DEFAULT_VALUE,
                scrollbar = JsonParser.readOptionalExpression(json, "scrollbar", Scrollbar.Converter.FROM_STRING, logger, env, SCROLLBAR_DEFAULT_VALUE, TYPE_HELPER_SCROLLBAR) ?: SCROLLBAR_DEFAULT_VALUE,
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_COUNT_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val CROSS_SPACING_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val DEFAULT_ITEM_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ITEM_SPACING_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivGallery(env, json = it) }
    }


    enum class CrossContentAlignment(private val value: String) {
        START("start"),
        CENTER("center"),
        END("end");

        companion object Converter {
            fun toString(obj: CrossContentAlignment): String {
                return obj.value
            }

            fun fromString(string: String): CrossContentAlignment? {
                return when (string) {
                    START.value -> START
                    CENTER.value -> CENTER
                    END.value -> END
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    START.value -> START
                    CENTER.value -> CENTER
                    END.value -> END
                    else -> null
                }
            }
        }
    }

    enum class ScrollMode(private val value: String) {
        PAGING("paging"),
        DEFAULT("default");

        companion object Converter {
            fun toString(obj: ScrollMode): String {
                return obj.value
            }

            fun fromString(string: String): ScrollMode? {
                return when (string) {
                    PAGING.value -> PAGING
                    DEFAULT.value -> DEFAULT
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    PAGING.value -> PAGING
                    DEFAULT.value -> DEFAULT
                    else -> null
                }
            }
        }
    }

    enum class Orientation(private val value: String) {
        HORIZONTAL("horizontal"),
        VERTICAL("vertical");

        companion object Converter {
            fun toString(obj: Orientation): String {
                return obj.value
            }

            fun fromString(string: String): Orientation? {
                return when (string) {
                    HORIZONTAL.value -> HORIZONTAL
                    VERTICAL.value -> VERTICAL
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    HORIZONTAL.value -> HORIZONTAL
                    VERTICAL.value -> VERTICAL
                    else -> null
                }
            }
        }
    }

    enum class Scrollbar(private val value: String) {
        NONE("none"),
        AUTO("auto");

        companion object Converter {
            fun toString(obj: Scrollbar): String {
                return obj.value
            }

            fun fromString(string: String): Scrollbar? {
                return when (string) {
                    NONE.value -> NONE
                    AUTO.value -> AUTO
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    NONE.value -> NONE
                    AUTO.value -> AUTO
                    else -> null
                }
            }
        }
    }
}
