// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivStroke @DivModelInternalApi constructor (
    @JvmField final val color: Expression<Int>,
    @JvmField final val unit: Expression<DivSizeUnit> = UNIT_DEFAULT_VALUE, // default value: dp
    @JvmField final val width: Expression<Long> = WIDTH_DEFAULT_VALUE, // constraint: number >= 0; default value: 1
) : JSONSerializable, Hashable {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            color.hashCode() +
            unit.hashCode() +
            width.hashCode()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.writeExpression(key = "color", value = color, converter = COLOR_INT_TO_STRING)
        json.writeExpression(key = "unit", value = unit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
        json.writeExpression(key = "width", value = width)
        return json
    }

    companion object {
        private val UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.DP)
        private val WIDTH_DEFAULT_VALUE = Expression.constant(1L)

        private val TYPE_HELPER_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivStroke {
            val logger = env.logger
            return DivStroke(
                color = JsonParser.readExpression(json, "color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                unit = JsonParser.readOptionalExpression(json, "unit", DivSizeUnit.Converter.FROM_STRING, logger, env, UNIT_DEFAULT_VALUE, TYPE_HELPER_UNIT) ?: UNIT_DEFAULT_VALUE,
                width = JsonParser.readOptionalExpression(json, "width", NUMBER_TO_INT, WIDTH_VALIDATOR, logger, env, WIDTH_DEFAULT_VALUE, TYPE_HELPER_INT) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val WIDTH_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivStroke(env, json = it) }
    }

}
