// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivTabs @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    @JvmField final val dynamicHeight: Expression<Boolean> = DYNAMIC_HEIGHT_DEFAULT_VALUE, // default value: false
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    @JvmField final val hasSeparator: Expression<Boolean> = HAS_SEPARATOR_DEFAULT_VALUE, // default value: false
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    override val id: String? = null,
    @JvmField final val items: List<Item>, // at least 1 elements
    override val margins: DivEdgeInsets? = null,
    override val paddings: DivEdgeInsets? = null,
    @JvmField final val restrictParentScroll: Expression<Boolean> = RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, // default value: false
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    override val selectedActions: List<DivAction>? = null,
    @JvmField final val selectedTab: Expression<Long> = SELECTED_TAB_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
    @JvmField final val separatorColor: Expression<Int> = SEPARATOR_COLOR_DEFAULT_VALUE, // default value: #14000000
    @JvmField final val separatorPaddings: DivEdgeInsets = SEPARATOR_PADDINGS_DEFAULT_VALUE, // default value: DivEdgeInsets(bottom = Expression.constant(0L), left = Expression.constant(12L), right = Expression.constant(12L), top = Expression.constant(0L))
    @JvmField final val switchTabsByContentSwipeEnabled: Expression<Boolean> = SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE, // default value: true
    @JvmField final val tabTitleStyle: TabTitleStyle? = null,
    @JvmField final val titlePaddings: DivEdgeInsets = TITLE_PADDINGS_DEFAULT_VALUE, // default value: DivEdgeInsets(bottom = Expression.constant(8L), left = Expression.constant(12L), right = Expression.constant(12L), top = Expression.constant(0L))
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (accessibility?.hash() ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            dynamicHeight.hashCode() +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            hasSeparator.hashCode() +
            height.hash() +
            (id?.hashCode() ?: 0) +
            items.sumOf { it.hash() } +
            (margins?.hash() ?: 0) +
            (paddings?.hash() ?: 0) +
            restrictParentScroll.hashCode() +
            (rowSpan?.hashCode() ?: 0) +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            selectedTab.hashCode() +
            separatorColor.hashCode() +
            separatorPaddings.hash() +
            switchTabsByContentSwipeEnabled.hashCode() +
            (tabTitleStyle?.hash() ?: 0) +
            titlePaddings.hash() +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "accessibility", value = accessibility)
        json.writeExpression(key = "alignment_horizontal", value = alignmentHorizontal, converter = { v: DivAlignmentHorizontal -> DivAlignmentHorizontal.toString(v) })
        json.writeExpression(key = "alignment_vertical", value = alignmentVertical, converter = { v: DivAlignmentVertical -> DivAlignmentVertical.toString(v) })
        json.writeExpression(key = "alpha", value = alpha)
        json.write(key = "background", value = background)
        json.write(key = "border", value = border)
        json.writeExpression(key = "column_span", value = columnSpan)
        json.write(key = "disappear_actions", value = disappearActions)
        json.writeExpression(key = "dynamic_height", value = dynamicHeight)
        json.write(key = "extensions", value = extensions)
        json.write(key = "focus", value = focus)
        json.writeExpression(key = "has_separator", value = hasSeparator)
        json.write(key = "height", value = height)
        json.write(key = "id", value = id)
        json.write(key = "items", value = items)
        json.write(key = "margins", value = margins)
        json.write(key = "paddings", value = paddings)
        json.writeExpression(key = "restrict_parent_scroll", value = restrictParentScroll)
        json.writeExpression(key = "row_span", value = rowSpan)
        json.write(key = "selected_actions", value = selectedActions)
        json.writeExpression(key = "selected_tab", value = selectedTab)
        json.writeExpression(key = "separator_color", value = separatorColor, converter = COLOR_INT_TO_STRING)
        json.write(key = "separator_paddings", value = separatorPaddings)
        json.writeExpression(key = "switch_tabs_by_content_swipe_enabled", value = switchTabsByContentSwipeEnabled)
        json.write(key = "tab_title_style", value = tabTitleStyle)
        json.write(key = "title_paddings", value = titlePaddings)
        json.write(key = "tooltips", value = tooltips)
        json.write(key = "transform", value = transform)
        json.write(key = "transition_change", value = transitionChange)
        json.write(key = "transition_in", value = transitionIn)
        json.write(key = "transition_out", value = transitionOut)
        json.write(key = "transition_triggers", value = transitionTriggers, converter = { v: DivTransitionTrigger -> DivTransitionTrigger.toString(v) })
        json.write(key = "type", value = TYPE)
        json.writeExpression(key = "visibility", value = visibility, converter = { v: DivVisibility -> DivVisibility.toString(v) })
        json.write(key = "visibility_action", value = visibilityAction)
        json.write(key = "visibility_actions", value = visibilityActions)
        json.write(key = "width", value = width)
        return json
    }

    fun copyWithNewProperties(
        items: List<DivTabs.Item>,
    ) = DivTabs(
        accessibility,
        alignmentHorizontal,
        alignmentVertical,
        alpha,
        background,
        border,
        columnSpan,
        disappearActions,
        dynamicHeight,
        extensions,
        focus,
        hasSeparator,
        height,
        id,
        items,
        margins,
        paddings,
        restrictParentScroll,
        rowSpan,
        selectedActions,
        selectedTab,
        separatorColor,
        separatorPaddings,
        switchTabsByContentSwipeEnabled,
        tabTitleStyle,
        titlePaddings,
        tooltips,
        transform,
        transitionChange,
        transitionIn,
        transitionOut,
        transitionTriggers,
        visibility,
        visibilityAction,
        visibilityActions,
        width,
    )

    companion object {
        const val TYPE = "tabs"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val DYNAMIC_HEIGHT_DEFAULT_VALUE = Expression.constant(false)
        private val HAS_SEPARATOR_DEFAULT_VALUE = Expression.constant(false)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val RESTRICT_PARENT_SCROLL_DEFAULT_VALUE = Expression.constant(false)
        private val SELECTED_TAB_DEFAULT_VALUE = Expression.constant(0L)
        private val SEPARATOR_COLOR_DEFAULT_VALUE = Expression.constant(0x14000000.toInt())
        private val SEPARATOR_PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(0L), left = Expression.constant(12L), right = Expression.constant(12L), top = Expression.constant(0L))
        private val SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        private val TITLE_PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(8L), left = Expression.constant(12L), right = Expression.constant(12L), top = Expression.constant(0L))
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        private val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        private val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        private val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivTabs {
            val logger = env.logger
            return DivTabs(
                accessibility = JsonParser.readOptional(json, "accessibility", DivAccessibility.CREATOR, logger, env),
                alignmentHorizontal = JsonParser.readOptionalExpression(json, "alignment_horizontal", DivAlignmentHorizontal.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_HORIZONTAL),
                alignmentVertical = JsonParser.readOptionalExpression(json, "alignment_vertical", DivAlignmentVertical.Converter.FROM_STRING, logger, env, TYPE_HELPER_ALIGNMENT_VERTICAL),
                alpha = JsonParser.readOptionalExpression(json, "alpha", NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, logger, env, ALPHA_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: ALPHA_DEFAULT_VALUE,
                background = JsonParser.readOptionalList(json, "background", DivBackground.CREATOR, logger, env),
                border = JsonParser.readOptional(json, "border", DivBorder.CREATOR, logger, env),
                columnSpan = JsonParser.readOptionalExpression(json, "column_span", NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                disappearActions = JsonParser.readOptionalList(json, "disappear_actions", DivDisappearAction.CREATOR, logger, env),
                dynamicHeight = JsonParser.readOptionalExpression(json, "dynamic_height", ANY_TO_BOOLEAN, logger, env, DYNAMIC_HEIGHT_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: DYNAMIC_HEIGHT_DEFAULT_VALUE,
                extensions = JsonParser.readOptionalList(json, "extensions", DivExtension.CREATOR, logger, env),
                focus = JsonParser.readOptional(json, "focus", DivFocus.CREATOR, logger, env),
                hasSeparator = JsonParser.readOptionalExpression(json, "has_separator", ANY_TO_BOOLEAN, logger, env, HAS_SEPARATOR_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: HAS_SEPARATOR_DEFAULT_VALUE,
                height = JsonParser.readOptional(json, "height", DivSize.CREATOR, logger, env) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonParser.readOptional(json, "id", logger, env),
                items = JsonParser.readList(json, "items", Item.CREATOR, ITEMS_VALIDATOR, logger, env),
                margins = JsonParser.readOptional(json, "margins", DivEdgeInsets.CREATOR, logger, env),
                paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env),
                restrictParentScroll = JsonParser.readOptionalExpression(json, "restrict_parent_scroll", ANY_TO_BOOLEAN, logger, env, RESTRICT_PARENT_SCROLL_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: RESTRICT_PARENT_SCROLL_DEFAULT_VALUE,
                rowSpan = JsonParser.readOptionalExpression(json, "row_span", NUMBER_TO_INT, ROW_SPAN_VALIDATOR, logger, env, TYPE_HELPER_INT),
                selectedActions = JsonParser.readOptionalList(json, "selected_actions", DivAction.CREATOR, logger, env),
                selectedTab = JsonParser.readOptionalExpression(json, "selected_tab", NUMBER_TO_INT, SELECTED_TAB_VALIDATOR, logger, env, SELECTED_TAB_DEFAULT_VALUE, TYPE_HELPER_INT) ?: SELECTED_TAB_DEFAULT_VALUE,
                separatorColor = JsonParser.readOptionalExpression(json, "separator_color", STRING_TO_COLOR_INT, logger, env, SEPARATOR_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: SEPARATOR_COLOR_DEFAULT_VALUE,
                separatorPaddings = JsonParser.readOptional(json, "separator_paddings", DivEdgeInsets.CREATOR, logger, env) ?: SEPARATOR_PADDINGS_DEFAULT_VALUE,
                switchTabsByContentSwipeEnabled = JsonParser.readOptionalExpression(json, "switch_tabs_by_content_swipe_enabled", ANY_TO_BOOLEAN, logger, env, SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE, TYPE_HELPER_BOOLEAN) ?: SWITCH_TABS_BY_CONTENT_SWIPE_ENABLED_DEFAULT_VALUE,
                tabTitleStyle = JsonParser.readOptional(json, "tab_title_style", TabTitleStyle.CREATOR, logger, env),
                titlePaddings = JsonParser.readOptional(json, "title_paddings", DivEdgeInsets.CREATOR, logger, env) ?: TITLE_PADDINGS_DEFAULT_VALUE,
                tooltips = JsonParser.readOptionalList(json, "tooltips", DivTooltip.CREATOR, logger, env),
                transform = JsonParser.readOptional(json, "transform", DivTransform.CREATOR, logger, env),
                transitionChange = JsonParser.readOptional(json, "transition_change", DivChangeTransition.CREATOR, logger, env),
                transitionIn = JsonParser.readOptional(json, "transition_in", DivAppearanceTransition.CREATOR, logger, env),
                transitionOut = JsonParser.readOptional(json, "transition_out", DivAppearanceTransition.CREATOR, logger, env),
                transitionTriggers = JsonParser.readOptionalList(json, "transition_triggers", DivTransitionTrigger.Converter.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR, logger, env),
                visibility = JsonParser.readOptionalExpression(json, "visibility", DivVisibility.Converter.FROM_STRING, logger, env, VISIBILITY_DEFAULT_VALUE, TYPE_HELPER_VISIBILITY) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonParser.readOptional(json, "visibility_action", DivVisibilityAction.CREATOR, logger, env),
                visibilityActions = JsonParser.readOptionalList(json, "visibility_actions", DivVisibilityAction.CREATOR, logger, env),
                width = JsonParser.readOptional(json, "width", DivSize.CREATOR, logger, env) ?: WIDTH_DEFAULT_VALUE
            )
        }

        private val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        private val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val ITEMS_VALIDATOR = ListValidator<DivTabs.Item> { it: List<*> -> it.size >= 1 }
        private val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val SELECTED_TAB_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        private val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTabs(env, json = it) }
    }


    @Mockable
    class TabTitleStyle @DivModelInternalApi constructor (
        @JvmField final val activeBackgroundColor: Expression<Int> = ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE, // default value: #FFFFDC60
        @JvmField final val activeFontWeight: Expression<DivFontWeight>? = null,
        @JvmField final val activeTextColor: Expression<Int> = ACTIVE_TEXT_COLOR_DEFAULT_VALUE, // default value: #CC000000
        @JvmField final val animationDuration: Expression<Long> = ANIMATION_DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 300
        @JvmField final val animationType: Expression<AnimationType> = ANIMATION_TYPE_DEFAULT_VALUE, // default value: slide
        @JvmField final val cornerRadius: Expression<Long>? = null, // constraint: number >= 0
        @JvmField final val cornersRadius: DivCornersRadius? = null,
        @JvmField final val fontFamily: Expression<String>? = null,
        @JvmField final val fontSize: Expression<Long> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
        @JvmField final val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
        @JvmField final val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
        @JvmField final val inactiveBackgroundColor: Expression<Int>? = null,
        @JvmField final val inactiveFontWeight: Expression<DivFontWeight>? = null,
        @JvmField final val inactiveTextColor: Expression<Int> = INACTIVE_TEXT_COLOR_DEFAULT_VALUE, // default value: #80000000
        @JvmField final val itemSpacing: Expression<Long> = ITEM_SPACING_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
        @JvmField final val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
        @JvmField final val lineHeight: Expression<Long>? = null, // constraint: number >= 0
        @JvmField final val paddings: DivEdgeInsets = PADDINGS_DEFAULT_VALUE, // default value: DivEdgeInsets(bottom = Expression.constant(6L), left = Expression.constant(8L), right = Expression.constant(8L), top = Expression.constant(6L))
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                activeBackgroundColor.hashCode() +
                (activeFontWeight?.hashCode() ?: 0) +
                activeTextColor.hashCode() +
                animationDuration.hashCode() +
                animationType.hashCode() +
                (cornerRadius?.hashCode() ?: 0) +
                (cornersRadius?.hash() ?: 0) +
                (fontFamily?.hashCode() ?: 0) +
                fontSize.hashCode() +
                fontSizeUnit.hashCode() +
                fontWeight.hashCode() +
                (inactiveBackgroundColor?.hashCode() ?: 0) +
                (inactiveFontWeight?.hashCode() ?: 0) +
                inactiveTextColor.hashCode() +
                itemSpacing.hashCode() +
                letterSpacing.hashCode() +
                (lineHeight?.hashCode() ?: 0) +
                paddings.hash()
            _hash = hash
            return hash
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.writeExpression(key = "active_background_color", value = activeBackgroundColor, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "active_font_weight", value = activeFontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeExpression(key = "active_text_color", value = activeTextColor, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "animation_duration", value = animationDuration)
            json.writeExpression(key = "animation_type", value = animationType, converter = { v: AnimationType -> AnimationType.toString(v) })
            json.writeExpression(key = "corner_radius", value = cornerRadius)
            json.write(key = "corners_radius", value = cornersRadius)
            json.writeExpression(key = "font_family", value = fontFamily)
            json.writeExpression(key = "font_size", value = fontSize)
            json.writeExpression(key = "font_size_unit", value = fontSizeUnit, converter = { v: DivSizeUnit -> DivSizeUnit.toString(v) })
            json.writeExpression(key = "font_weight", value = fontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeExpression(key = "inactive_background_color", value = inactiveBackgroundColor, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "inactive_font_weight", value = inactiveFontWeight, converter = { v: DivFontWeight -> DivFontWeight.toString(v) })
            json.writeExpression(key = "inactive_text_color", value = inactiveTextColor, converter = COLOR_INT_TO_STRING)
            json.writeExpression(key = "item_spacing", value = itemSpacing)
            json.writeExpression(key = "letter_spacing", value = letterSpacing)
            json.writeExpression(key = "line_height", value = lineHeight)
            json.write(key = "paddings", value = paddings)
            return json
        }

        companion object {
            private val ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE = Expression.constant(0xFFFFDC60.toInt())
            private val ACTIVE_TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xCC000000.toInt())
            private val ANIMATION_DURATION_DEFAULT_VALUE = Expression.constant(300L)
            private val ANIMATION_TYPE_DEFAULT_VALUE = Expression.constant(AnimationType.SLIDE)
            private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
            private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
            private val INACTIVE_TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0x80000000.toInt())
            private val ITEM_SPACING_DEFAULT_VALUE = Expression.constant(0L)
            private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
            private val PADDINGS_DEFAULT_VALUE = DivEdgeInsets(bottom = Expression.constant(6L), left = Expression.constant(8L), right = Expression.constant(8L), top = Expression.constant(6L))

            private val TYPE_HELPER_ACTIVE_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
            private val TYPE_HELPER_ANIMATION_TYPE = TypeHelper.from(default = DivTabs.TabTitleStyle.AnimationType.values().first()) { it is DivTabs.TabTitleStyle.AnimationType }
            private val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
            private val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
            private val TYPE_HELPER_INACTIVE_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): TabTitleStyle {
                val logger = env.logger
                return TabTitleStyle(
                    activeBackgroundColor = JsonParser.readOptionalExpression(json, "active_background_color", STRING_TO_COLOR_INT, logger, env, ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: ACTIVE_BACKGROUND_COLOR_DEFAULT_VALUE,
                    activeFontWeight = JsonParser.readOptionalExpression(json, "active_font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_ACTIVE_FONT_WEIGHT),
                    activeTextColor = JsonParser.readOptionalExpression(json, "active_text_color", STRING_TO_COLOR_INT, logger, env, ACTIVE_TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: ACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                    animationDuration = JsonParser.readOptionalExpression(json, "animation_duration", NUMBER_TO_INT, ANIMATION_DURATION_VALIDATOR, logger, env, ANIMATION_DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: ANIMATION_DURATION_DEFAULT_VALUE,
                    animationType = JsonParser.readOptionalExpression(json, "animation_type", AnimationType.Converter.FROM_STRING, logger, env, ANIMATION_TYPE_DEFAULT_VALUE, TYPE_HELPER_ANIMATION_TYPE) ?: ANIMATION_TYPE_DEFAULT_VALUE,
                    cornerRadius = JsonParser.readOptionalExpression(json, "corner_radius", NUMBER_TO_INT, CORNER_RADIUS_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    cornersRadius = JsonParser.readOptional(json, "corners_radius", DivCornersRadius.CREATOR, logger, env),
                    fontFamily = JsonParser.readOptionalExpression(json, "font_family", logger, env, TYPE_HELPER_STRING),
                    fontSize = JsonParser.readOptionalExpression(json, "font_size", NUMBER_TO_INT, FONT_SIZE_VALIDATOR, logger, env, FONT_SIZE_DEFAULT_VALUE, TYPE_HELPER_INT) ?: FONT_SIZE_DEFAULT_VALUE,
                    fontSizeUnit = JsonParser.readOptionalExpression(json, "font_size_unit", DivSizeUnit.Converter.FROM_STRING, logger, env, FONT_SIZE_UNIT_DEFAULT_VALUE, TYPE_HELPER_FONT_SIZE_UNIT) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                    fontWeight = JsonParser.readOptionalExpression(json, "font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, FONT_WEIGHT_DEFAULT_VALUE, TYPE_HELPER_FONT_WEIGHT) ?: FONT_WEIGHT_DEFAULT_VALUE,
                    inactiveBackgroundColor = JsonParser.readOptionalExpression(json, "inactive_background_color", STRING_TO_COLOR_INT, logger, env, TYPE_HELPER_COLOR),
                    inactiveFontWeight = JsonParser.readOptionalExpression(json, "inactive_font_weight", DivFontWeight.Converter.FROM_STRING, logger, env, TYPE_HELPER_INACTIVE_FONT_WEIGHT),
                    inactiveTextColor = JsonParser.readOptionalExpression(json, "inactive_text_color", STRING_TO_COLOR_INT, logger, env, INACTIVE_TEXT_COLOR_DEFAULT_VALUE, TYPE_HELPER_COLOR) ?: INACTIVE_TEXT_COLOR_DEFAULT_VALUE,
                    itemSpacing = JsonParser.readOptionalExpression(json, "item_spacing", NUMBER_TO_INT, ITEM_SPACING_VALIDATOR, logger, env, ITEM_SPACING_DEFAULT_VALUE, TYPE_HELPER_INT) ?: ITEM_SPACING_DEFAULT_VALUE,
                    letterSpacing = JsonParser.readOptionalExpression(json, "letter_spacing", NUMBER_TO_DOUBLE, logger, env, LETTER_SPACING_DEFAULT_VALUE, TYPE_HELPER_DOUBLE) ?: LETTER_SPACING_DEFAULT_VALUE,
                    lineHeight = JsonParser.readOptionalExpression(json, "line_height", NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR, logger, env, TYPE_HELPER_INT),
                    paddings = JsonParser.readOptional(json, "paddings", DivEdgeInsets.CREATOR, logger, env) ?: PADDINGS_DEFAULT_VALUE
                )
            }

            private val ANIMATION_DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
            private val CORNER_RADIUS_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
            private val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
            private val ITEM_SPACING_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
            private val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> TabTitleStyle(env, json = it) }
        }


        enum class AnimationType(private val value: String) {
            SLIDE("slide"),
            FADE("fade"),
            NONE("none");

            companion object Converter {
                fun toString(obj: AnimationType): String {
                    return obj.value
                }

                fun fromString(string: String): AnimationType? {
                    return when (string) {
                        SLIDE.value -> SLIDE
                        FADE.value -> FADE
                        NONE.value -> NONE
                        else -> null
                    }
                }

                val FROM_STRING = { string: String ->
                    when (string) {
                        SLIDE.value -> SLIDE
                        FADE.value -> FADE
                        NONE.value -> NONE
                        else -> null
                    }
                }
            }
        }
    }

    @Mockable
    class Item @DivModelInternalApi constructor (
        @JvmField final val div: Div,
        @JvmField final val title: Expression<String>,
        @JvmField final val titleClickAction: DivAction? = null,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                div.hash() +
                title.hashCode() +
                (titleClickAction?.hash() ?: 0)
            _hash = hash
            return hash
        }

        override fun writeToJSON(): JSONObject {
            val json = JSONObject()
            json.write(key = "div", value = div)
            json.writeExpression(key = "title", value = title)
            json.write(key = "title_click_action", value = titleClickAction)
            return json
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Item {
                val logger = env.logger
                return Item(
                    div = JsonParser.read(json, "div", Div.CREATOR, logger, env),
                    title = JsonParser.readExpression(json, "title", logger, env, TYPE_HELPER_STRING),
                    titleClickAction = JsonParser.readOptional(json, "title_click_action", DivAction.CREATOR, logger, env)
                )
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Item(env, json = it) }
        }

    }
}
