// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
class DivTooltip @DivModelInternalApi constructor (
    @JvmField final val animationIn: DivAnimation? = null,
    @JvmField final val animationOut: DivAnimation? = null,
    @JvmField final val div: Div,
    @JvmField final val duration: Expression<Long> = DURATION_DEFAULT_VALUE, // constraint: number >= 0; default value: 5000
    @JvmField final val id: String,
    @JvmField final val offset: DivPoint? = null,
    @JvmField final val position: Expression<Position>,
) : JSONSerializable, Hashable {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            (animationIn?.hash() ?: 0) +
            (animationOut?.hash() ?: 0) +
            div.hash() +
            duration.hashCode() +
            id.hashCode() +
            (offset?.hash() ?: 0) +
            position.hashCode()
        _hash = hash
        return hash
    }

    override fun writeToJSON(): JSONObject {
        val json = JSONObject()
        json.write(key = "animation_in", value = animationIn)
        json.write(key = "animation_out", value = animationOut)
        json.write(key = "div", value = div)
        json.writeExpression(key = "duration", value = duration)
        json.write(key = "id", value = id)
        json.write(key = "offset", value = offset)
        json.writeExpression(key = "position", value = position, converter = { v: Position -> Position.toString(v) })
        return json
    }

    companion object {
        private val DURATION_DEFAULT_VALUE = Expression.constant(5000L)

        private val TYPE_HELPER_POSITION = TypeHelper.from(default = DivTooltip.Position.values().first()) { it is DivTooltip.Position }

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivTooltip {
            val logger = env.logger
            return DivTooltip(
                animationIn = JsonParser.readOptional(json, "animation_in", DivAnimation.CREATOR, logger, env),
                animationOut = JsonParser.readOptional(json, "animation_out", DivAnimation.CREATOR, logger, env),
                div = JsonParser.read(json, "div", Div.CREATOR, logger, env),
                duration = JsonParser.readOptionalExpression(json, "duration", NUMBER_TO_INT, DURATION_VALIDATOR, logger, env, DURATION_DEFAULT_VALUE, TYPE_HELPER_INT) ?: DURATION_DEFAULT_VALUE,
                id = JsonParser.read(json, "id", logger, env),
                offset = JsonParser.readOptional(json, "offset", DivPoint.CREATOR, logger, env),
                position = JsonParser.readExpression(json, "position", Position.Converter.FROM_STRING, logger, env, TYPE_HELPER_POSITION)
            )
        }

        private val DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTooltip(env, json = it) }
    }


    enum class Position(private val value: String) {
        LEFT("left"),
        TOP_LEFT("top-left"),
        TOP("top"),
        TOP_RIGHT("top-right"),
        RIGHT("right"),
        BOTTOM_RIGHT("bottom-right"),
        BOTTOM("bottom"),
        BOTTOM_LEFT("bottom-left"),
        CENTER("center");

        companion object Converter {
            fun toString(obj: Position): String {
                return obj.value
            }

            fun fromString(string: String): Position? {
                return when (string) {
                    LEFT.value -> LEFT
                    TOP_LEFT.value -> TOP_LEFT
                    TOP.value -> TOP
                    TOP_RIGHT.value -> TOP_RIGHT
                    RIGHT.value -> RIGHT
                    BOTTOM_RIGHT.value -> BOTTOM_RIGHT
                    BOTTOM.value -> BOTTOM
                    BOTTOM_LEFT.value -> BOTTOM_LEFT
                    CENTER.value -> CENTER
                    else -> null
                }
            }

            val FROM_STRING = { string: String ->
                when (string) {
                    LEFT.value -> LEFT
                    TOP_LEFT.value -> TOP_LEFT
                    TOP.value -> TOP
                    TOP_RIGHT.value -> TOP_RIGHT
                    RIGHT.value -> RIGHT
                    BOTTOM_RIGHT.value -> BOTTOM_RIGHT
                    BOTTOM.value -> BOTTOM
                    BOTTOM_LEFT.value -> BOTTOM_LEFT
                    CENTER.value -> CENTER
                    else -> null
                }
            }
        }
    }
}
