// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivTypedValue : JSONSerializable, Hashable {
    class Str(val value: StrValue) : DivTypedValue()
    class Integer(val value: IntegerValue) : DivTypedValue()
    class Number(val value: NumberValue) : DivTypedValue()
    class Color(val value: ColorValue) : DivTypedValue()
    class Bool(val value: BoolValue) : DivTypedValue()
    class Url(val value: UrlValue) : DivTypedValue()
    class Dict(val value: DictValue) : DivTypedValue()
    class Array(val value: ArrayValue) : DivTypedValue()

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        return when(this) {
            is Str -> 31 + this.value.hash()
            is Integer -> 62 + this.value.hash()
            is Number -> 93 + this.value.hash()
            is Color -> 124 + this.value.hash()
            is Bool -> 155 + this.value.hash()
            is Url -> 186 + this.value.hash()
            is Dict -> 217 + this.value.hash()
            is Array -> 248 + this.value.hash()
        }.also {
            _hash = it
        }
    }

    fun value(): Any {
        return when (this) {
            is Str -> value
            is Integer -> value
            is Number -> value
            is Color -> value
            is Bool -> value
            is Url -> value
            is Dict -> value
            is Array -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Str -> value.writeToJSON()
            is Integer -> value.writeToJSON()
            is Number -> value.writeToJSON()
            is Color -> value.writeToJSON()
            is Bool -> value.writeToJSON()
            is Url -> value.writeToJSON()
            is Dict -> value.writeToJSON()
            is Array -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivTypedValue {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                StrValue.TYPE -> return Str(StrValue(env, json))
                IntegerValue.TYPE -> return Integer(IntegerValue(env, json))
                NumberValue.TYPE -> return Number(NumberValue(env, json))
                ColorValue.TYPE -> return Color(ColorValue(env, json))
                BoolValue.TYPE -> return Bool(BoolValue(env, json))
                UrlValue.TYPE -> return Url(UrlValue(env, json))
                DictValue.TYPE -> return Dict(DictValue(env, json))
                ArrayValue.TYPE -> return Array(ArrayValue(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivTypedValueTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivTypedValue(env, json = it) }
    }
}
