// Generated code. Do not modify.

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.core.annotations.Mockable
import java.io.IOException
import java.util.BitSet
import org.json.JSONObject
import com.yandex.div.data.*
import org.json.JSONArray

@Mockable
sealed class DivVariable : JSONSerializable, Hashable {
    class Str(val value: StrVariable) : DivVariable()
    class Number(val value: NumberVariable) : DivVariable()
    class Integer(val value: IntegerVariable) : DivVariable()
    class Bool(val value: BoolVariable) : DivVariable()
    class Color(val value: ColorVariable) : DivVariable()
    class Url(val value: UrlVariable) : DivVariable()
    class Dict(val value: DictVariable) : DivVariable()
    class Array(val value: ArrayVariable) : DivVariable()

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        return when(this) {
            is Str -> 31 + this.value.hash()
            is Number -> 62 + this.value.hash()
            is Integer -> 93 + this.value.hash()
            is Bool -> 124 + this.value.hash()
            is Color -> 155 + this.value.hash()
            is Url -> 186 + this.value.hash()
            is Dict -> 217 + this.value.hash()
            is Array -> 248 + this.value.hash()
        }.also {
            _hash = it
        }
    }

    fun value(): Any {
        return when (this) {
            is Str -> value
            is Number -> value
            is Integer -> value
            is Bool -> value
            is Color -> value
            is Url -> value
            is Dict -> value
            is Array -> value
        }
    }

    override fun writeToJSON(): JSONObject {
        return when (this) {
            is Str -> value.writeToJSON()
            is Number -> value.writeToJSON()
            is Integer -> value.writeToJSON()
            is Bool -> value.writeToJSON()
            is Color -> value.writeToJSON()
            is Url -> value.writeToJSON()
            is Dict -> value.writeToJSON()
            is Array -> value.writeToJSON()
        }
    }

    companion object {
        @Throws(ParsingException::class)
        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivVariable {
            val logger = env.logger
            val type: String = json.read("type", logger = logger, env = env)
            when (type) {
                StrVariable.TYPE -> return Str(StrVariable(env, json))
                NumberVariable.TYPE -> return Number(NumberVariable(env, json))
                IntegerVariable.TYPE -> return Integer(IntegerVariable(env, json))
                BoolVariable.TYPE -> return Bool(BoolVariable(env, json))
                ColorVariable.TYPE -> return Color(ColorVariable(env, json))
                UrlVariable.TYPE -> return Url(UrlVariable(env, json))
                DictVariable.TYPE -> return Dict(DictVariable(env, json))
                ArrayVariable.TYPE -> return Array(ArrayVariable(env, json))
            }
            val template = env.templates.getOrThrow(type, json) as? DivVariableTemplate
            if (template != null) {
                return template.resolve(env, json)
            } else {
                throw typeMismatch(json = json, key = "type", value = type)
            }
        }
        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivVariable(env, json = it) }
    }
}
