// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivAnimationJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivAnimation> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivAnimation {
            val logger = context.logger
            return DivAnimation(
                duration = JsonExpressionParser.readOptionalExpression(context, logger, data, "duration", TYPE_HELPER_INT, NUMBER_TO_INT, DURATION_VALIDATOR, DURATION_DEFAULT_VALUE) ?: DURATION_DEFAULT_VALUE,
                endValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "end_value", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE),
                interpolator = JsonExpressionParser.readOptionalExpression(context, logger, data, "interpolator", TYPE_HELPER_INTERPOLATOR, DivAnimationInterpolator.FROM_STRING, INTERPOLATOR_DEFAULT_VALUE) ?: INTERPOLATOR_DEFAULT_VALUE,
                items = JsonPropertyParser.readOptionalList(context, logger, data, "items", component.divAnimationJsonEntityParser),
                name = JsonExpressionParser.readExpression(context, logger, data, "name", TYPE_HELPER_NAME, DivAnimation.Name.FROM_STRING),
                repeat = JsonPropertyParser.readOptional(context, logger, data, "repeat", component.divCountJsonEntityParser) ?: REPEAT_DEFAULT_VALUE,
                startDelay = JsonExpressionParser.readOptionalExpression(context, logger, data, "start_delay", TYPE_HELPER_INT, NUMBER_TO_INT, START_DELAY_VALIDATOR, START_DELAY_DEFAULT_VALUE) ?: START_DELAY_DEFAULT_VALUE,
                startValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "start_value", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivAnimation): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "duration", value = value.duration)
            data.writeExpression(key = "end_value", value = value.endValue)
            data.writeExpression(key = "interpolator", value = value.interpolator, converter = DivAnimationInterpolator.TO_STRING)
            data.write(key = "items", value = component.divAnimationJsonEntityParser.value.serialize(context, value.items))
            data.writeExpression(key = "name", value = value.name, converter = DivAnimation.Name.TO_STRING)
            data.write(key = "repeat", value = component.divCountJsonEntityParser.value.serialize(context, value.repeat))
            data.writeExpression(key = "start_delay", value = value.startDelay)
            data.writeExpression(key = "start_value", value = value.startValue)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivAnimationTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivAnimationTemplate?, data: JSONObject): DivAnimationTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivAnimationTemplate(
                duration = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "duration", TYPE_HELPER_INT, allowOverride, parent?.duration, NUMBER_TO_INT, DURATION_VALIDATOR),
                endValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "end_value", TYPE_HELPER_DOUBLE, allowOverride, parent?.endValue, NUMBER_TO_DOUBLE),
                interpolator = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "interpolator", TYPE_HELPER_INTERPOLATOR, allowOverride, parent?.interpolator, DivAnimationInterpolator.FROM_STRING),
                items = JsonFieldParser.readOptionalListField(context, logger, data, "items", allowOverride, parent?.items, component.divAnimationJsonTemplateParser),
                name = JsonFieldParser.readFieldWithExpression(context, logger, data, "name", TYPE_HELPER_NAME, allowOverride, parent?.name, DivAnimation.Name.FROM_STRING),
                repeat = JsonFieldParser.readOptionalField(context, logger, data, "repeat", allowOverride, parent?.repeat, component.divCountJsonTemplateParser),
                startDelay = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "start_delay", TYPE_HELPER_INT, allowOverride, parent?.startDelay, NUMBER_TO_INT, START_DELAY_VALIDATOR),
                startValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "start_value", TYPE_HELPER_DOUBLE, allowOverride, parent?.startValue, NUMBER_TO_DOUBLE),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivAnimationTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "duration", field = value.duration)
            data.writeFieldWithExpression(key = "end_value", field = value.endValue)
            data.writeFieldWithExpression(key = "interpolator", field = value.interpolator, converter = DivAnimationInterpolator.TO_STRING)
            data.writeField(key = "items", field = value.items, converter = component.divAnimationJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "name", field = value.name, converter = DivAnimation.Name.TO_STRING)
            data.writeField(key = "repeat", field = value.repeat, converter = component.divCountJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "start_delay", field = value.startDelay)
            data.writeFieldWithExpression(key = "start_value", field = value.startValue)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivAnimationTemplate, DivAnimation> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivAnimationTemplate, data: JSONObject): DivAnimation {
            val logger = context.logger
            return DivAnimation(
                duration = JsonFieldResolver.resolveOptionalExpression(context, logger, template.duration, data, "duration", TYPE_HELPER_INT, NUMBER_TO_INT, DURATION_VALIDATOR, DURATION_DEFAULT_VALUE) ?: DURATION_DEFAULT_VALUE,
                endValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.endValue, data, "end_value", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE),
                interpolator = JsonFieldResolver.resolveOptionalExpression(context, logger, template.interpolator, data, "interpolator", TYPE_HELPER_INTERPOLATOR, DivAnimationInterpolator.FROM_STRING, INTERPOLATOR_DEFAULT_VALUE) ?: INTERPOLATOR_DEFAULT_VALUE,
                items = JsonFieldResolver.resolveOptionalList(context, logger, template.items, data, "items", component.divAnimationJsonTemplateResolver, component.divAnimationJsonEntityParser),
                name = JsonFieldResolver.resolveExpression(context, logger, template.name, data, "name", TYPE_HELPER_NAME, DivAnimation.Name.FROM_STRING),
                repeat = JsonFieldResolver.resolveOptional(context, logger, template.repeat, data, "repeat", component.divCountJsonTemplateResolver, component.divCountJsonEntityParser) ?: REPEAT_DEFAULT_VALUE,
                startDelay = JsonFieldResolver.resolveOptionalExpression(context, logger, template.startDelay, data, "start_delay", TYPE_HELPER_INT, NUMBER_TO_INT, START_DELAY_VALIDATOR, START_DELAY_DEFAULT_VALUE) ?: START_DELAY_DEFAULT_VALUE,
                startValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.startValue, data, "start_value", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE),
            )
        }
    }

    private companion object {

        @JvmField val DURATION_DEFAULT_VALUE = Expression.constant(300L)
        @JvmField val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.SPRING)
        @JvmField val REPEAT_DEFAULT_VALUE = DivCount.Infinity(DivInfinityCount())
        @JvmField val START_DELAY_DEFAULT_VALUE = Expression.constant(0L)

        @JvmField val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }
        @JvmField val TYPE_HELPER_NAME = TypeHelper.from(default = DivAnimation.Name.values().first()) { it is DivAnimation.Name }

        @JvmField val DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val START_DELAY_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
    }
}
