// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivColorAnimatorJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivColorAnimator> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivColorAnimator {
            val logger = context.logger
            return DivColorAnimator(
                cancelActions = JsonPropertyParser.readOptionalList(context, logger, data, "cancel_actions", component.divActionJsonEntityParser),
                direction = JsonExpressionParser.readOptionalExpression(context, logger, data, "direction", TYPE_HELPER_DIRECTION, DivAnimationDirection.FROM_STRING, DIRECTION_DEFAULT_VALUE) ?: DIRECTION_DEFAULT_VALUE,
                duration = JsonExpressionParser.readExpression(context, logger, data, "duration", TYPE_HELPER_INT, NUMBER_TO_INT, DURATION_VALIDATOR),
                endActions = JsonPropertyParser.readOptionalList(context, logger, data, "end_actions", component.divActionJsonEntityParser),
                endValue = JsonExpressionParser.readExpression(context, logger, data, "end_value", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                id = JsonPropertyParser.read(context, logger, data, "id"),
                interpolator = JsonExpressionParser.readOptionalExpression(context, logger, data, "interpolator", TYPE_HELPER_INTERPOLATOR, DivAnimationInterpolator.FROM_STRING, INTERPOLATOR_DEFAULT_VALUE) ?: INTERPOLATOR_DEFAULT_VALUE,
                repeatCount = JsonPropertyParser.readOptional(context, logger, data, "repeat_count", component.divCountJsonEntityParser) ?: REPEAT_COUNT_DEFAULT_VALUE,
                startDelay = JsonExpressionParser.readOptionalExpression(context, logger, data, "start_delay", TYPE_HELPER_INT, NUMBER_TO_INT, START_DELAY_VALIDATOR, START_DELAY_DEFAULT_VALUE) ?: START_DELAY_DEFAULT_VALUE,
                startValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "start_value", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                variableName = JsonPropertyParser.read(context, logger, data, "variable_name"),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivColorAnimator): JSONObject {
            val data = JSONObject()
            data.write(key = "cancel_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.cancelActions))
            data.writeExpression(key = "direction", value = value.direction, converter = DivAnimationDirection.TO_STRING)
            data.writeExpression(key = "duration", value = value.duration)
            data.write(key = "end_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.endActions))
            data.writeExpression(key = "end_value", value = value.endValue, converter = COLOR_INT_TO_STRING)
            data.write(key = "id", value = value.id)
            data.writeExpression(key = "interpolator", value = value.interpolator, converter = DivAnimationInterpolator.TO_STRING)
            data.write(key = "repeat_count", value = component.divCountJsonEntityParser.value.serialize(context, value.repeatCount))
            data.writeExpression(key = "start_delay", value = value.startDelay)
            data.writeExpression(key = "start_value", value = value.startValue, converter = COLOR_INT_TO_STRING)
            data.write(key = "type", value = DivColorAnimator.TYPE)
            data.write(key = "variable_name", value = value.variableName)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivColorAnimatorTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivColorAnimatorTemplate?, data: JSONObject): DivColorAnimatorTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivColorAnimatorTemplate(
                cancelActions = JsonFieldParser.readOptionalListField(context, logger, data, "cancel_actions", allowOverride, parent?.cancelActions, component.divActionJsonTemplateParser),
                direction = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "direction", TYPE_HELPER_DIRECTION, allowOverride, parent?.direction, DivAnimationDirection.FROM_STRING),
                duration = JsonFieldParser.readFieldWithExpression(context, logger, data, "duration", TYPE_HELPER_INT, allowOverride, parent?.duration, NUMBER_TO_INT, DURATION_VALIDATOR),
                endActions = JsonFieldParser.readOptionalListField(context, logger, data, "end_actions", allowOverride, parent?.endActions, component.divActionJsonTemplateParser),
                endValue = JsonFieldParser.readFieldWithExpression(context, logger, data, "end_value", TYPE_HELPER_COLOR, allowOverride, parent?.endValue, STRING_TO_COLOR_INT),
                id = JsonFieldParser.readField(context, logger, data, "id", allowOverride, parent?.id),
                interpolator = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "interpolator", TYPE_HELPER_INTERPOLATOR, allowOverride, parent?.interpolator, DivAnimationInterpolator.FROM_STRING),
                repeatCount = JsonFieldParser.readOptionalField(context, logger, data, "repeat_count", allowOverride, parent?.repeatCount, component.divCountJsonTemplateParser),
                startDelay = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "start_delay", TYPE_HELPER_INT, allowOverride, parent?.startDelay, NUMBER_TO_INT, START_DELAY_VALIDATOR),
                startValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "start_value", TYPE_HELPER_COLOR, allowOverride, parent?.startValue, STRING_TO_COLOR_INT),
                variableName = JsonFieldParser.readField(context, logger, data, "variable_name", allowOverride, parent?.variableName),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivColorAnimatorTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "cancel_actions", field = value.cancelActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "direction", field = value.direction, converter = DivAnimationDirection.TO_STRING)
            data.writeFieldWithExpression(key = "duration", field = value.duration)
            data.writeField(key = "end_actions", field = value.endActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "end_value", field = value.endValue, converter = COLOR_INT_TO_STRING)
            data.writeField(key = "id", field = value.id)
            data.writeFieldWithExpression(key = "interpolator", field = value.interpolator, converter = DivAnimationInterpolator.TO_STRING)
            data.writeField(key = "repeat_count", field = value.repeatCount, converter = component.divCountJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "start_delay", field = value.startDelay)
            data.writeFieldWithExpression(key = "start_value", field = value.startValue, converter = COLOR_INT_TO_STRING)
            data.write(key = "type", value = DivColorAnimator.TYPE)
            data.writeField(key = "variable_name", field = value.variableName)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivColorAnimatorTemplate, DivColorAnimator> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivColorAnimatorTemplate, data: JSONObject): DivColorAnimator {
            val logger = context.logger
            return DivColorAnimator(
                cancelActions = JsonFieldResolver.resolveOptionalList(context, logger, template.cancelActions, data, "cancel_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                direction = JsonFieldResolver.resolveOptionalExpression(context, logger, template.direction, data, "direction", TYPE_HELPER_DIRECTION, DivAnimationDirection.FROM_STRING, DIRECTION_DEFAULT_VALUE) ?: DIRECTION_DEFAULT_VALUE,
                duration = JsonFieldResolver.resolveExpression(context, logger, template.duration, data, "duration", TYPE_HELPER_INT, NUMBER_TO_INT, DURATION_VALIDATOR),
                endActions = JsonFieldResolver.resolveOptionalList(context, logger, template.endActions, data, "end_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                endValue = JsonFieldResolver.resolveExpression(context, logger, template.endValue, data, "end_value", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                id = JsonFieldResolver.resolve(context, logger, template.id, data, "id"),
                interpolator = JsonFieldResolver.resolveOptionalExpression(context, logger, template.interpolator, data, "interpolator", TYPE_HELPER_INTERPOLATOR, DivAnimationInterpolator.FROM_STRING, INTERPOLATOR_DEFAULT_VALUE) ?: INTERPOLATOR_DEFAULT_VALUE,
                repeatCount = JsonFieldResolver.resolveOptional(context, logger, template.repeatCount, data, "repeat_count", component.divCountJsonTemplateResolver, component.divCountJsonEntityParser) ?: REPEAT_COUNT_DEFAULT_VALUE,
                startDelay = JsonFieldResolver.resolveOptionalExpression(context, logger, template.startDelay, data, "start_delay", TYPE_HELPER_INT, NUMBER_TO_INT, START_DELAY_VALIDATOR, START_DELAY_DEFAULT_VALUE) ?: START_DELAY_DEFAULT_VALUE,
                startValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.startValue, data, "start_value", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                variableName = JsonFieldResolver.resolve(context, logger, template.variableName, data, "variable_name"),
            )
        }
    }

    private companion object {

        @JvmField val DIRECTION_DEFAULT_VALUE = Expression.constant(DivAnimationDirection.NORMAL)
        @JvmField val INTERPOLATOR_DEFAULT_VALUE = Expression.constant(DivAnimationInterpolator.LINEAR)
        @JvmField val REPEAT_COUNT_DEFAULT_VALUE = DivCount.Fixed(DivFixedCount(value = Expression.constant(1L)))
        @JvmField val START_DELAY_DEFAULT_VALUE = Expression.constant(0L)

        @JvmField val TYPE_HELPER_DIRECTION = TypeHelper.from(default = DivAnimationDirection.values().first()) { it is DivAnimationDirection }
        @JvmField val TYPE_HELPER_INTERPOLATOR = TypeHelper.from(default = DivAnimationInterpolator.values().first()) { it is DivAnimationInterpolator }

        @JvmField val DURATION_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val START_DELAY_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
    }
}
