// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivContainerJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivContainer> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivContainer {
            val logger = context.logger
            return DivContainer(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                action = JsonPropertyParser.readOptional(context, logger, data, "action", component.divActionJsonEntityParser),
                actionAnimation = JsonPropertyParser.readOptional(context, logger, data, "action_animation", component.divAnimationJsonEntityParser) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonPropertyParser.readOptionalList(context, logger, data, "actions", component.divActionJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                aspect = JsonPropertyParser.readOptional(context, logger, data, "aspect", component.divAspectJsonEntityParser),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                clipToBounds = JsonExpressionParser.readOptionalExpression(context, logger, data, "clip_to_bounds", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, CLIP_TO_BOUNDS_DEFAULT_VALUE) ?: CLIP_TO_BOUNDS_DEFAULT_VALUE,
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                contentAlignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "content_alignment_horizontal", TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL, DivContentAlignmentHorizontal.FROM_STRING, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "content_alignment_vertical", TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL, DivContentAlignmentVertical.FROM_STRING, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                doubletapActions = JsonPropertyParser.readOptionalList(context, logger, data, "doubletap_actions", component.divActionJsonEntityParser),
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                hoverEndActions = JsonPropertyParser.readOptionalList(context, logger, data, "hover_end_actions", component.divActionJsonEntityParser),
                hoverStartActions = JsonPropertyParser.readOptionalList(context, logger, data, "hover_start_actions", component.divActionJsonEntityParser),
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                itemBuilder = JsonPropertyParser.readOptional(context, logger, data, "item_builder", component.divCollectionItemBuilderJsonEntityParser),
                items = JsonPropertyParser.readOptionalList(context, logger, data, "items", component.divJsonEntityParser),
                layoutMode = JsonExpressionParser.readOptionalExpression(context, logger, data, "layout_mode", TYPE_HELPER_LAYOUT_MODE, DivContainer.LayoutMode.FROM_STRING, LAYOUT_MODE_DEFAULT_VALUE) ?: LAYOUT_MODE_DEFAULT_VALUE,
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                lineSeparator = JsonPropertyParser.readOptional(context, logger, data, "line_separator", component.divContainerSeparatorJsonEntityParser),
                longtapActions = JsonPropertyParser.readOptionalList(context, logger, data, "longtap_actions", component.divActionJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                orientation = JsonExpressionParser.readOptionalExpression(context, logger, data, "orientation", TYPE_HELPER_ORIENTATION, DivContainer.Orientation.FROM_STRING, ORIENTATION_DEFAULT_VALUE) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                pressEndActions = JsonPropertyParser.readOptionalList(context, logger, data, "press_end_actions", component.divActionJsonEntityParser),
                pressStartActions = JsonPropertyParser.readOptionalList(context, logger, data, "press_start_actions", component.divActionJsonEntityParser),
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                separator = JsonPropertyParser.readOptional(context, logger, data, "separator", component.divContainerSeparatorJsonEntityParser),
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivContainer): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.write(key = "action", value = component.divActionJsonEntityParser.value.serialize(context, value.action))
            data.write(key = "action_animation", value = component.divAnimationJsonEntityParser.value.serialize(context, value.actionAnimation))
            data.write(key = "actions", value = component.divActionJsonEntityParser.value.serialize(context, value.actions))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.write(key = "aspect", value = component.divAspectJsonEntityParser.value.serialize(context, value.aspect))
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "clip_to_bounds", value = value.clipToBounds)
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.writeExpression(key = "content_alignment_horizontal", value = value.contentAlignmentHorizontal, converter = DivContentAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "content_alignment_vertical", value = value.contentAlignmentVertical, converter = DivContentAlignmentVertical.TO_STRING)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "doubletap_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.doubletapActions))
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "hover_end_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.hoverEndActions))
            data.write(key = "hover_start_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.hoverStartActions))
            data.write(key = "id", value = value.id)
            data.write(key = "item_builder", value = component.divCollectionItemBuilderJsonEntityParser.value.serialize(context, value.itemBuilder))
            data.write(key = "items", value = component.divJsonEntityParser.value.serialize(context, value.items))
            data.writeExpression(key = "layout_mode", value = value.layoutMode, converter = DivContainer.LayoutMode.TO_STRING)
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.write(key = "line_separator", value = component.divContainerSeparatorJsonEntityParser.value.serialize(context, value.lineSeparator))
            data.write(key = "longtap_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.longtapActions))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "orientation", value = value.orientation, converter = DivContainer.Orientation.TO_STRING)
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.write(key = "press_end_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.pressEndActions))
            data.write(key = "press_start_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.pressStartActions))
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.write(key = "separator", value = component.divContainerSeparatorJsonEntityParser.value.serialize(context, value.separator))
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivContainer.TYPE)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivContainerTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivContainerTemplate?, data: JSONObject): DivContainerTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivContainerTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                action = JsonFieldParser.readOptionalField(context, logger, data, "action", allowOverride, parent?.action, component.divActionJsonTemplateParser),
                actionAnimation = JsonFieldParser.readOptionalField(context, logger, data, "action_animation", allowOverride, parent?.actionAnimation, component.divAnimationJsonTemplateParser),
                actions = JsonFieldParser.readOptionalListField(context, logger, data, "actions", allowOverride, parent?.actions, component.divActionJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                aspect = JsonFieldParser.readOptionalField(context, logger, data, "aspect", allowOverride, parent?.aspect, component.divAspectJsonTemplateParser),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                clipToBounds = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "clip_to_bounds", TYPE_HELPER_BOOLEAN, allowOverride, parent?.clipToBounds, ANY_TO_BOOLEAN),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                contentAlignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "content_alignment_horizontal", TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL, allowOverride, parent?.contentAlignmentHorizontal, DivContentAlignmentHorizontal.FROM_STRING),
                contentAlignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "content_alignment_vertical", TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL, allowOverride, parent?.contentAlignmentVertical, DivContentAlignmentVertical.FROM_STRING),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                doubletapActions = JsonFieldParser.readOptionalListField(context, logger, data, "doubletap_actions", allowOverride, parent?.doubletapActions, component.divActionJsonTemplateParser),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                hoverEndActions = JsonFieldParser.readOptionalListField(context, logger, data, "hover_end_actions", allowOverride, parent?.hoverEndActions, component.divActionJsonTemplateParser),
                hoverStartActions = JsonFieldParser.readOptionalListField(context, logger, data, "hover_start_actions", allowOverride, parent?.hoverStartActions, component.divActionJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                itemBuilder = JsonFieldParser.readOptionalField(context, logger, data, "item_builder", allowOverride, parent?.itemBuilder, component.divCollectionItemBuilderJsonTemplateParser),
                items = JsonFieldParser.readOptionalListField(context, logger, data, "items", allowOverride, parent?.items, component.divJsonTemplateParser),
                layoutMode = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "layout_mode", TYPE_HELPER_LAYOUT_MODE, allowOverride, parent?.layoutMode, DivContainer.LayoutMode.FROM_STRING),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                lineSeparator = JsonFieldParser.readOptionalField(context, logger, data, "line_separator", allowOverride, parent?.lineSeparator, component.divContainerSeparatorJsonTemplateParser),
                longtapActions = JsonFieldParser.readOptionalListField(context, logger, data, "longtap_actions", allowOverride, parent?.longtapActions, component.divActionJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                orientation = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "orientation", TYPE_HELPER_ORIENTATION, allowOverride, parent?.orientation, DivContainer.Orientation.FROM_STRING),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                pressEndActions = JsonFieldParser.readOptionalListField(context, logger, data, "press_end_actions", allowOverride, parent?.pressEndActions, component.divActionJsonTemplateParser),
                pressStartActions = JsonFieldParser.readOptionalListField(context, logger, data, "press_start_actions", allowOverride, parent?.pressStartActions, component.divActionJsonTemplateParser),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                separator = JsonFieldParser.readOptionalField(context, logger, data, "separator", allowOverride, parent?.separator, component.divContainerSeparatorJsonTemplateParser),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivContainerTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "action", field = value.action, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "action_animation", field = value.actionAnimation, converter = component.divAnimationJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "actions", field = value.actions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "aspect", field = value.aspect, converter = component.divAspectJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "clip_to_bounds", field = value.clipToBounds)
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeFieldWithExpression(key = "content_alignment_horizontal", field = value.contentAlignmentHorizontal, converter = DivContentAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "content_alignment_vertical", field = value.contentAlignmentVertical, converter = DivContentAlignmentVertical.TO_STRING)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "doubletap_actions", field = value.doubletapActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "hover_end_actions", field = value.hoverEndActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "hover_start_actions", field = value.hoverStartActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeField(key = "item_builder", field = value.itemBuilder, converter = component.divCollectionItemBuilderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "items", field = value.items, converter = component.divJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "layout_mode", field = value.layoutMode, converter = DivContainer.LayoutMode.TO_STRING)
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "line_separator", field = value.lineSeparator, converter = component.divContainerSeparatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "longtap_actions", field = value.longtapActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "orientation", field = value.orientation, converter = DivContainer.Orientation.TO_STRING)
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "press_end_actions", field = value.pressEndActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "press_start_actions", field = value.pressStartActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "separator", field = value.separator, converter = component.divContainerSeparatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivContainer.TYPE)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivContainerTemplate, DivContainer> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivContainerTemplate, data: JSONObject): DivContainer {
            val logger = context.logger
            return DivContainer(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                action = JsonFieldResolver.resolveOptional(context, logger, template.action, data, "action", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                actionAnimation = JsonFieldResolver.resolveOptional(context, logger, template.actionAnimation, data, "action_animation", component.divAnimationJsonTemplateResolver, component.divAnimationJsonEntityParser) ?: ACTION_ANIMATION_DEFAULT_VALUE,
                actions = JsonFieldResolver.resolveOptionalList(context, logger, template.actions, data, "actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                aspect = JsonFieldResolver.resolveOptional(context, logger, template.aspect, data, "aspect", component.divAspectJsonTemplateResolver, component.divAspectJsonEntityParser),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                clipToBounds = JsonFieldResolver.resolveOptionalExpression(context, logger, template.clipToBounds, data, "clip_to_bounds", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, CLIP_TO_BOUNDS_DEFAULT_VALUE) ?: CLIP_TO_BOUNDS_DEFAULT_VALUE,
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                contentAlignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.contentAlignmentHorizontal, data, "content_alignment_horizontal", TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL, DivContentAlignmentHorizontal.FROM_STRING, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.contentAlignmentVertical, data, "content_alignment_vertical", TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL, DivContentAlignmentVertical.FROM_STRING, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                doubletapActions = JsonFieldResolver.resolveOptionalList(context, logger, template.doubletapActions, data, "doubletap_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                hoverEndActions = JsonFieldResolver.resolveOptionalList(context, logger, template.hoverEndActions, data, "hover_end_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                hoverStartActions = JsonFieldResolver.resolveOptionalList(context, logger, template.hoverStartActions, data, "hover_start_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                itemBuilder = JsonFieldResolver.resolveOptional(context, logger, template.itemBuilder, data, "item_builder", component.divCollectionItemBuilderJsonTemplateResolver, component.divCollectionItemBuilderJsonEntityParser),
                items = JsonFieldResolver.resolveOptionalList(context, logger, template.items, data, "items", component.divJsonTemplateResolver, component.divJsonEntityParser),
                layoutMode = JsonFieldResolver.resolveOptionalExpression(context, logger, template.layoutMode, data, "layout_mode", TYPE_HELPER_LAYOUT_MODE, DivContainer.LayoutMode.FROM_STRING, LAYOUT_MODE_DEFAULT_VALUE) ?: LAYOUT_MODE_DEFAULT_VALUE,
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                lineSeparator = JsonFieldResolver.resolveOptional(context, logger, template.lineSeparator, data, "line_separator", component.divContainerSeparatorJsonTemplateResolver, component.divContainerSeparatorJsonEntityParser),
                longtapActions = JsonFieldResolver.resolveOptionalList(context, logger, template.longtapActions, data, "longtap_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                orientation = JsonFieldResolver.resolveOptionalExpression(context, logger, template.orientation, data, "orientation", TYPE_HELPER_ORIENTATION, DivContainer.Orientation.FROM_STRING, ORIENTATION_DEFAULT_VALUE) ?: ORIENTATION_DEFAULT_VALUE,
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                pressEndActions = JsonFieldResolver.resolveOptionalList(context, logger, template.pressEndActions, data, "press_end_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                pressStartActions = JsonFieldResolver.resolveOptionalList(context, logger, template.pressStartActions, data, "press_start_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                separator = JsonFieldResolver.resolveOptional(context, logger, template.separator, data, "separator", component.divContainerSeparatorJsonTemplateResolver, component.divContainerSeparatorJsonEntityParser),
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val CLIP_TO_BOUNDS_DEFAULT_VALUE = Expression.constant(true)
        @JvmField val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivContentAlignmentHorizontal.START)
        @JvmField val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivContentAlignmentVertical.TOP)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val LAYOUT_MODE_DEFAULT_VALUE = Expression.constant(DivContainer.LayoutMode.NO_WRAP)
        @JvmField val ORIENTATION_DEFAULT_VALUE = Expression.constant(DivContainer.Orientation.VERTICAL)
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivContentAlignmentHorizontal.values().first()) { it is DivContentAlignmentHorizontal }
        @JvmField val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivContentAlignmentVertical.values().first()) { it is DivContentAlignmentVertical }
        @JvmField val TYPE_HELPER_LAYOUT_MODE = TypeHelper.from(default = DivContainer.LayoutMode.values().first()) { it is DivContainer.LayoutMode }
        @JvmField val TYPE_HELPER_ORIENTATION = TypeHelper.from(default = DivContainer.Orientation.values().first()) { it is DivContainer.Orientation }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivContainerSeparatorJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivContainer.Separator> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivContainer.Separator {
            val logger = context.logger
            return DivContainer.Separator(
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                showAtEnd = JsonExpressionParser.readOptionalExpression(context, logger, data, "show_at_end", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SHOW_AT_END_DEFAULT_VALUE) ?: SHOW_AT_END_DEFAULT_VALUE,
                showAtStart = JsonExpressionParser.readOptionalExpression(context, logger, data, "show_at_start", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SHOW_AT_START_DEFAULT_VALUE) ?: SHOW_AT_START_DEFAULT_VALUE,
                showBetween = JsonExpressionParser.readOptionalExpression(context, logger, data, "show_between", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SHOW_BETWEEN_DEFAULT_VALUE) ?: SHOW_BETWEEN_DEFAULT_VALUE,
                style = JsonPropertyParser.read(context, logger, data, "style", component.divDrawableJsonEntityParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivContainer.Separator): JSONObject {
            val data = JSONObject()
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "show_at_end", value = value.showAtEnd)
            data.writeExpression(key = "show_at_start", value = value.showAtStart)
            data.writeExpression(key = "show_between", value = value.showBetween)
            data.write(key = "style", value = component.divDrawableJsonEntityParser.value.serialize(context, value.style))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivContainerTemplate.SeparatorTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivContainerTemplate.SeparatorTemplate?, data: JSONObject): DivContainerTemplate.SeparatorTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivContainerTemplate.SeparatorTemplate(
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                showAtEnd = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "show_at_end", TYPE_HELPER_BOOLEAN, allowOverride, parent?.showAtEnd, ANY_TO_BOOLEAN),
                showAtStart = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "show_at_start", TYPE_HELPER_BOOLEAN, allowOverride, parent?.showAtStart, ANY_TO_BOOLEAN),
                showBetween = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "show_between", TYPE_HELPER_BOOLEAN, allowOverride, parent?.showBetween, ANY_TO_BOOLEAN),
                style = JsonFieldParser.readField(context, logger, data, "style", allowOverride, parent?.style, component.divDrawableJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivContainerTemplate.SeparatorTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "show_at_end", field = value.showAtEnd)
            data.writeFieldWithExpression(key = "show_at_start", field = value.showAtStart)
            data.writeFieldWithExpression(key = "show_between", field = value.showBetween)
            data.writeField(key = "style", field = value.style, converter = component.divDrawableJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivContainerTemplate.SeparatorTemplate, DivContainer.Separator> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivContainerTemplate.SeparatorTemplate, data: JSONObject): DivContainer.Separator {
            val logger = context.logger
            return DivContainer.Separator(
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                showAtEnd = JsonFieldResolver.resolveOptionalExpression(context, logger, template.showAtEnd, data, "show_at_end", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SHOW_AT_END_DEFAULT_VALUE) ?: SHOW_AT_END_DEFAULT_VALUE,
                showAtStart = JsonFieldResolver.resolveOptionalExpression(context, logger, template.showAtStart, data, "show_at_start", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SHOW_AT_START_DEFAULT_VALUE) ?: SHOW_AT_START_DEFAULT_VALUE,
                showBetween = JsonFieldResolver.resolveOptionalExpression(context, logger, template.showBetween, data, "show_between", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SHOW_BETWEEN_DEFAULT_VALUE) ?: SHOW_BETWEEN_DEFAULT_VALUE,
                style = JsonFieldResolver.resolve(context, logger, template.style, data, "style", component.divDrawableJsonTemplateResolver, component.divDrawableJsonEntityParser),
            )
        }
    }

    private companion object {

        @JvmField val SHOW_AT_END_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val SHOW_AT_START_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val SHOW_BETWEEN_DEFAULT_VALUE = Expression.constant(true)
    }
}
