// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivDataJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivData> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivData {
            val logger = context.logger
            @Suppress("NAME_SHADOWING") val context = context.collectingErrors()
            return DivData(
                logId = JsonPropertyParser.read(context, logger, data, "log_id"),
                states = JsonPropertyParser.readList(context, logger, data, "states", component.divDataStateJsonEntityParser, STATES_VALIDATOR),
                timers = JsonPropertyParser.readOptionalList(context, logger, data, "timers", component.divTimerJsonEntityParser),
                transitionAnimationSelector = JsonExpressionParser.readOptionalExpression(context, logger, data, "transition_animation_selector", TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR, DivTransitionSelector.FROM_STRING, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                parsingErrors = context.collectedErrors
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivData): JSONObject {
            val data = JSONObject()
            data.write(key = "log_id", value = value.logId)
            data.write(key = "states", value = component.divDataStateJsonEntityParser.value.serialize(context, value.states))
            data.write(key = "timers", value = component.divTimerJsonEntityParser.value.serialize(context, value.timers))
            data.writeExpression(key = "transition_animation_selector", value = value.transitionAnimationSelector, converter = DivTransitionSelector.TO_STRING)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivDataTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivDataTemplate?, data: JSONObject): DivDataTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivDataTemplate(
                logId = JsonFieldParser.readField(context, logger, data, "log_id", allowOverride, parent?.logId),
                states = JsonFieldParser.readListField(context, logger, data, "states", allowOverride, parent?.states, component.divDataStateJsonTemplateParser, STATES_VALIDATOR.cast()),
                timers = JsonFieldParser.readOptionalListField(context, logger, data, "timers", allowOverride, parent?.timers, component.divTimerJsonTemplateParser),
                transitionAnimationSelector = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "transition_animation_selector", TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR, allowOverride, parent?.transitionAnimationSelector, DivTransitionSelector.FROM_STRING),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivDataTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "log_id", field = value.logId)
            data.writeField(key = "states", field = value.states, converter = component.divDataStateJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "timers", field = value.timers, converter = component.divTimerJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "transition_animation_selector", field = value.transitionAnimationSelector, converter = DivTransitionSelector.TO_STRING)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivDataTemplate, DivData> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivDataTemplate, data: JSONObject): DivData {
            val logger = context.logger
            return DivData(
                logId = JsonFieldResolver.resolve(context, logger, template.logId, data, "log_id"),
                states = JsonFieldResolver.resolveList(context, logger, template.states, data, "states", component.divDataStateJsonTemplateResolver, component.divDataStateJsonEntityParser, STATES_VALIDATOR),
                timers = JsonFieldResolver.resolveOptionalList(context, logger, template.timers, data, "timers", component.divTimerJsonTemplateResolver, component.divTimerJsonEntityParser),
                transitionAnimationSelector = JsonFieldResolver.resolveOptionalExpression(context, logger, template.transitionAnimationSelector, data, "transition_animation_selector", TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR, DivTransitionSelector.FROM_STRING, TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE) ?: TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE,
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
            )
        }
    }

    private companion object {

        @JvmField val TRANSITION_ANIMATION_SELECTOR_DEFAULT_VALUE = Expression.constant(DivTransitionSelector.NONE)

        @JvmField val TYPE_HELPER_TRANSITION_ANIMATION_SELECTOR = TypeHelper.from(default = DivTransitionSelector.values().first()) { it is DivTransitionSelector }

        @JvmField val STATES_VALIDATOR = ListValidator<DivData.State> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivDataStateJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivData.State> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivData.State {
            val logger = context.logger
            return DivData.State(
                div = JsonPropertyParser.read(context, logger, data, "div", component.divJsonEntityParser),
                stateId = JsonPropertyParser.read(context, logger, data, "state_id", NUMBER_TO_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivData.State): JSONObject {
            val data = JSONObject()
            data.write(key = "div", value = component.divJsonEntityParser.value.serialize(context, value.div))
            data.write(key = "state_id", value = value.stateId)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivDataTemplate.StateTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivDataTemplate.StateTemplate?, data: JSONObject): DivDataTemplate.StateTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivDataTemplate.StateTemplate(
                div = JsonFieldParser.readField(context, logger, data, "div", allowOverride, parent?.div, component.divJsonTemplateParser),
                stateId = JsonFieldParser.readField(context, logger, data, "state_id", allowOverride, parent?.stateId, NUMBER_TO_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivDataTemplate.StateTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "div", field = value.div, converter = component.divJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "state_id", field = value.stateId)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivDataTemplate.StateTemplate, DivData.State> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivDataTemplate.StateTemplate, data: JSONObject): DivData.State {
            val logger = context.logger
            return DivData.State(
                div = JsonFieldResolver.resolve(context, logger, template.div, data, "div", component.divJsonTemplateResolver, component.divJsonEntityParser),
                stateId = JsonFieldResolver.resolve(context, logger, template.stateId, data, "state_id", NUMBER_TO_INT),
            )
        }
    }
}
