// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivImageBackgroundJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivImageBackground> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivImageBackground {
            val logger = context.logger
            return DivImageBackground(
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                contentAlignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "content_alignment_horizontal", TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "content_alignment_vertical", TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                filters = JsonPropertyParser.readOptionalList(context, logger, data, "filters", component.divFilterJsonEntityParser),
                imageUrl = JsonExpressionParser.readExpression(context, logger, data, "image_url", TYPE_HELPER_URI, ANY_TO_URI),
                preloadRequired = JsonExpressionParser.readOptionalExpression(context, logger, data, "preload_required", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, PRELOAD_REQUIRED_DEFAULT_VALUE) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                scale = JsonExpressionParser.readOptionalExpression(context, logger, data, "scale", TYPE_HELPER_SCALE, DivImageScale.FROM_STRING, SCALE_DEFAULT_VALUE) ?: SCALE_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivImageBackground): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "alpha", value = value.alpha)
            data.writeExpression(key = "content_alignment_horizontal", value = value.contentAlignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "content_alignment_vertical", value = value.contentAlignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.write(key = "filters", value = component.divFilterJsonEntityParser.value.serialize(context, value.filters))
            data.writeExpression(key = "image_url", value = value.imageUrl, converter = URI_TO_STRING)
            data.writeExpression(key = "preload_required", value = value.preloadRequired)
            data.writeExpression(key = "scale", value = value.scale, converter = DivImageScale.TO_STRING)
            data.write(key = "type", value = DivImageBackground.TYPE)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivImageBackgroundTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivImageBackgroundTemplate?, data: JSONObject): DivImageBackgroundTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivImageBackgroundTemplate(
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                contentAlignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "content_alignment_horizontal", TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL, allowOverride, parent?.contentAlignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                contentAlignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "content_alignment_vertical", TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL, allowOverride, parent?.contentAlignmentVertical, DivAlignmentVertical.FROM_STRING),
                filters = JsonFieldParser.readOptionalListField(context, logger, data, "filters", allowOverride, parent?.filters, component.divFilterJsonTemplateParser),
                imageUrl = JsonFieldParser.readFieldWithExpression(context, logger, data, "image_url", TYPE_HELPER_URI, allowOverride, parent?.imageUrl, ANY_TO_URI),
                preloadRequired = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "preload_required", TYPE_HELPER_BOOLEAN, allowOverride, parent?.preloadRequired, ANY_TO_BOOLEAN),
                scale = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "scale", TYPE_HELPER_SCALE, allowOverride, parent?.scale, DivImageScale.FROM_STRING),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivImageBackgroundTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeFieldWithExpression(key = "content_alignment_horizontal", field = value.contentAlignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "content_alignment_vertical", field = value.contentAlignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeField(key = "filters", field = value.filters, converter = component.divFilterJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "image_url", field = value.imageUrl, converter = URI_TO_STRING)
            data.writeFieldWithExpression(key = "preload_required", field = value.preloadRequired)
            data.writeFieldWithExpression(key = "scale", field = value.scale, converter = DivImageScale.TO_STRING)
            data.write(key = "type", value = DivImageBackground.TYPE)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivImageBackgroundTemplate, DivImageBackground> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivImageBackgroundTemplate, data: JSONObject): DivImageBackground {
            val logger = context.logger
            return DivImageBackground(
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                contentAlignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.contentAlignmentHorizontal, data, "content_alignment_horizontal", TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                contentAlignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.contentAlignmentVertical, data, "content_alignment_vertical", TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                filters = JsonFieldResolver.resolveOptionalList(context, logger, template.filters, data, "filters", component.divFilterJsonTemplateResolver, component.divFilterJsonEntityParser),
                imageUrl = JsonFieldResolver.resolveExpression(context, logger, template.imageUrl, data, "image_url", TYPE_HELPER_URI, ANY_TO_URI),
                preloadRequired = JsonFieldResolver.resolveOptionalExpression(context, logger, template.preloadRequired, data, "preload_required", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, PRELOAD_REQUIRED_DEFAULT_VALUE) ?: PRELOAD_REQUIRED_DEFAULT_VALUE,
                scale = JsonFieldResolver.resolveOptionalExpression(context, logger, template.scale, data, "scale", TYPE_HELPER_SCALE, DivImageScale.FROM_STRING, SCALE_DEFAULT_VALUE) ?: SCALE_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.CENTER)
        @JvmField val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        @JvmField val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val SCALE_DEFAULT_VALUE = Expression.constant(DivImageScale.FILL)

        @JvmField val TYPE_HELPER_CONTENT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_CONTENT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_SCALE = TypeHelper.from(default = DivImageScale.values().first()) { it is DivImageScale }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
    }
}
