// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivIndicatorJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivIndicator> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivIndicator {
            val logger = context.logger
            return DivIndicator(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                activeItemColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "active_item_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, ACTIVE_ITEM_COLOR_DEFAULT_VALUE) ?: ACTIVE_ITEM_COLOR_DEFAULT_VALUE,
                activeItemSize = JsonExpressionParser.readOptionalExpression(context, logger, data, "active_item_size", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ACTIVE_ITEM_SIZE_VALIDATOR, ACTIVE_ITEM_SIZE_DEFAULT_VALUE) ?: ACTIVE_ITEM_SIZE_DEFAULT_VALUE,
                activeShape = JsonPropertyParser.readOptional(context, logger, data, "active_shape", component.divRoundedRectangleShapeJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animation = JsonExpressionParser.readOptionalExpression(context, logger, data, "animation", TYPE_HELPER_ANIMATION, DivIndicator.Animation.FROM_STRING, ANIMATION_DEFAULT_VALUE) ?: ANIMATION_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                inactiveItemColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "inactive_item_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, INACTIVE_ITEM_COLOR_DEFAULT_VALUE) ?: INACTIVE_ITEM_COLOR_DEFAULT_VALUE,
                inactiveMinimumShape = JsonPropertyParser.readOptional(context, logger, data, "inactive_minimum_shape", component.divRoundedRectangleShapeJsonEntityParser),
                inactiveShape = JsonPropertyParser.readOptional(context, logger, data, "inactive_shape", component.divRoundedRectangleShapeJsonEntityParser),
                itemsPlacement = JsonPropertyParser.readOptional(context, logger, data, "items_placement", component.divIndicatorItemPlacementJsonEntityParser),
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                minimumItemSize = JsonExpressionParser.readOptionalExpression(context, logger, data, "minimum_item_size", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, MINIMUM_ITEM_SIZE_VALIDATOR, MINIMUM_ITEM_SIZE_DEFAULT_VALUE) ?: MINIMUM_ITEM_SIZE_DEFAULT_VALUE,
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                pagerId = JsonPropertyParser.readOptional(context, logger, data, "pager_id"),
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                shape = JsonPropertyParser.readOptional(context, logger, data, "shape", component.divShapeJsonEntityParser) ?: SHAPE_DEFAULT_VALUE,
                spaceBetweenCenters = JsonPropertyParser.readOptional(context, logger, data, "space_between_centers", component.divFixedSizeJsonEntityParser) ?: SPACE_BETWEEN_CENTERS_DEFAULT_VALUE,
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivIndicator): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "active_item_color", value = value.activeItemColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "active_item_size", value = value.activeItemSize)
            data.write(key = "active_shape", value = component.divRoundedRectangleShapeJsonEntityParser.value.serialize(context, value.activeShape))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.writeExpression(key = "animation", value = value.animation, converter = DivIndicator.Animation.TO_STRING)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.write(key = "id", value = value.id)
            data.writeExpression(key = "inactive_item_color", value = value.inactiveItemColor, converter = COLOR_INT_TO_STRING)
            data.write(key = "inactive_minimum_shape", value = component.divRoundedRectangleShapeJsonEntityParser.value.serialize(context, value.inactiveMinimumShape))
            data.write(key = "inactive_shape", value = component.divRoundedRectangleShapeJsonEntityParser.value.serialize(context, value.inactiveShape))
            data.write(key = "items_placement", value = component.divIndicatorItemPlacementJsonEntityParser.value.serialize(context, value.itemsPlacement))
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.writeExpression(key = "minimum_item_size", value = value.minimumItemSize)
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.write(key = "pager_id", value = value.pagerId)
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.write(key = "shape", value = component.divShapeJsonEntityParser.value.serialize(context, value.shape))
            data.write(key = "space_between_centers", value = component.divFixedSizeJsonEntityParser.value.serialize(context, value.spaceBetweenCenters))
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivIndicator.TYPE)
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivIndicatorTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivIndicatorTemplate?, data: JSONObject): DivIndicatorTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivIndicatorTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                activeItemColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "active_item_color", TYPE_HELPER_COLOR, allowOverride, parent?.activeItemColor, STRING_TO_COLOR_INT),
                activeItemSize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "active_item_size", TYPE_HELPER_DOUBLE, allowOverride, parent?.activeItemSize, NUMBER_TO_DOUBLE, ACTIVE_ITEM_SIZE_VALIDATOR),
                activeShape = JsonFieldParser.readOptionalField(context, logger, data, "active_shape", allowOverride, parent?.activeShape, component.divRoundedRectangleShapeJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animation = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "animation", TYPE_HELPER_ANIMATION, allowOverride, parent?.animation, DivIndicator.Animation.FROM_STRING),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                inactiveItemColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "inactive_item_color", TYPE_HELPER_COLOR, allowOverride, parent?.inactiveItemColor, STRING_TO_COLOR_INT),
                inactiveMinimumShape = JsonFieldParser.readOptionalField(context, logger, data, "inactive_minimum_shape", allowOverride, parent?.inactiveMinimumShape, component.divRoundedRectangleShapeJsonTemplateParser),
                inactiveShape = JsonFieldParser.readOptionalField(context, logger, data, "inactive_shape", allowOverride, parent?.inactiveShape, component.divRoundedRectangleShapeJsonTemplateParser),
                itemsPlacement = JsonFieldParser.readOptionalField(context, logger, data, "items_placement", allowOverride, parent?.itemsPlacement, component.divIndicatorItemPlacementJsonTemplateParser),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                minimumItemSize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "minimum_item_size", TYPE_HELPER_DOUBLE, allowOverride, parent?.minimumItemSize, NUMBER_TO_DOUBLE, MINIMUM_ITEM_SIZE_VALIDATOR),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                pagerId = JsonFieldParser.readOptionalField(context, logger, data, "pager_id", allowOverride, parent?.pagerId),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                shape = JsonFieldParser.readOptionalField(context, logger, data, "shape", allowOverride, parent?.shape, component.divShapeJsonTemplateParser),
                spaceBetweenCenters = JsonFieldParser.readOptionalField(context, logger, data, "space_between_centers", allowOverride, parent?.spaceBetweenCenters, component.divFixedSizeJsonTemplateParser),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivIndicatorTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "active_item_color", field = value.activeItemColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "active_item_size", field = value.activeItemSize)
            data.writeField(key = "active_shape", field = value.activeShape, converter = component.divRoundedRectangleShapeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeFieldWithExpression(key = "animation", field = value.animation, converter = DivIndicator.Animation.TO_STRING)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "id", field = value.id)
            data.writeFieldWithExpression(key = "inactive_item_color", field = value.inactiveItemColor, converter = COLOR_INT_TO_STRING)
            data.writeField(key = "inactive_minimum_shape", field = value.inactiveMinimumShape, converter = component.divRoundedRectangleShapeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "inactive_shape", field = value.inactiveShape, converter = component.divRoundedRectangleShapeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "items_placement", field = value.itemsPlacement, converter = component.divIndicatorItemPlacementJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "minimum_item_size", field = value.minimumItemSize)
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "pager_id", field = value.pagerId)
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "shape", field = value.shape, converter = component.divShapeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "space_between_centers", field = value.spaceBetweenCenters, converter = component.divFixedSizeJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivIndicator.TYPE)
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivIndicatorTemplate, DivIndicator> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivIndicatorTemplate, data: JSONObject): DivIndicator {
            val logger = context.logger
            return DivIndicator(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                activeItemColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.activeItemColor, data, "active_item_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, ACTIVE_ITEM_COLOR_DEFAULT_VALUE) ?: ACTIVE_ITEM_COLOR_DEFAULT_VALUE,
                activeItemSize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.activeItemSize, data, "active_item_size", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ACTIVE_ITEM_SIZE_VALIDATOR, ACTIVE_ITEM_SIZE_DEFAULT_VALUE) ?: ACTIVE_ITEM_SIZE_DEFAULT_VALUE,
                activeShape = JsonFieldResolver.resolveOptional(context, logger, template.activeShape, data, "active_shape", component.divRoundedRectangleShapeJsonTemplateResolver, component.divRoundedRectangleShapeJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animation = JsonFieldResolver.resolveOptionalExpression(context, logger, template.animation, data, "animation", TYPE_HELPER_ANIMATION, DivIndicator.Animation.FROM_STRING, ANIMATION_DEFAULT_VALUE) ?: ANIMATION_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                inactiveItemColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.inactiveItemColor, data, "inactive_item_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, INACTIVE_ITEM_COLOR_DEFAULT_VALUE) ?: INACTIVE_ITEM_COLOR_DEFAULT_VALUE,
                inactiveMinimumShape = JsonFieldResolver.resolveOptional(context, logger, template.inactiveMinimumShape, data, "inactive_minimum_shape", component.divRoundedRectangleShapeJsonTemplateResolver, component.divRoundedRectangleShapeJsonEntityParser),
                inactiveShape = JsonFieldResolver.resolveOptional(context, logger, template.inactiveShape, data, "inactive_shape", component.divRoundedRectangleShapeJsonTemplateResolver, component.divRoundedRectangleShapeJsonEntityParser),
                itemsPlacement = JsonFieldResolver.resolveOptional(context, logger, template.itemsPlacement, data, "items_placement", component.divIndicatorItemPlacementJsonTemplateResolver, component.divIndicatorItemPlacementJsonEntityParser),
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                minimumItemSize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.minimumItemSize, data, "minimum_item_size", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, MINIMUM_ITEM_SIZE_VALIDATOR, MINIMUM_ITEM_SIZE_DEFAULT_VALUE) ?: MINIMUM_ITEM_SIZE_DEFAULT_VALUE,
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                pagerId = JsonFieldResolver.resolveOptional(context, logger, template.pagerId, data, "pager_id"),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                shape = JsonFieldResolver.resolveOptional(context, logger, template.shape, data, "shape", component.divShapeJsonTemplateResolver, component.divShapeJsonEntityParser) ?: SHAPE_DEFAULT_VALUE,
                spaceBetweenCenters = JsonFieldResolver.resolveOptional(context, logger, template.spaceBetweenCenters, data, "space_between_centers", component.divFixedSizeJsonTemplateResolver, component.divFixedSizeJsonEntityParser) ?: SPACE_BETWEEN_CENTERS_DEFAULT_VALUE,
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ACTIVE_ITEM_COLOR_DEFAULT_VALUE = Expression.constant(0xffdc60.toInt())
        @JvmField val ACTIVE_ITEM_SIZE_DEFAULT_VALUE = Expression.constant(1.3)
        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val ANIMATION_DEFAULT_VALUE = Expression.constant(DivIndicator.Animation.SCALE)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val INACTIVE_ITEM_COLOR_DEFAULT_VALUE = Expression.constant(0x33919cb5.toInt())
        @JvmField val MINIMUM_ITEM_SIZE_DEFAULT_VALUE = Expression.constant(0.5)
        @JvmField val SHAPE_DEFAULT_VALUE = DivShape.RoundedRectangle(DivRoundedRectangleShape())
        @JvmField val SPACE_BETWEEN_CENTERS_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(15L))
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_ANIMATION = TypeHelper.from(default = DivIndicator.Animation.values().first()) { it is DivIndicator.Animation }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ACTIVE_ITEM_SIZE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val MINIMUM_ITEM_SIZE_VALIDATOR = ValueValidator<Double> { it: Double -> it > 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}
