// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

class DivInput @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val animators: List<DivAnimator>? = null,
    @JvmField val autocapitalization: Expression<Autocapitalization> = AUTOCAPITALIZATION_DEFAULT_VALUE, // default value: auto
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    @JvmField val enterKeyActions: List<DivAction>? = null,
    @JvmField val enterKeyType: Expression<EnterKeyType> = ENTER_KEY_TYPE_DEFAULT_VALUE, // default value: default
    override val extensions: List<DivExtension>? = null,
    @JvmField val filters: List<DivInputFilter>? = null,
    override val focus: DivFocus? = null,
    @JvmField val fontFamily: Expression<String>? = null,
    @JvmField val fontSize: Expression<Long> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
    @JvmField val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
    @JvmField val fontWeight: Expression<DivFontWeight> = FONT_WEIGHT_DEFAULT_VALUE, // default value: regular
    @JvmField val fontWeightValue: Expression<Long>? = null, // constraint: number > 0
    override val functions: List<DivFunction>? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField val highlightColor: Expression<Int>? = null,
    @JvmField val hintColor: Expression<Int> = HINT_COLOR_DEFAULT_VALUE, // default value: #73000000
    @JvmField val hintText: Expression<String>? = null,
    override val id: String? = null,
    @JvmField val isEnabled: Expression<Boolean> = IS_ENABLED_DEFAULT_VALUE, // default value: true
    @JvmField val keyboardType: Expression<KeyboardType> = KEYBOARD_TYPE_DEFAULT_VALUE, // default value: multi_line_text
    override val layoutProvider: DivLayoutProvider? = null,
    @JvmField val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
    @JvmField val lineHeight: Expression<Long>? = null, // constraint: number >= 0
    override val margins: DivEdgeInsets? = null,
    @JvmField val mask: DivInputMask? = null,
    @JvmField val maxLength: Expression<Long>? = null, // constraint: number > 0
    @JvmField val maxVisibleLines: Expression<Long>? = null, // constraint: number > 0
    @JvmField val nativeInterface: NativeInterface? = null,
    override val paddings: DivEdgeInsets? = null,
    override val reuseId: Expression<String>? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField val selectAllOnFocus: Expression<Boolean> = SELECT_ALL_ON_FOCUS_DEFAULT_VALUE, // default value: false
    override val selectedActions: List<DivAction>? = null,
    @JvmField val textAlignmentHorizontal: Expression<DivAlignmentHorizontal> = TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: start
    @JvmField val textAlignmentVertical: Expression<DivAlignmentVertical> = TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: center
    @JvmField val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    @JvmField val textVariable: String,
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    @JvmField val validators: List<DivInputValidator>? = null,
    override val variableTriggers: List<DivTrigger>? = null,
    override val variables: List<DivVariable>? = null,
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            this::class.hashCode() +
            (accessibility?.hash() ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (animators?.sumOf { it.hash() } ?: 0) +
            autocapitalization.hashCode() +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            (columnSpan?.hashCode() ?: 0) +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (enterKeyActions?.sumOf { it.hash() } ?: 0) +
            enterKeyType.hashCode() +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (filters?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            (fontFamily?.hashCode() ?: 0) +
            fontSize.hashCode() +
            fontSizeUnit.hashCode() +
            fontWeight.hashCode() +
            (fontWeightValue?.hashCode() ?: 0) +
            (functions?.sumOf { it.hash() } ?: 0) +
            height.hash() +
            (highlightColor?.hashCode() ?: 0) +
            hintColor.hashCode() +
            (hintText?.hashCode() ?: 0) +
            (id?.hashCode() ?: 0) +
            isEnabled.hashCode() +
            keyboardType.hashCode() +
            (layoutProvider?.hash() ?: 0) +
            letterSpacing.hashCode() +
            (lineHeight?.hashCode() ?: 0) +
            (margins?.hash() ?: 0) +
            (mask?.hash() ?: 0) +
            (maxLength?.hashCode() ?: 0) +
            (maxVisibleLines?.hashCode() ?: 0) +
            (nativeInterface?.hash() ?: 0) +
            (paddings?.hash() ?: 0) +
            (reuseId?.hashCode() ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            selectAllOnFocus.hashCode() +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            textAlignmentHorizontal.hashCode() +
            textAlignmentVertical.hashCode() +
            textColor.hashCode() +
            textVariable.hashCode() +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            (validators?.sumOf { it.hash() } ?: 0) +
            (variableTriggers?.sumOf { it.hash() } ?: 0) +
            (variables?.sumOf { it.hash() } ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    fun equals(other: DivInput?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
        other ?: return false
        return (accessibility?.equals(other.accessibility, resolver, otherResolver) ?: (other.accessibility == null)) &&
            alignmentHorizontal?.evaluate(resolver) == other.alignmentHorizontal?.evaluate(otherResolver) &&
            alignmentVertical?.evaluate(resolver) == other.alignmentVertical?.evaluate(otherResolver) &&
            alpha.evaluate(resolver) == other.alpha.evaluate(otherResolver) &&
            (animators?.compareWith(other.animators ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.animators == null)) &&
            autocapitalization.evaluate(resolver) == other.autocapitalization.evaluate(otherResolver) &&
            (background?.compareWith(other.background ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.background == null)) &&
            (border?.equals(other.border, resolver, otherResolver) ?: (other.border == null)) &&
            columnSpan?.evaluate(resolver) == other.columnSpan?.evaluate(otherResolver) &&
            (disappearActions?.compareWith(other.disappearActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.disappearActions == null)) &&
            (enterKeyActions?.compareWith(other.enterKeyActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.enterKeyActions == null)) &&
            enterKeyType.evaluate(resolver) == other.enterKeyType.evaluate(otherResolver) &&
            (extensions?.compareWith(other.extensions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.extensions == null)) &&
            (filters?.compareWith(other.filters ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.filters == null)) &&
            (focus?.equals(other.focus, resolver, otherResolver) ?: (other.focus == null)) &&
            fontFamily?.evaluate(resolver) == other.fontFamily?.evaluate(otherResolver) &&
            fontSize.evaluate(resolver) == other.fontSize.evaluate(otherResolver) &&
            fontSizeUnit.evaluate(resolver) == other.fontSizeUnit.evaluate(otherResolver) &&
            fontWeight.evaluate(resolver) == other.fontWeight.evaluate(otherResolver) &&
            fontWeightValue?.evaluate(resolver) == other.fontWeightValue?.evaluate(otherResolver) &&
            (functions?.compareWith(other.functions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.functions == null)) &&
            height.equals(other.height, resolver, otherResolver) &&
            highlightColor?.evaluate(resolver) == other.highlightColor?.evaluate(otherResolver) &&
            hintColor.evaluate(resolver) == other.hintColor.evaluate(otherResolver) &&
            hintText?.evaluate(resolver) == other.hintText?.evaluate(otherResolver) &&
            id == other.id &&
            isEnabled.evaluate(resolver) == other.isEnabled.evaluate(otherResolver) &&
            keyboardType.evaluate(resolver) == other.keyboardType.evaluate(otherResolver) &&
            (layoutProvider?.equals(other.layoutProvider, resolver, otherResolver) ?: (other.layoutProvider == null)) &&
            letterSpacing.evaluate(resolver) == other.letterSpacing.evaluate(otherResolver) &&
            lineHeight?.evaluate(resolver) == other.lineHeight?.evaluate(otherResolver) &&
            (margins?.equals(other.margins, resolver, otherResolver) ?: (other.margins == null)) &&
            (mask?.equals(other.mask, resolver, otherResolver) ?: (other.mask == null)) &&
            maxLength?.evaluate(resolver) == other.maxLength?.evaluate(otherResolver) &&
            maxVisibleLines?.evaluate(resolver) == other.maxVisibleLines?.evaluate(otherResolver) &&
            (nativeInterface?.equals(other.nativeInterface, resolver, otherResolver) ?: (other.nativeInterface == null)) &&
            (paddings?.equals(other.paddings, resolver, otherResolver) ?: (other.paddings == null)) &&
            reuseId?.evaluate(resolver) == other.reuseId?.evaluate(otherResolver) &&
            rowSpan?.evaluate(resolver) == other.rowSpan?.evaluate(otherResolver) &&
            selectAllOnFocus.evaluate(resolver) == other.selectAllOnFocus.evaluate(otherResolver) &&
            (selectedActions?.compareWith(other.selectedActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.selectedActions == null)) &&
            textAlignmentHorizontal.evaluate(resolver) == other.textAlignmentHorizontal.evaluate(otherResolver) &&
            textAlignmentVertical.evaluate(resolver) == other.textAlignmentVertical.evaluate(otherResolver) &&
            textColor.evaluate(resolver) == other.textColor.evaluate(otherResolver) &&
            textVariable == other.textVariable &&
            (tooltips?.compareWith(other.tooltips ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.tooltips == null)) &&
            (transform?.equals(other.transform, resolver, otherResolver) ?: (other.transform == null)) &&
            (transitionChange?.equals(other.transitionChange, resolver, otherResolver) ?: (other.transitionChange == null)) &&
            (transitionIn?.equals(other.transitionIn, resolver, otherResolver) ?: (other.transitionIn == null)) &&
            (transitionOut?.equals(other.transitionOut, resolver, otherResolver) ?: (other.transitionOut == null)) &&
            (transitionTriggers?.compareWith(other.transitionTriggers ?: return false) { a, b -> a == b } ?: (other.transitionTriggers == null)) &&
            (validators?.compareWith(other.validators ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.validators == null)) &&
            (variableTriggers?.compareWith(other.variableTriggers ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.variableTriggers == null)) &&
            (variables?.compareWith(other.variables ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.variables == null)) &&
            visibility.evaluate(resolver) == other.visibility.evaluate(otherResolver) &&
            (visibilityAction?.equals(other.visibilityAction, resolver, otherResolver) ?: (other.visibilityAction == null)) &&
            (visibilityActions?.compareWith(other.visibilityActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.visibilityActions == null)) &&
            width.equals(other.width, resolver, otherResolver)
    }

    fun copy(
        accessibility: DivAccessibility? = this.accessibility,
        alignmentHorizontal: Expression<DivAlignmentHorizontal>? = this.alignmentHorizontal,
        alignmentVertical: Expression<DivAlignmentVertical>? = this.alignmentVertical,
        alpha: Expression<Double> = this.alpha,
        animators: List<DivAnimator>? = this.animators,
        autocapitalization: Expression<Autocapitalization> = this.autocapitalization,
        background: List<DivBackground>? = this.background,
        border: DivBorder? = this.border,
        columnSpan: Expression<Long>? = this.columnSpan,
        disappearActions: List<DivDisappearAction>? = this.disappearActions,
        enterKeyActions: List<DivAction>? = this.enterKeyActions,
        enterKeyType: Expression<EnterKeyType> = this.enterKeyType,
        extensions: List<DivExtension>? = this.extensions,
        filters: List<DivInputFilter>? = this.filters,
        focus: DivFocus? = this.focus,
        fontFamily: Expression<String>? = this.fontFamily,
        fontSize: Expression<Long> = this.fontSize,
        fontSizeUnit: Expression<DivSizeUnit> = this.fontSizeUnit,
        fontWeight: Expression<DivFontWeight> = this.fontWeight,
        fontWeightValue: Expression<Long>? = this.fontWeightValue,
        functions: List<DivFunction>? = this.functions,
        height: DivSize = this.height,
        highlightColor: Expression<Int>? = this.highlightColor,
        hintColor: Expression<Int> = this.hintColor,
        hintText: Expression<String>? = this.hintText,
        id: String? = this.id,
        isEnabled: Expression<Boolean> = this.isEnabled,
        keyboardType: Expression<KeyboardType> = this.keyboardType,
        layoutProvider: DivLayoutProvider? = this.layoutProvider,
        letterSpacing: Expression<Double> = this.letterSpacing,
        lineHeight: Expression<Long>? = this.lineHeight,
        margins: DivEdgeInsets? = this.margins,
        mask: DivInputMask? = this.mask,
        maxLength: Expression<Long>? = this.maxLength,
        maxVisibleLines: Expression<Long>? = this.maxVisibleLines,
        nativeInterface: NativeInterface? = this.nativeInterface,
        paddings: DivEdgeInsets? = this.paddings,
        reuseId: Expression<String>? = this.reuseId,
        rowSpan: Expression<Long>? = this.rowSpan,
        selectAllOnFocus: Expression<Boolean> = this.selectAllOnFocus,
        selectedActions: List<DivAction>? = this.selectedActions,
        textAlignmentHorizontal: Expression<DivAlignmentHorizontal> = this.textAlignmentHorizontal,
        textAlignmentVertical: Expression<DivAlignmentVertical> = this.textAlignmentVertical,
        textColor: Expression<Int> = this.textColor,
        textVariable: String = this.textVariable,
        tooltips: List<DivTooltip>? = this.tooltips,
        transform: DivTransform? = this.transform,
        transitionChange: DivChangeTransition? = this.transitionChange,
        transitionIn: DivAppearanceTransition? = this.transitionIn,
        transitionOut: DivAppearanceTransition? = this.transitionOut,
        transitionTriggers: List<DivTransitionTrigger>? = this.transitionTriggers,
        validators: List<DivInputValidator>? = this.validators,
        variableTriggers: List<DivTrigger>? = this.variableTriggers,
        variables: List<DivVariable>? = this.variables,
        visibility: Expression<DivVisibility> = this.visibility,
        visibilityAction: DivVisibilityAction? = this.visibilityAction,
        visibilityActions: List<DivVisibilityAction>? = this.visibilityActions,
        width: DivSize = this.width,
    ) = DivInput(
        accessibility = accessibility,
        alignmentHorizontal = alignmentHorizontal,
        alignmentVertical = alignmentVertical,
        alpha = alpha,
        animators = animators,
        autocapitalization = autocapitalization,
        background = background,
        border = border,
        columnSpan = columnSpan,
        disappearActions = disappearActions,
        enterKeyActions = enterKeyActions,
        enterKeyType = enterKeyType,
        extensions = extensions,
        filters = filters,
        focus = focus,
        fontFamily = fontFamily,
        fontSize = fontSize,
        fontSizeUnit = fontSizeUnit,
        fontWeight = fontWeight,
        fontWeightValue = fontWeightValue,
        functions = functions,
        height = height,
        highlightColor = highlightColor,
        hintColor = hintColor,
        hintText = hintText,
        id = id,
        isEnabled = isEnabled,
        keyboardType = keyboardType,
        layoutProvider = layoutProvider,
        letterSpacing = letterSpacing,
        lineHeight = lineHeight,
        margins = margins,
        mask = mask,
        maxLength = maxLength,
        maxVisibleLines = maxVisibleLines,
        nativeInterface = nativeInterface,
        paddings = paddings,
        reuseId = reuseId,
        rowSpan = rowSpan,
        selectAllOnFocus = selectAllOnFocus,
        selectedActions = selectedActions,
        textAlignmentHorizontal = textAlignmentHorizontal,
        textAlignmentVertical = textAlignmentVertical,
        textColor = textColor,
        textVariable = textVariable,
        tooltips = tooltips,
        transform = transform,
        transitionChange = transitionChange,
        transitionIn = transitionIn,
        transitionOut = transitionOut,
        transitionTriggers = transitionTriggers,
        validators = validators,
        variableTriggers = variableTriggers,
        variables = variables,
        visibility = visibility,
        visibilityAction = visibilityAction,
        visibilityActions = visibilityActions,
        width = width,
    )

    override fun writeToJSON(): JSONObject {
        return builtInParserComponent.divInputJsonEntityParser
            .value
            .serialize(context = builtInParsingContext, value = this)
    }

    companion object {
        const val TYPE = "input"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val AUTOCAPITALIZATION_DEFAULT_VALUE = Expression.constant(Autocapitalization.AUTO)
        private val ENTER_KEY_TYPE_DEFAULT_VALUE = Expression.constant(EnterKeyType.DEFAULT)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        private val IS_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        private val KEYBOARD_TYPE_DEFAULT_VALUE = Expression.constant(KeyboardType.MULTI_LINE_TEXT)
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val SELECT_ALL_ON_FOCUS_DEFAULT_VALUE = Expression.constant(false)
        private val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        private val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivInput {
            return builtInParserComponent.divInputJsonEntityParser
                .value
                .deserialize(context = env, data = json)
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivInput(env, json = it) }
    }

    class NativeInterface @DivModelInternalApi constructor (
        @JvmField val color: Expression<Int>,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                this::class.hashCode() +
                color.hashCode()
            _hash = hash
            return hash
        }

        fun equals(other: NativeInterface?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
            other ?: return false
            return color.evaluate(resolver) == other.color.evaluate(otherResolver)
        }

        fun copy(
            color: Expression<Int> = this.color,
        ) = NativeInterface(
            color = color,
        )

        override fun writeToJSON(): JSONObject {
            return builtInParserComponent.divInputNativeInterfaceJsonEntityParser
                .value
                .serialize(context = builtInParsingContext, value = this)
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): NativeInterface {
                return builtInParserComponent.divInputNativeInterfaceJsonEntityParser
                    .value
                    .deserialize(context = env, data = json)
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> NativeInterface(env, json = it) }
        }
    }

    enum class Autocapitalization(private val value: String) {
        AUTO("auto"),
        NONE("none"),
        WORDS("words"),
        SENTENCES("sentences"),
        ALL_CHARACTERS("all_characters");

        companion object Converter {

            fun toString(obj: Autocapitalization): String {
                return obj.value
            }

            fun fromString(value: String): Autocapitalization? {
                return when (value) {
                    AUTO.value -> AUTO
                    NONE.value -> NONE
                    WORDS.value -> WORDS
                    SENTENCES.value -> SENTENCES
                    ALL_CHARACTERS.value -> ALL_CHARACTERS
                    else -> null
                }
            }

            @JvmField
            val TO_STRING = { value: Autocapitalization -> toString(value) }

            @JvmField
            val FROM_STRING = { value: String -> fromString(value) }
        }
    }

    enum class EnterKeyType(private val value: String) {
        DEFAULT("default"),
        GO("go"),
        SEARCH("search"),
        SEND("send"),
        DONE("done");

        companion object Converter {

            fun toString(obj: EnterKeyType): String {
                return obj.value
            }

            fun fromString(value: String): EnterKeyType? {
                return when (value) {
                    DEFAULT.value -> DEFAULT
                    GO.value -> GO
                    SEARCH.value -> SEARCH
                    SEND.value -> SEND
                    DONE.value -> DONE
                    else -> null
                }
            }

            @JvmField
            val TO_STRING = { value: EnterKeyType -> toString(value) }

            @JvmField
            val FROM_STRING = { value: String -> fromString(value) }
        }
    }

    enum class KeyboardType(private val value: String) {
        SINGLE_LINE_TEXT("single_line_text"),
        MULTI_LINE_TEXT("multi_line_text"),
        PHONE("phone"),
        NUMBER("number"),
        EMAIL("email"),
        URI("uri"),
        PASSWORD("password");

        companion object Converter {

            fun toString(obj: KeyboardType): String {
                return obj.value
            }

            fun fromString(value: String): KeyboardType? {
                return when (value) {
                    SINGLE_LINE_TEXT.value -> SINGLE_LINE_TEXT
                    MULTI_LINE_TEXT.value -> MULTI_LINE_TEXT
                    PHONE.value -> PHONE
                    NUMBER.value -> NUMBER
                    EMAIL.value -> EMAIL
                    URI.value -> URI
                    PASSWORD.value -> PASSWORD
                    else -> null
                }
            }

            @JvmField
            val TO_STRING = { value: KeyboardType -> toString(value) }

            @JvmField
            val FROM_STRING = { value: String -> fromString(value) }
        }
    }
}
