// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivInputJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInput> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInput {
            val logger = context.logger
            return DivInput(
                accessibility = JsonPropertyParser.readOptional(context, logger, data, "accessibility", component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, logger, data, "animators", component.divAnimatorJsonEntityParser),
                autocapitalization = JsonExpressionParser.readOptionalExpression(context, logger, data, "autocapitalization", TYPE_HELPER_AUTOCAPITALIZATION, DivInput.Autocapitalization.FROM_STRING, AUTOCAPITALIZATION_DEFAULT_VALUE) ?: AUTOCAPITALIZATION_DEFAULT_VALUE,
                background = JsonPropertyParser.readOptionalList(context, logger, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, logger, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonPropertyParser.readOptionalList(context, logger, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                enterKeyActions = JsonPropertyParser.readOptionalList(context, logger, data, "enter_key_actions", component.divActionJsonEntityParser),
                enterKeyType = JsonExpressionParser.readOptionalExpression(context, logger, data, "enter_key_type", TYPE_HELPER_ENTER_KEY_TYPE, DivInput.EnterKeyType.FROM_STRING, ENTER_KEY_TYPE_DEFAULT_VALUE) ?: ENTER_KEY_TYPE_DEFAULT_VALUE,
                extensions = JsonPropertyParser.readOptionalList(context, logger, data, "extensions", component.divExtensionJsonEntityParser),
                filters = JsonPropertyParser.readOptionalList(context, logger, data, "filters", component.divInputFilterJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, logger, data, "focus", component.divFocusJsonEntityParser),
                fontFamily = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_family", TYPE_HELPER_STRING),
                fontSize = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                fontWeightValue = JsonExpressionParser.readOptionalExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonPropertyParser.readOptionalList(context, logger, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, logger, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                highlightColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "highlight_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                hintColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "hint_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, HINT_COLOR_DEFAULT_VALUE) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonExpressionParser.readOptionalExpression(context, logger, data, "hint_text", TYPE_HELPER_STRING),
                id = JsonPropertyParser.readOptional(context, logger, data, "id"),
                isEnabled = JsonExpressionParser.readOptionalExpression(context, logger, data, "is_enabled", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, IS_ENABLED_DEFAULT_VALUE) ?: IS_ENABLED_DEFAULT_VALUE,
                keyboardType = JsonExpressionParser.readOptionalExpression(context, logger, data, "keyboard_type", TYPE_HELPER_KEYBOARD_TYPE, DivInput.KeyboardType.FROM_STRING, KEYBOARD_TYPE_DEFAULT_VALUE) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
                layoutProvider = JsonPropertyParser.readOptional(context, logger, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                letterSpacing = JsonExpressionParser.readOptionalExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonExpressionParser.readOptionalExpression(context, logger, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                margins = JsonPropertyParser.readOptional(context, logger, data, "margins", component.divEdgeInsetsJsonEntityParser),
                mask = JsonPropertyParser.readOptional(context, logger, data, "mask", component.divInputMaskJsonEntityParser),
                maxLength = JsonExpressionParser.readOptionalExpression(context, logger, data, "max_length", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_LENGTH_VALIDATOR),
                maxVisibleLines = JsonExpressionParser.readOptionalExpression(context, logger, data, "max_visible_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR),
                nativeInterface = JsonPropertyParser.readOptional(context, logger, data, "native_interface", component.divInputNativeInterfaceJsonEntityParser),
                paddings = JsonPropertyParser.readOptional(context, logger, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                reuseId = JsonExpressionParser.readOptionalExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, logger, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectAllOnFocus = JsonExpressionParser.readOptionalExpression(context, logger, data, "select_all_on_focus", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
                selectedActions = JsonPropertyParser.readOptionalList(context, logger, data, "selected_actions", component.divActionJsonEntityParser),
                textAlignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonExpressionParser.readOptionalExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
                textVariable = JsonPropertyParser.read(context, logger, data, "text_variable"),
                tooltips = JsonPropertyParser.readOptionalList(context, logger, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, logger, data, "transform", component.divTransformJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, logger, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, logger, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, logger, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                validators = JsonPropertyParser.readOptionalList(context, logger, data, "validators", component.divInputValidatorJsonEntityParser),
                variableTriggers = JsonPropertyParser.readOptionalList(context, logger, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, logger, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, logger, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, logger, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, logger, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInput): JSONObject {
            val data = JSONObject()
            data.write(key = "accessibility", value = component.divAccessibilityJsonEntityParser.value.serialize(context, value.accessibility))
            data.writeExpression(key = "alignment_horizontal", value = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "alignment_vertical", value = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "alpha", value = value.alpha)
            data.write(key = "animators", value = component.divAnimatorJsonEntityParser.value.serialize(context, value.animators))
            data.writeExpression(key = "autocapitalization", value = value.autocapitalization, converter = DivInput.Autocapitalization.TO_STRING)
            data.write(key = "background", value = component.divBackgroundJsonEntityParser.value.serialize(context, value.background))
            data.write(key = "border", value = component.divBorderJsonEntityParser.value.serialize(context, value.border))
            data.writeExpression(key = "column_span", value = value.columnSpan)
            data.write(key = "disappear_actions", value = component.divDisappearActionJsonEntityParser.value.serialize(context, value.disappearActions))
            data.write(key = "enter_key_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.enterKeyActions))
            data.writeExpression(key = "enter_key_type", value = value.enterKeyType, converter = DivInput.EnterKeyType.TO_STRING)
            data.write(key = "extensions", value = component.divExtensionJsonEntityParser.value.serialize(context, value.extensions))
            data.write(key = "filters", value = component.divInputFilterJsonEntityParser.value.serialize(context, value.filters))
            data.write(key = "focus", value = component.divFocusJsonEntityParser.value.serialize(context, value.focus))
            data.writeExpression(key = "font_family", value = value.fontFamily)
            data.writeExpression(key = "font_size", value = value.fontSize)
            data.writeExpression(key = "font_size_unit", value = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeExpression(key = "font_weight", value = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeExpression(key = "font_weight_value", value = value.fontWeightValue)
            data.write(key = "functions", value = component.divFunctionJsonEntityParser.value.serialize(context, value.functions))
            data.write(key = "height", value = component.divSizeJsonEntityParser.value.serialize(context, value.height))
            data.writeExpression(key = "highlight_color", value = value.highlightColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "hint_color", value = value.hintColor, converter = COLOR_INT_TO_STRING)
            data.writeExpression(key = "hint_text", value = value.hintText)
            data.write(key = "id", value = value.id)
            data.writeExpression(key = "is_enabled", value = value.isEnabled)
            data.writeExpression(key = "keyboard_type", value = value.keyboardType, converter = DivInput.KeyboardType.TO_STRING)
            data.write(key = "layout_provider", value = component.divLayoutProviderJsonEntityParser.value.serialize(context, value.layoutProvider))
            data.writeExpression(key = "letter_spacing", value = value.letterSpacing)
            data.writeExpression(key = "line_height", value = value.lineHeight)
            data.write(key = "margins", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.margins))
            data.write(key = "mask", value = component.divInputMaskJsonEntityParser.value.serialize(context, value.mask))
            data.writeExpression(key = "max_length", value = value.maxLength)
            data.writeExpression(key = "max_visible_lines", value = value.maxVisibleLines)
            data.write(key = "native_interface", value = component.divInputNativeInterfaceJsonEntityParser.value.serialize(context, value.nativeInterface))
            data.write(key = "paddings", value = component.divEdgeInsetsJsonEntityParser.value.serialize(context, value.paddings))
            data.writeExpression(key = "reuse_id", value = value.reuseId)
            data.writeExpression(key = "row_span", value = value.rowSpan)
            data.writeExpression(key = "select_all_on_focus", value = value.selectAllOnFocus)
            data.write(key = "selected_actions", value = component.divActionJsonEntityParser.value.serialize(context, value.selectedActions))
            data.writeExpression(key = "text_alignment_horizontal", value = value.textAlignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeExpression(key = "text_alignment_vertical", value = value.textAlignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeExpression(key = "text_color", value = value.textColor, converter = COLOR_INT_TO_STRING)
            data.write(key = "text_variable", value = value.textVariable)
            data.write(key = "tooltips", value = component.divTooltipJsonEntityParser.value.serialize(context, value.tooltips))
            data.write(key = "transform", value = component.divTransformJsonEntityParser.value.serialize(context, value.transform))
            data.write(key = "transition_change", value = component.divChangeTransitionJsonEntityParser.value.serialize(context, value.transitionChange))
            data.write(key = "transition_in", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionIn))
            data.write(key = "transition_out", value = component.divAppearanceTransitionJsonEntityParser.value.serialize(context, value.transitionOut))
            data.write(key = "transition_triggers", value = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivInput.TYPE)
            data.write(key = "validators", value = component.divInputValidatorJsonEntityParser.value.serialize(context, value.validators))
            data.write(key = "variable_triggers", value = component.divTriggerJsonEntityParser.value.serialize(context, value.variableTriggers))
            data.write(key = "variables", value = component.divVariableJsonEntityParser.value.serialize(context, value.variables))
            data.writeExpression(key = "visibility", value = value.visibility, converter = DivVisibility.TO_STRING)
            data.write(key = "visibility_action", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityAction))
            data.write(key = "visibility_actions", value = component.divVisibilityActionJsonEntityParser.value.serialize(context, value.visibilityActions))
            data.write(key = "width", value = component.divSizeJsonEntityParser.value.serialize(context, value.width))
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivInputTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivInputTemplate?, data: JSONObject): DivInputTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivInputTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, logger, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, logger, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                autocapitalization = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "autocapitalization", TYPE_HELPER_AUTOCAPITALIZATION, allowOverride, parent?.autocapitalization, DivInput.Autocapitalization.FROM_STRING),
                background = JsonFieldParser.readOptionalListField(context, logger, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, logger, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, logger, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                enterKeyActions = JsonFieldParser.readOptionalListField(context, logger, data, "enter_key_actions", allowOverride, parent?.enterKeyActions, component.divActionJsonTemplateParser),
                enterKeyType = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "enter_key_type", TYPE_HELPER_ENTER_KEY_TYPE, allowOverride, parent?.enterKeyType, DivInput.EnterKeyType.FROM_STRING),
                extensions = JsonFieldParser.readOptionalListField(context, logger, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                filters = JsonFieldParser.readOptionalListField(context, logger, data, "filters", allowOverride, parent?.filters, component.divInputFilterJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, logger, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                fontFamily = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_family", TYPE_HELPER_STRING, allowOverride, parent?.fontFamily),
                fontSize = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size", TYPE_HELPER_INT, allowOverride, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, allowOverride, parent?.fontSizeUnit, DivSizeUnit.FROM_STRING),
                fontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, allowOverride, parent?.fontWeight, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "font_weight_value", TYPE_HELPER_INT, allowOverride, parent?.fontWeightValue, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonFieldParser.readOptionalListField(context, logger, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, logger, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                highlightColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "highlight_color", TYPE_HELPER_COLOR, allowOverride, parent?.highlightColor, STRING_TO_COLOR_INT),
                hintColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "hint_color", TYPE_HELPER_COLOR, allowOverride, parent?.hintColor, STRING_TO_COLOR_INT),
                hintText = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "hint_text", TYPE_HELPER_STRING, allowOverride, parent?.hintText),
                id = JsonFieldParser.readOptionalField(context, logger, data, "id", allowOverride, parent?.id),
                isEnabled = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "is_enabled", TYPE_HELPER_BOOLEAN, allowOverride, parent?.isEnabled, ANY_TO_BOOLEAN),
                keyboardType = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "keyboard_type", TYPE_HELPER_KEYBOARD_TYPE, allowOverride, parent?.keyboardType, DivInput.KeyboardType.FROM_STRING),
                layoutProvider = JsonFieldParser.readOptionalField(context, logger, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                letterSpacing = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "letter_spacing", TYPE_HELPER_DOUBLE, allowOverride, parent?.letterSpacing, NUMBER_TO_DOUBLE),
                lineHeight = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "line_height", TYPE_HELPER_INT, allowOverride, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                margins = JsonFieldParser.readOptionalField(context, logger, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                mask = JsonFieldParser.readOptionalField(context, logger, data, "mask", allowOverride, parent?.mask, component.divInputMaskJsonTemplateParser),
                maxLength = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "max_length", TYPE_HELPER_INT, allowOverride, parent?.maxLength, NUMBER_TO_INT, MAX_LENGTH_VALIDATOR),
                maxVisibleLines = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "max_visible_lines", TYPE_HELPER_INT, allowOverride, parent?.maxVisibleLines, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR),
                nativeInterface = JsonFieldParser.readOptionalField(context, logger, data, "native_interface", allowOverride, parent?.nativeInterface, component.divInputNativeInterfaceJsonTemplateParser),
                paddings = JsonFieldParser.readOptionalField(context, logger, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectAllOnFocus = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "select_all_on_focus", TYPE_HELPER_BOOLEAN, allowOverride, parent?.selectAllOnFocus, ANY_TO_BOOLEAN),
                selectedActions = JsonFieldParser.readOptionalListField(context, logger, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                textAlignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, allowOverride, parent?.textAlignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                textAlignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, allowOverride, parent?.textAlignmentVertical, DivAlignmentVertical.FROM_STRING),
                textColor = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "text_color", TYPE_HELPER_COLOR, allowOverride, parent?.textColor, STRING_TO_COLOR_INT),
                textVariable = JsonFieldParser.readField(context, logger, data, "text_variable", allowOverride, parent?.textVariable),
                tooltips = JsonFieldParser.readOptionalListField(context, logger, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, logger, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, logger, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, logger, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, logger, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                validators = JsonFieldParser.readOptionalListField(context, logger, data, "validators", allowOverride, parent?.validators, component.divInputValidatorJsonTemplateParser),
                variableTriggers = JsonFieldParser.readOptionalListField(context, logger, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, logger, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, logger, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, logger, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, logger, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, logger, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputTemplate): JSONObject {
            val data = JSONObject()
            data.writeField(key = "accessibility", field = value.accessibility, converter = component.divAccessibilityJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "alignment_horizontal", field = value.alignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "alignment_vertical", field = value.alignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "alpha", field = value.alpha)
            data.writeField(key = "animators", field = value.animators, converter = component.divAnimatorJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "autocapitalization", field = value.autocapitalization, converter = DivInput.Autocapitalization.TO_STRING)
            data.writeField(key = "background", field = value.background, converter = component.divBackgroundJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "border", field = value.border, converter = component.divBorderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "column_span", field = value.columnSpan)
            data.writeField(key = "disappear_actions", field = value.disappearActions, converter = component.divDisappearActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "enter_key_actions", field = value.enterKeyActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "enter_key_type", field = value.enterKeyType, converter = DivInput.EnterKeyType.TO_STRING)
            data.writeField(key = "extensions", field = value.extensions, converter = component.divExtensionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "filters", field = value.filters, converter = component.divInputFilterJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "focus", field = value.focus, converter = component.divFocusJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "font_family", field = value.fontFamily)
            data.writeFieldWithExpression(key = "font_size", field = value.fontSize)
            data.writeFieldWithExpression(key = "font_size_unit", field = value.fontSizeUnit, converter = DivSizeUnit.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight", field = value.fontWeight, converter = DivFontWeight.TO_STRING)
            data.writeFieldWithExpression(key = "font_weight_value", field = value.fontWeightValue)
            data.writeField(key = "functions", field = value.functions, converter = component.divFunctionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "height", field = value.height, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "highlight_color", field = value.highlightColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "hint_color", field = value.hintColor, converter = COLOR_INT_TO_STRING)
            data.writeFieldWithExpression(key = "hint_text", field = value.hintText)
            data.writeField(key = "id", field = value.id)
            data.writeFieldWithExpression(key = "is_enabled", field = value.isEnabled)
            data.writeFieldWithExpression(key = "keyboard_type", field = value.keyboardType, converter = DivInput.KeyboardType.TO_STRING)
            data.writeField(key = "layout_provider", field = value.layoutProvider, converter = component.divLayoutProviderJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "letter_spacing", field = value.letterSpacing)
            data.writeFieldWithExpression(key = "line_height", field = value.lineHeight)
            data.writeField(key = "margins", field = value.margins, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "mask", field = value.mask, converter = component.divInputMaskJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "max_length", field = value.maxLength)
            data.writeFieldWithExpression(key = "max_visible_lines", field = value.maxVisibleLines)
            data.writeField(key = "native_interface", field = value.nativeInterface, converter = component.divInputNativeInterfaceJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "paddings", field = value.paddings, converter = component.divEdgeInsetsJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "reuse_id", field = value.reuseId)
            data.writeFieldWithExpression(key = "row_span", field = value.rowSpan)
            data.writeFieldWithExpression(key = "select_all_on_focus", field = value.selectAllOnFocus)
            data.writeField(key = "selected_actions", field = value.selectedActions, converter = component.divActionJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "text_alignment_horizontal", field = value.textAlignmentHorizontal, converter = DivAlignmentHorizontal.TO_STRING)
            data.writeFieldWithExpression(key = "text_alignment_vertical", field = value.textAlignmentVertical, converter = DivAlignmentVertical.TO_STRING)
            data.writeFieldWithExpression(key = "text_color", field = value.textColor, converter = COLOR_INT_TO_STRING)
            data.writeField(key = "text_variable", field = value.textVariable)
            data.writeField(key = "tooltips", field = value.tooltips, converter = component.divTooltipJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transform", field = value.transform, converter = component.divTransformJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_change", field = value.transitionChange, converter = component.divChangeTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_in", field = value.transitionIn, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_out", field = value.transitionOut, converter = component.divAppearanceTransitionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "transition_triggers", field = value.transitionTriggers, converter = DivTransitionTrigger.TO_STRING)
            data.write(key = "type", value = DivInput.TYPE)
            data.writeField(key = "validators", field = value.validators, converter = component.divInputValidatorJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variable_triggers", field = value.variableTriggers, converter = component.divTriggerJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "variables", field = value.variables, converter = component.divVariableJsonTemplateParser.value.asConverter(context))
            data.writeFieldWithExpression(key = "visibility", field = value.visibility, converter = DivVisibility.TO_STRING)
            data.writeField(key = "visibility_action", field = value.visibilityAction, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "visibility_actions", field = value.visibilityActions, converter = component.divVisibilityActionJsonTemplateParser.value.asConverter(context))
            data.writeField(key = "width", field = value.width, converter = component.divSizeJsonTemplateParser.value.asConverter(context))
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputTemplate, DivInput> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputTemplate, data: JSONObject): DivInput {
            val logger = context.logger
            return DivInput(
                accessibility = JsonFieldResolver.resolveOptional(context, logger, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, logger, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, logger, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                autocapitalization = JsonFieldResolver.resolveOptionalExpression(context, logger, template.autocapitalization, data, "autocapitalization", TYPE_HELPER_AUTOCAPITALIZATION, DivInput.Autocapitalization.FROM_STRING, AUTOCAPITALIZATION_DEFAULT_VALUE) ?: AUTOCAPITALIZATION_DEFAULT_VALUE,
                background = JsonFieldResolver.resolveOptionalList(context, logger, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, logger, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, logger, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                enterKeyActions = JsonFieldResolver.resolveOptionalList(context, logger, template.enterKeyActions, data, "enter_key_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                enterKeyType = JsonFieldResolver.resolveOptionalExpression(context, logger, template.enterKeyType, data, "enter_key_type", TYPE_HELPER_ENTER_KEY_TYPE, DivInput.EnterKeyType.FROM_STRING, ENTER_KEY_TYPE_DEFAULT_VALUE) ?: ENTER_KEY_TYPE_DEFAULT_VALUE,
                extensions = JsonFieldResolver.resolveOptionalList(context, logger, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                filters = JsonFieldResolver.resolveOptionalList(context, logger, template.filters, data, "filters", component.divInputFilterJsonTemplateResolver, component.divInputFilterJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, logger, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                fontFamily = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontFamily, data, "font_family", TYPE_HELPER_STRING),
                fontSize = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSize, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontSizeUnit, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontWeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeight, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING, FONT_WEIGHT_DEFAULT_VALUE) ?: FONT_WEIGHT_DEFAULT_VALUE,
                fontWeightValue = JsonFieldResolver.resolveOptionalExpression(context, logger, template.fontWeightValue, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonFieldResolver.resolveOptionalList(context, logger, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, logger, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                highlightColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.highlightColor, data, "highlight_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                hintColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.hintColor, data, "hint_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, HINT_COLOR_DEFAULT_VALUE) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonFieldResolver.resolveOptionalExpression(context, logger, template.hintText, data, "hint_text", TYPE_HELPER_STRING),
                id = JsonFieldResolver.resolveOptional(context, logger, template.id, data, "id"),
                isEnabled = JsonFieldResolver.resolveOptionalExpression(context, logger, template.isEnabled, data, "is_enabled", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, IS_ENABLED_DEFAULT_VALUE) ?: IS_ENABLED_DEFAULT_VALUE,
                keyboardType = JsonFieldResolver.resolveOptionalExpression(context, logger, template.keyboardType, data, "keyboard_type", TYPE_HELPER_KEYBOARD_TYPE, DivInput.KeyboardType.FROM_STRING, KEYBOARD_TYPE_DEFAULT_VALUE) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
                layoutProvider = JsonFieldResolver.resolveOptional(context, logger, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                letterSpacing = JsonFieldResolver.resolveOptionalExpression(context, logger, template.letterSpacing, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonFieldResolver.resolveOptionalExpression(context, logger, template.lineHeight, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                margins = JsonFieldResolver.resolveOptional(context, logger, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                mask = JsonFieldResolver.resolveOptional(context, logger, template.mask, data, "mask", component.divInputMaskJsonTemplateResolver, component.divInputMaskJsonEntityParser),
                maxLength = JsonFieldResolver.resolveOptionalExpression(context, logger, template.maxLength, data, "max_length", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_LENGTH_VALIDATOR),
                maxVisibleLines = JsonFieldResolver.resolveOptionalExpression(context, logger, template.maxVisibleLines, data, "max_visible_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR),
                nativeInterface = JsonFieldResolver.resolveOptional(context, logger, template.nativeInterface, data, "native_interface", component.divInputNativeInterfaceJsonTemplateResolver, component.divInputNativeInterfaceJsonEntityParser),
                paddings = JsonFieldResolver.resolveOptional(context, logger, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, logger, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, logger, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectAllOnFocus = JsonFieldResolver.resolveOptionalExpression(context, logger, template.selectAllOnFocus, data, "select_all_on_focus", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
                selectedActions = JsonFieldResolver.resolveOptionalList(context, logger, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                textAlignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textAlignmentHorizontal, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textAlignmentVertical, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonFieldResolver.resolveOptionalExpression(context, logger, template.textColor, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
                textVariable = JsonFieldResolver.resolve(context, logger, template.textVariable, data, "text_variable"),
                tooltips = JsonFieldResolver.resolveOptionalList(context, logger, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, logger, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, logger, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, logger, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, logger, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                validators = JsonFieldResolver.resolveOptionalList(context, logger, template.validators, data, "validators", component.divInputValidatorJsonTemplateResolver, component.divInputValidatorJsonEntityParser),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, logger, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, logger, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, logger, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, logger, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, logger, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, logger, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val AUTOCAPITALIZATION_DEFAULT_VALUE = Expression.constant(DivInput.Autocapitalization.AUTO)
        @JvmField val ENTER_KEY_TYPE_DEFAULT_VALUE = Expression.constant(DivInput.EnterKeyType.DEFAULT)
        @JvmField val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        @JvmField val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        @JvmField val FONT_WEIGHT_DEFAULT_VALUE = Expression.constant(DivFontWeight.REGULAR)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        @JvmField val IS_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        @JvmField val KEYBOARD_TYPE_DEFAULT_VALUE = Expression.constant(DivInput.KeyboardType.MULTI_LINE_TEXT)
        @JvmField val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        @JvmField val SELECT_ALL_ON_FOCUS_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        @JvmField val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        @JvmField val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_AUTOCAPITALIZATION = TypeHelper.from(default = DivInput.Autocapitalization.values().first()) { it is DivInput.Autocapitalization }
        @JvmField val TYPE_HELPER_ENTER_KEY_TYPE = TypeHelper.from(default = DivInput.EnterKeyType.values().first()) { it is DivInput.EnterKeyType }
        @JvmField val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.values().first()) { it is DivSizeUnit }
        @JvmField val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        @JvmField val TYPE_HELPER_KEYBOARD_TYPE = TypeHelper.from(default = DivInput.KeyboardType.values().first()) { it is DivInput.KeyboardType }
        @JvmField val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.values().first()) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_WEIGHT_VALUE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val MAX_LENGTH_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val MAX_VISIBLE_LINES_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivInputNativeInterfaceJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInput.NativeInterface> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInput.NativeInterface {
            val logger = context.logger
            return DivInput.NativeInterface(
                color = JsonExpressionParser.readExpression(context, logger, data, "color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInput.NativeInterface): JSONObject {
            val data = JSONObject()
            data.writeExpression(key = "color", value = value.color, converter = COLOR_INT_TO_STRING)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivInputTemplate.NativeInterfaceTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivInputTemplate.NativeInterfaceTemplate?, data: JSONObject): DivInputTemplate.NativeInterfaceTemplate {
            val logger = context.logger
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivInputTemplate.NativeInterfaceTemplate(
                color = JsonFieldParser.readFieldWithExpression(context, logger, data, "color", TYPE_HELPER_COLOR, allowOverride, parent?.color, STRING_TO_COLOR_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputTemplate.NativeInterfaceTemplate): JSONObject {
            val data = JSONObject()
            data.writeFieldWithExpression(key = "color", field = value.color, converter = COLOR_INT_TO_STRING)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputTemplate.NativeInterfaceTemplate, DivInput.NativeInterface> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputTemplate.NativeInterfaceTemplate, data: JSONObject): DivInput.NativeInterface {
            val logger = context.logger
            return DivInput.NativeInterface(
                color = JsonFieldResolver.resolveExpression(context, logger, template.color, data, "color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
            )
        }
    }
}
