// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivInputMaskJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInputMask> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInputMask {
            val type: String = JsonPropertyParser.readString(data, "type")
            when (type) {
                DivFixedLengthInputMask.TYPE -> return DivInputMask.FixedLength(component.divFixedLengthInputMaskJsonEntityParser.value.deserialize(context, data))
                DivCurrencyInputMask.TYPE -> return DivInputMask.Currency(component.divCurrencyInputMaskJsonEntityParser.value.deserialize(context, data))
                DivPhoneInputMask.TYPE -> return DivInputMask.Phone(component.divPhoneInputMaskJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivInputMaskTemplate
            if (template != null) {
                return component.divInputMaskJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputMask): JSONObject {
            return when (value) {
                is DivInputMask.FixedLength -> component.divFixedLengthInputMaskJsonEntityParser.value.serialize(context, value.value)
                is DivInputMask.Currency -> component.divCurrencyInputMaskJsonEntityParser.value.serialize(context, value.value)
                is DivInputMask.Phone -> component.divPhoneInputMaskJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInputMaskTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInputMaskTemplate {
            val extendedType = JsonPropertyParser.readString(data, "type")
            val parent = context.templates[extendedType] as? DivInputMaskTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivFixedLengthInputMaskTemplate.TYPE -> return DivInputMaskTemplate.FixedLength(component.divFixedLengthInputMaskJsonTemplateParser.value.deserialize(context, parent?.value() as DivFixedLengthInputMaskTemplate?, data))
                DivCurrencyInputMaskTemplate.TYPE -> return DivInputMaskTemplate.Currency(component.divCurrencyInputMaskJsonTemplateParser.value.deserialize(context, parent?.value() as DivCurrencyInputMaskTemplate?, data))
                DivPhoneInputMaskTemplate.TYPE -> return DivInputMaskTemplate.Phone(component.divPhoneInputMaskJsonTemplateParser.value.deserialize(context, parent?.value() as DivPhoneInputMaskTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputMaskTemplate): JSONObject {
            return when (value) {
                is DivInputMaskTemplate.FixedLength -> component.divFixedLengthInputMaskJsonTemplateParser.value.serialize(context, value.value)
                is DivInputMaskTemplate.Currency -> component.divCurrencyInputMaskJsonTemplateParser.value.serialize(context, value.value)
                is DivInputMaskTemplate.Phone -> component.divPhoneInputMaskJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputMaskTemplate, DivInputMask> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputMaskTemplate, data: JSONObject): DivInputMask {
            return when (template) {
                is DivInputMaskTemplate.FixedLength -> DivInputMask.FixedLength(component.divFixedLengthInputMaskJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivInputMaskTemplate.Currency -> DivInputMask.Currency(component.divCurrencyInputMaskJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivInputMaskTemplate.Phone -> DivInputMask.Phone(component.divPhoneInputMaskJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
